/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.message.ManagedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public abstract class Source
extends Actor {
    private static final long serialVersionUID = -791693375286296102L;
    private static Logger logger = LoggerFactory.getLogger(Source.class);
    private ManagedMessage message = null;
    public Port output = PortFactory.getInstance().createOutputPort((Entity)this);
    private boolean noMoreMessages = false;

    public Source(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:orange;stroke:orange\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<circle cx=\"0\" cy=\"0\" r=\"10\"style=\"fill:white;stroke-width:2.0\"/>\n<line x1=\"-15\" y1=\"0\" x2=\"0\" y2=\"0\" style=\"stroke-width:2.0\"/>\n<line x1=\"-3\" y1=\"-3\" x2=\"0\" y2=\"0\" style=\"stroke-width:2.0\"/>\n<line x1=\"-3\" y1=\"3\" x2=\"0\" y2=\"0\" style=\"stroke-width:2.0\"/>\n</svg>\n");
    }

    @Override
    protected boolean doPreFire() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doPreFire() - entry");
        }
        this.message = this.getMessage();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doPreFire() - exit");
        }
        return super.doPreFire();
    }

    @Override
    protected void doFire() throws ProcessingException {
        block8: {
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(this.getInfo()) + " doFire() - entry");
            }
            if (this.message != null) {
                this.notifyStartingFireProcessing();
                this.noMoreMessages = false;
                try {
                    try {
                        this.sendOutputMsg(this.output, this.message);
                        break block8;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception " + illegalArgumentException, this.message, illegalArgumentException);
                    }
                }
                finally {
                    this.notifyFinishedFireProcessing();
                }
            }
            this.noMoreMessages = true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doFire() - exit");
        }
    }

    @Override
    protected boolean doPostFire() throws ProcessingException {
        boolean bl;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doPostFire() - entry");
        }
        boolean bl2 = bl = !this.hasNoMoreMessages();
        if (!bl) {
            this.requestFinish();
        } else {
            bl = super.doPostFire();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doPostFire() - exit :" + bl);
        }
        return bl;
    }

    protected abstract ManagedMessage getMessage() throws ProcessingException;

    public boolean hasNoMoreMessages() {
        return this.noMoreMessages;
    }

    @Override
    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        this.noMoreMessages = false;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }
}

