/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.actor.gui.style.CheckBoxStyle;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public abstract class Sink
extends Actor {
    private static Logger logger = LoggerFactory.getLogger(Sink.class);
    protected ManagedMessage message = null;
    public Port input = PortFactory.getInstance().createInputPort((Entity)this, null);
    private PortHandler inputHandler = null;
    private boolean passThrough = false;
    public Parameter passThroughParam = new Parameter((NamedObj)this, "PassThrough", (Token)new BooleanToken(false));
    public static final String PASSTHROUGH_PARAM = "PassThrough";

    public Sink(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.passThroughParam.setTypeEquals((Type)BaseType.BOOLEAN);
        this.registerExpertParameter(this.passThroughParam);
        new CheckBoxStyle(this.passThroughParam, "style");
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:green;stroke:green\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<circle cx=\"0\" cy=\"0\" r=\"10\"style=\"fill:white;stroke-width:2.0\"/>\n<line x1=\"0\" y1=\"0\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0\"/>\n<line x1=\"12\" y1=\"-3\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0\"/>\n<line x1=\"12\" y1=\"3\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0\"/>\n</svg>\n");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.passThroughParam) {
            this.setPassThrough(((BooleanToken)this.passThroughParam.getToken()).booleanValue());
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    @Override
    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        if (this.input.getWidth() > 0) {
            this.inputHandler = new PortHandler((IOPort)this.input);
            this.inputHandler.start();
        } else {
            this.requestFinish();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    public boolean isPassThrough() {
        return this.passThrough;
    }

    public void setPassThrough(boolean bl) {
        this.passThrough = bl;
    }

    @Override
    protected boolean doPreFire() throws ProcessingException {
        Token token;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doPreFire() - entry");
        }
        if ((token = this.inputHandler.getToken()) != null) {
            try {
                this.message = MessageHelper.getMessageFromToken(token);
            }
            catch (PasserelleException passerelleException) {
                throw new ProcessingException("Error handling token", token, passerelleException);
            }
        } else {
            this.message = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doPreFire() - exit");
        }
        return super.doPreFire();
    }

    @Override
    protected final void doFire() throws ProcessingException {
        block9: {
            if (logger.isTraceEnabled()) {
                logger.trace(this.getInfo());
            }
            if (this.message != null) {
                this.notifyStartingFireProcessing();
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info(String.valueOf(this.getInfo()) + " - Sink generated message :" + this.message);
                    }
                    this.sendMessage(this.message);
                    break block9;
                }
                finally {
                    this.notifyFinishedFireProcessing();
                }
            }
            this.requestFinish();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    @Override
    protected String getExtendedInfo() {
        return null;
    }

    protected abstract void sendMessage(ManagedMessage var1) throws ProcessingException;
}

