/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor;

import com.isencia.message.ChannelException;
import com.isencia.message.IReceiverChannel;
import com.isencia.message.NoMoreMessagesException;
import com.isencia.message.interceptor.IMessageInterceptor;
import com.isencia.message.interceptor.IMessageInterceptorChain;
import com.isencia.message.interceptor.MessageInterceptorChain;
import com.isencia.message.requestreply.IMessage;
import com.isencia.message.requestreply.IRequestReplyChannel;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Source;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.core.PortListenerAdapter;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.MessageFactory;
import com.isencia.passerelle.message.MessageHelper;
import com.isencia.passerelle.message.interceptor.MessageToTextConverter;
import com.isencia.passerelle.message.xml.XmlMessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.actor.gui.style.CheckBoxStyle;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public abstract class ReqReplyChannelSource
extends Source {
    private static Logger logger = LoggerFactory.getLogger(ReqReplyChannelSource.class);
    private IRequestReplyChannel receiverChannel = null;
    public Parameter passThroughParam = null;
    private boolean passThrough = true;
    public Port replyPort = PortFactory.getInstance().createInputPort((Entity)this, "reply", null);
    private PortHandler replyHandler = null;

    public ReqReplyChannelSource(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.passThroughParam = new Parameter((NamedObj)this, "PassThrough", (Token)new BooleanToken(false));
        this.passThroughParam.setTypeEquals((Type)BaseType.BOOLEAN);
        this.registerExpertParameter(this.passThroughParam);
        new CheckBoxStyle(this.passThroughParam, "style");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.passThroughParam) {
            this.passThrough = ((BooleanToken)this.passThroughParam.getToken()).booleanValue();
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    public IRequestReplyChannel getChannel() {
        return this.receiverChannel;
    }

    @Override
    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        super.doInitialize();
        if (this.replyPort.getWidth() > 0) {
            this.replyHandler = new PortHandler((IOPort)this.replyPort, new PortListenerAdapter(){

                @Override
                public void tokenReceived() {
                    Token token;
                    if (logger.isTraceEnabled()) {
                        logger.trace(String.valueOf(ReqReplyChannelSource.this.getInfo()) + " - inputHandler.tokenReceived() - entry");
                    }
                    if ((token = ReqReplyChannelSource.this.replyHandler.getToken()) != null) {
                        try {
                            ManagedMessage managedMessage = MessageHelper.getMessageFromToken(token);
                            if (logger.isInfoEnabled()) {
                                logger.info(String.valueOf(ReqReplyChannelSource.this.getInfo()) + " - received reply msg :" + managedMessage);
                            }
                            try {
                                ReqReplyChannelSource.this.getChannel().sendResponse((Object)managedMessage, (Object)managedMessage.getCorrelationID());
                            }
                            catch (ChannelException channelException) {
                                try {
                                    ReqReplyChannelSource.this.sendErrorMessage(new ProcessingException("Failed to send reply msg", managedMessage, channelException));
                                }
                                catch (IllegalActionException illegalActionException) {
                                    logger.error("", (Throwable)channelException);
                                    logger.error("", (Throwable)illegalActionException);
                                }
                            }
                        }
                        catch (Exception exception) {
                            logger.error("", (Throwable)exception);
                        }
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace(String.valueOf(ReqReplyChannelSource.this.getInfo()) + " - inputHandler.tokenReceived() - exit");
                    }
                }
            });
            this.replyHandler.start();
        }
        IRequestReplyChannel iRequestReplyChannel = null;
        try {
            iRequestReplyChannel = this.createChannel();
        }
        catch (ChannelException channelException) {
            throw new InitializationException(PasserelleException.Severity.FATAL, "Receiver channel for " + this.getInfo() + " not created correctly.", this, channelException);
        }
        if (iRequestReplyChannel == null) {
            throw new InitializationException(PasserelleException.Severity.FATAL, "Receiver channel for " + this.getInfo() + " not created correctly.", this, null);
        }
        try {
            this.closeChannel((IReceiverChannel)this.getChannel());
        }
        catch (ChannelException channelException) {
            throw new InitializationException("Receiver channel for " + this.getInfo() + " not initialized correctly.", this.getChannel(), channelException);
        }
        this.receiverChannel = iRequestReplyChannel;
        if (!this.isPassThrough()) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getInfo()) + "Converting message to text");
            }
            MessageInterceptorChain messageInterceptorChain = new MessageInterceptorChain();
            messageInterceptorChain.add((IMessageInterceptor)new MessageToTextConverter());
            this.getChannel().setInterceptorChainForResponse((IMessageInterceptorChain)messageInterceptorChain);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    @Override
    protected boolean doPreFire() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        boolean bl = true;
        try {
            if (!this.getChannel().isOpen()) {
                this.openChannel((IReceiverChannel)this.getChannel());
                if (logger.isInfoEnabled()) {
                    logger.info(String.valueOf(this.getInfo()) + " - Opened :" + this.getChannel());
                }
            }
        }
        catch (ChannelException channelException) {
            throw new ProcessingException(PasserelleException.Severity.FATAL, "Receiver channel for " + this.getInfo() + " not opened correctly.", this.getChannel(), channelException);
        }
        boolean bl2 = bl = bl && super.doPreFire();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit " + " :" + bl);
        }
        return bl;
    }

    @Override
    protected boolean doPostFire() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        try {
            if (this.hasNoMoreMessages()) {
                this.closeChannel((IReceiverChannel)this.getChannel());
            }
        }
        catch (ChannelException channelException) {
            throw new ProcessingException("Receiver channel for " + this.getInfo() + " not closed correctly.", this.getChannel(), channelException);
        }
        boolean bl = super.doPostFire();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit " + " :" + bl);
        }
        return bl;
    }

    @Override
    protected void doWrapUp() throws TerminationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        try {
            this.closeChannel((IReceiverChannel)this.getChannel());
            if (logger.isInfoEnabled()) {
                logger.info(String.valueOf(this.getInfo()) + " - Closed :" + this.getChannel());
            }
        }
        catch (ChannelException channelException) {
            throw new TerminationException("Receiver channel for " + this.getInfo() + " not closed correctly.", this.getChannel(), channelException);
        }
        super.doWrapUp();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected abstract IRequestReplyChannel createChannel() throws ChannelException, InitializationException;

    @Override
    protected ManagedMessage getMessage() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        ManagedMessage managedMessage = null;
        try {
            IMessage iMessage = this.getChannel().receiveRequest();
            if (this.isPassThrough()) {
                managedMessage = XmlMessageHelper.fillMessageContentFromXML(this.createMessage(), (String)iMessage.getMessage());
            } else {
                managedMessage = MessageFactory.getInstance().createCorrelatedMessage(iMessage.getCorrelationID().toString(), this.getStandardMessageHeaders());
                try {
                    managedMessage.setBodyContentPlainText(iMessage.getMessage().toString());
                }
                catch (MessageException messageException) {
                    logger.error(messageException.getMessage());
                    managedMessage = null;
                }
            }
        }
        catch (NoMoreMessagesException noMoreMessagesException) {
        }
        catch (Exception exception) {
            throw new ProcessingException(String.valueOf(this.getInfo()) + " - getMessage() generated exception", managedMessage, exception);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit " + " - Received msg :" + managedMessage);
        }
        return managedMessage;
    }

    protected void closeChannel(IReceiverChannel iReceiverChannel) throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + iReceiverChannel);
        }
        if (iReceiverChannel != null && iReceiverChannel.isOpen()) {
            iReceiverChannel.close();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void openChannel(IReceiverChannel iReceiverChannel) throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + iReceiverChannel);
        }
        if (iReceiverChannel != null && !iReceiverChannel.isOpen()) {
            iReceiverChannel.open();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    public boolean isPassThrough() {
        return this.passThrough;
    }

    public void setPassThrough(boolean bl) {
        this.passThrough = bl;
    }
}

