/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor;

import com.isencia.message.IMessageSender;
import com.isencia.message.ISenderChannel;
import com.isencia.message.interceptor.IMessageInterceptor;
import com.isencia.message.interceptor.IMessageInterceptorChain;
import com.isencia.message.interceptor.MessageInterceptorChain;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Sink;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.interceptor.MessageToTextConverter;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public abstract class MessageSenderSink
extends Sink {
    private static Logger logger = LoggerFactory.getLogger(MessageSenderSink.class);
    private IMessageSender messageSender = null;

    public MessageSenderSink(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
    }

    @Override
    protected void sendMessage(ManagedMessage managedMessage) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        if (managedMessage != null) {
            this.messageSender.sendMessage((Object)managedMessage);
        } else {
            this.requestFinish();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    @Override
    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        super.doInitialize();
        this.messageSender = this.createMessageSender();
        if (this.messageSender == null) {
            throw new InitializationException(PasserelleException.Severity.FATAL, "MessageSender for " + this.getInfo() + " not created correctly.", this, null);
        }
        IMessageInterceptorChain iMessageInterceptorChain = this.createInterceptorChainOnEnter();
        if (iMessageInterceptorChain == null && !this.isPassThrough()) {
            iMessageInterceptorChain = new MessageInterceptorChain();
            iMessageInterceptorChain.add((IMessageInterceptor)new MessageToTextConverter());
        }
        Collection collection = this.messageSender.getChannels();
        for (ISenderChannel iSenderChannel : collection) {
            iSenderChannel.setInterceptorChainOnEnter(iMessageInterceptorChain);
        }
        this.messageSender.open();
        if (logger.isInfoEnabled()) {
            logger.info(String.valueOf(this.getInfo()) + " - Opened :" + this.getMessageSender());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    @Override
    protected void doWrapUp() throws TerminationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        super.doWrapUp();
        this.getMessageSender().close();
        if (logger.isInfoEnabled()) {
            logger.info(String.valueOf(this.getInfo()) + " - Closed :" + this.getMessageSender());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected abstract IMessageInterceptorChain createInterceptorChainOnEnter();

    protected abstract IMessageSender createMessageSender();

    public IMessageSender getMessageSender() {
        return this.messageSender;
    }
}

