/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.csstudio.swt.xygraph.Activator;
import org.eclipse.draw2d.Cursors;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class XYGraphMediaFactory {
    private static XYGraphMediaFactory _instance;
    private ColorRegistry _colorRegistry = new ColorRegistry();
    private ImageRegistry _imageRegistry = new ImageRegistry();
    private FontRegistry _fontRegistry = new FontRegistry();
    private Set<Cursor> cursorRegistry;
    private HashMap<ImageDescriptor, Image> _imageCache = new HashMap();
    private static volatile Cursor CURSOR_GRABBING;
    public static final RGB COLOR_LIGHT_BLUE;
    public static final RGB COLOR_BLUE;
    public static final RGB COLOR_WHITE;
    public static final RGB COLOR_GRAY;
    public static final RGB COLOR_DARK_GRAY;
    public static final RGB COLOR_BLACK;
    public static final RGB COLOR_RED;
    public static final RGB COLOR_GREEN;
    public static final RGB COLOR_YELLOW;
    public static final RGB COLOR_PINK;
    public static final RGB COLOR_CYAN;
    public static final RGB COLOR_ORANGE;
    public static final RGB COLOR_PURPLE;
    public static final FontData FONT_ARIAL;
    public static final FontData FONT_TAHOMA;

    static {
        COLOR_LIGHT_BLUE = new RGB(153, 186, 243);
        COLOR_BLUE = new RGB(0, 0, 255);
        COLOR_WHITE = new RGB(255, 255, 255);
        COLOR_GRAY = new RGB(200, 200, 200);
        COLOR_DARK_GRAY = new RGB(150, 150, 150);
        COLOR_BLACK = new RGB(0, 0, 0);
        COLOR_RED = new RGB(255, 0, 0);
        COLOR_GREEN = new RGB(0, 255, 0);
        COLOR_YELLOW = new RGB(255, 255, 0);
        COLOR_PINK = new RGB(255, 0, 255);
        COLOR_CYAN = new RGB(0, 255, 255);
        COLOR_ORANGE = new RGB(255, 128, 0);
        COLOR_PURPLE = new RGB(128, 0, 255);
        FONT_ARIAL = new FontData("Arial", 9, 0);
        FONT_TAHOMA = new FontData("Tahoma", 9, 0);
    }

    public void disposeResources() {
        if (CURSOR_GRABBING != null && !CURSOR_GRABBING.isDisposed()) {
            CURSOR_GRABBING.dispose();
        }
        if (this.cursorRegistry != null) {
            for (Cursor cursor : this.cursorRegistry) {
                if (cursor == null || cursor.isDisposed()) continue;
                cursor.dispose();
            }
        }
    }

    public static Cursor getCursor(CURSOR_TYPE cURSOR_TYPE) {
        switch (cURSOR_TYPE) {
            case GRABBING: {
                if (CURSOR_GRABBING == null) {
                    CURSOR_GRABBING = new Cursor((Device)Display.getDefault(), XYGraphMediaFactory.getInstance().getImage("images/Grabbing.png").getImageData(), 8, 8);
                }
                return CURSOR_GRABBING;
            }
        }
        return Cursors.HAND;
    }

    private XYGraphMediaFactory() {
        Display.getDefault().addListener(12, new Listener(){

            public void handleEvent(Event event) {
                for (Image image : XYGraphMediaFactory.this._imageCache.values()) {
                    image.dispose();
                }
                XYGraphMediaFactory.this.disposeResources();
            }
        });
    }

    public static synchronized XYGraphMediaFactory getInstance() {
        if (_instance == null) {
            _instance = new XYGraphMediaFactory();
        }
        return _instance;
    }

    public Color getColor(int n, int n2, int n3) {
        return this.getColor(new RGB(n, n2, n3));
    }

    public Color getColor(RGB rGB) {
        assert (rGB != null) : "rgb!=null";
        Color color = null;
        String string = String.valueOf(rGB.hashCode());
        if (!this._colorRegistry.hasValueFor(string)) {
            this._colorRegistry.put(string, rGB);
        }
        color = this._colorRegistry.get(string);
        return color;
    }

    public Font getFont(String string, int n, int n2) {
        assert (string != null) : "name!=null";
        FontData fontData = new FontData(string, n, n2);
        String string2 = String.valueOf(fontData.hashCode());
        if (!this._fontRegistry.hasValueFor(string2)) {
            this._fontRegistry.put(string2, new FontData[]{fontData});
        }
        return this._fontRegistry.get(string2);
    }

    public Font getFont(FontData[] fontDataArray) {
        FontData fontData = fontDataArray[0];
        return this.getFont(fontData.getName(), fontData.getHeight(), fontData.getStyle());
    }

    public Font getFont(FontData[] fontDataArray, int n) {
        FontData fontData = fontDataArray[0];
        Font font = this.getFont(fontData.getName(), fontData.getHeight(), n);
        return font;
    }

    public Font getFont(FontData fontData) {
        Font font = this.getFont(fontData.getName(), fontData.getHeight(), fontData.getStyle());
        return font;
    }

    public Font getDefaultFont(int n) {
        return this.getFont("Arial", 10, n);
    }

    public void registerImage(String string, Image image) {
        this._imageRegistry.put(string, image);
    }

    public Image getRegisteredImage(String string) {
        return this._imageRegistry.get(string);
    }

    public Image getImage(String string) {
        if (this._imageRegistry.get(string) == null) {
            Image image;
            InputStream inputStream = XYGraphMediaFactory.class.getResourceAsStream(string);
            if (inputStream == null) {
                image = Activator.getImageDescriptor(string).createImage();
            } else {
                image = new Image((Device)Display.getCurrent(), inputStream);
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            this._imageRegistry.put(string, image);
        }
        return this._imageRegistry.get(string);
    }

    public void registerCursor(Cursor cursor) {
        if (this.cursorRegistry == null) {
            this.cursorRegistry = new HashSet<Cursor>();
        }
        this.cursorRegistry.add(cursor);
    }

    public static enum CURSOR_TYPE {
        GRABBING;

    }
}

