/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.util;

import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.util.SingleSourceHelper;
import org.csstudio.swt.xygraph.util.XYGraphMediaFactory;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

public class SingleSourceHelperImpl
extends SingleSourceHelper {
    @Override
    protected Cursor createInternalCursor(Display display, ImageData imageData, int n, int n2, int n3) {
        return new Cursor((Device)display, imageData, n, n2);
    }

    @Override
    protected Image createInternalVerticalTextImage(String string, Font font, RGB rGB, boolean bl) {
        Dimension dimension = FigureUtilities.getTextExtents((String)string, (Font)font);
        int n = dimension.height;
        int n2 = dimension.width + 1;
        Image image = new Image((Device)Display.getCurrent(), n, n2);
        GC gC = new GC((Drawable)image);
        Color color = new Color((Device)Display.getCurrent(), rGB);
        RGB rGB2 = new RGB(240, 240, 240);
        gC.setBackground(XYGraphMediaFactory.getInstance().getColor(rGB2));
        gC.fillRectangle(image.getBounds());
        gC.setForeground(color);
        gC.setFont(font);
        Transform transform = new Transform((Device)Display.getCurrent());
        if (!bl) {
            transform.translate(0.0f, (float)n2);
            transform.rotate(-90.0f);
            gC.setTransform(transform);
        } else {
            transform.translate((float)n, 0.0f);
            transform.rotate(90.0f);
            gC.setTransform(transform);
        }
        gC.drawText(string, 0, 0);
        transform.dispose();
        gC.dispose();
        ImageData imageData = image.getImageData();
        image.dispose();
        color.dispose();
        imageData.transparentPixel = imageData.palette.getPixel(rGB2);
        image = new Image((Device)Display.getCurrent(), imageData);
        return image;
    }

    @Override
    protected Image getInternalXYGraphSnapShot(XYGraph xYGraph) {
        Rectangle rectangle = xYGraph.getBounds();
        Image image = new Image(null, rectangle.width + 6, rectangle.height + 6);
        GC gC = new GC((Drawable)image);
        SWTGraphics sWTGraphics = new SWTGraphics(gC);
        sWTGraphics.translate(-rectangle.x + 3, -rectangle.y + 3);
        sWTGraphics.setForegroundColor(xYGraph.getForegroundColor());
        sWTGraphics.setBackgroundColor(xYGraph.getBackgroundColor());
        xYGraph.paint((Graphics)sWTGraphics);
        gC.dispose();
        return image;
    }

    @Override
    protected String getInternalImageSavePath() {
        FileDialog fileDialog = new FileDialog(Display.getDefault().getShells()[0], 8192);
        fileDialog.setFilterNames(new String[]{"PNG Files", "All Files (*.*)"});
        fileDialog.setFilterExtensions(new String[]{"*.png", "*.*"});
        String string = fileDialog.open();
        return string;
    }
}

