/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.util;

import org.csstudio.swt.xygraph.util.XYGraphMediaFactory;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;

public final class GraphicsUtil {
    public static final void drawVerticalText(Graphics graphics, String string, int n, int n2, boolean bl) {
        try {
            graphics.pushState();
            graphics.translate(n, n2);
            if (bl) {
                graphics.rotate(90.0f);
                graphics.drawText(string, 0, -FigureUtilities.getTextExtents((String)string, (Font)graphics.getFont()).height);
            } else {
                graphics.rotate(270.0f);
                graphics.drawText(string, -FigureUtilities.getTextWidth((String)string, (Font)graphics.getFont()), 0);
            }
            graphics.popState();
        }
        catch (Exception exception) {
            graphics.popState();
            Dimension dimension = FigureUtilities.getTextExtents((String)string, (Font)graphics.getFont());
            int n3 = dimension.height;
            int n4 = dimension.width + 1;
            Image image = new Image((Device)Display.getCurrent(), n3, n4);
            try {
                GC gC = new GC((Drawable)image);
                Color color = graphics.getForegroundColor();
                RGB rGB = new RGB(240, 240, 240);
                gC.setBackground(XYGraphMediaFactory.getInstance().getColor(rGB));
                gC.fillRectangle(image.getBounds());
                gC.setForeground(color);
                gC.setFont(graphics.getFont());
                Transform transform = new Transform((Device)Display.getCurrent());
                if (!bl) {
                    transform.translate(0.0f, (float)n4);
                    transform.rotate(-90.0f);
                    gC.setTransform(transform);
                } else {
                    transform.translate((float)n3, 0.0f);
                    transform.rotate(90.0f);
                    gC.setTransform(transform);
                }
                gC.drawText(string, 0, 0);
                transform.dispose();
                gC.dispose();
                ImageData imageData = image.getImageData();
                image.dispose();
                imageData.transparentPixel = imageData.palette.getPixel(rGB);
                image = new Image((Device)Display.getCurrent(), imageData);
                graphics.drawImage(image, n, n2);
            }
            finally {
                image.dispose();
            }
        }
    }

    public static final void drawVerticalText(Graphics graphics, String string, Point point, boolean bl) {
        GraphicsUtil.drawVerticalText(graphics, string, point.x, point.y, bl);
    }
}

