/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.undo;

import org.csstudio.swt.xygraph.figures.Annotation;
import org.csstudio.swt.xygraph.figures.Axis;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.undo.AnnotationMemento;
import org.csstudio.swt.xygraph.undo.AxisMemento;
import org.csstudio.swt.xygraph.undo.IUndoableCommand;
import org.csstudio.swt.xygraph.undo.TraceMemento;
import org.csstudio.swt.xygraph.undo.XYGraphMemento;

public class XYGraphConfigCommand
implements IUndoableCommand {
    private XYGraph xyGraph;
    protected XYGraphMemento previousXYGraphMem;
    protected XYGraphMemento afterXYGraphMem;

    public XYGraphConfigCommand(XYGraph xYGraph) {
        this.xyGraph = xYGraph;
        this.previousXYGraphMem = new XYGraphMemento();
        this.afterXYGraphMem = new XYGraphMemento();
        this.createDefaultSettings();
    }

    protected void createDefaultSettings() {
        int n = 0;
        while (n < this.xyGraph.getPlotArea().getAnnotationList().size()) {
            this.previousXYGraphMem.addAnnotationMemento(new AnnotationMemento());
            this.afterXYGraphMem.addAnnotationMemento(new AnnotationMemento());
            ++n;
        }
        n = 0;
        while (n < this.xyGraph.getAxisList().size()) {
            this.previousXYGraphMem.addAxisMemento(new AxisMemento());
            this.afterXYGraphMem.addAxisMemento(new AxisMemento());
            ++n;
        }
        n = 0;
        while (n < this.xyGraph.getPlotArea().getTraceList().size()) {
            this.previousXYGraphMem.addTraceMemento(new TraceMemento());
            this.afterXYGraphMem.addTraceMemento(new TraceMemento());
            ++n;
        }
    }

    @Override
    public void redo() {
        this.restoreXYGraphPropsFromMemento(this.xyGraph, this.afterXYGraphMem);
    }

    @Override
    public void undo() {
        this.restoreXYGraphPropsFromMemento(this.xyGraph, this.previousXYGraphMem);
    }

    public void savePreviousStates() {
        this.saveXYGraphPropsToMemento(this.xyGraph, this.previousXYGraphMem);
    }

    public void saveAfterStates() {
        this.saveXYGraphPropsToMemento(this.xyGraph, this.afterXYGraphMem);
    }

    public String toString() {
        return "Configure XYGraph Settings";
    }

    protected void saveXYGraphPropsToMemento(XYGraph xYGraph, XYGraphMemento xYGraphMemento) {
        xYGraphMemento.setTitle(xYGraph.getTitle());
        xYGraphMemento.setTitleFont(xYGraph.getTitleFont());
        xYGraphMemento.setTitleColor(xYGraph.getTitleColor());
        xYGraphMemento.setPlotAreaBackColor(xYGraph.getPlotArea().getBackgroundColor());
        xYGraphMemento.setShowTitle(xYGraph.isShowTitle());
        xYGraphMemento.setShowLegend(xYGraph.isShowLegend());
        xYGraphMemento.setShowPlotAreaBorder(xYGraph.getPlotArea().isShowBorder());
        xYGraphMemento.setTransparent(xYGraph.isTransparent());
        int n = 0;
        for (Annotation figure : xYGraph.getPlotArea().getAnnotationList()) {
            this.saveAnnotationPropsToMemento(figure, xYGraphMemento.getAnnotationMementoList().get(n++));
        }
        n = 0;
        for (Axis axis : xYGraph.getAxisList()) {
            this.saveAxisPropsToMemento(axis, xYGraphMemento.getAxisMementoList().get(n++));
        }
        n = 0;
        for (Trace trace : xYGraph.getPlotArea().getTraceList()) {
            this.saveTracePropsToMemento(trace, xYGraphMemento.getTraceMementoList().get(n++));
        }
    }

    protected void restoreXYGraphPropsFromMemento(XYGraph xYGraph, XYGraphMemento xYGraphMemento) {
        xYGraph.setTitle(xYGraphMemento.getTitle());
        xYGraph.setTitleFont(xYGraphMemento.getTitleFont());
        xYGraph.setTitleColor(xYGraphMemento.getTitleColor());
        xYGraph.getPlotArea().setBackgroundColor(xYGraphMemento.getPlotAreaBackColor());
        xYGraph.setShowTitle(xYGraphMemento.isShowTitle());
        xYGraph.setShowLegend(xYGraphMemento.isShowLegend());
        xYGraph.getPlotArea().setShowBorder(xYGraphMemento.isShowPlotAreaBorder());
        xYGraph.setTransparent(xYGraphMemento.isTransparent());
        int n = 0;
        for (AnnotationMemento object : xYGraphMemento.getAnnotationMementoList()) {
            this.restoreAnnotationPropsFromMemento(xYGraph.getPlotArea().getAnnotationList().get(n++), object);
        }
        n = 0;
        for (AxisMemento axisMemento : xYGraphMemento.getAxisMementoList()) {
            this.restoreAxisPropsFromMemento(xYGraph.getAxisList().get(n++), axisMemento);
        }
        n = 0;
        for (TraceMemento traceMemento : xYGraphMemento.getTraceMementoList()) {
            this.restoreTracePropsFromMemento(xYGraph.getPlotArea().getTraceList().get(n++), traceMemento);
        }
    }

    private void saveAnnotationPropsToMemento(Annotation annotation, AnnotationMemento annotationMemento) {
        annotationMemento.setName(annotation.getName());
        if (annotation.isFree()) {
            annotationMemento.setFree(true);
            annotationMemento.setXAxis(annotation.getXAxis());
            annotationMemento.setYAxis(annotation.getYAxis());
        } else {
            annotationMemento.setFree(false);
            annotationMemento.setTrace(annotation.getTrace());
        }
        annotationMemento.setAnnotationColor(annotation.getAnnotationColor());
        annotationMemento.setFont(annotation.getFont());
        annotationMemento.setCursorLineStyle(annotation.getCursorLineStyle());
        annotationMemento.setShowName(annotation.isShowName());
        annotationMemento.setShowSampleInfo(annotation.isShowSampleInfo());
        annotationMemento.setShowPosition(annotation.isShowPosition());
    }

    private void restoreAnnotationPropsFromMemento(Annotation annotation, AnnotationMemento annotationMemento) {
        annotation.setName(annotationMemento.getName());
        if (annotationMemento.isFree()) {
            annotation.setFree(annotationMemento.getXAxis(), annotationMemento.getYAxis());
        } else {
            annotation.setTrace(annotationMemento.getTrace());
        }
        annotation.setAnnotationColor(annotationMemento.getAnnotationColor());
        annotation.setFont(annotationMemento.getFont());
        annotation.setCursorLineStyle(annotationMemento.getCursorLineStyle());
        annotation.setShowName(annotationMemento.isShowName());
        annotation.setShowSampleInfo(annotationMemento.isShowSampleInfo());
        annotation.setShowPosition(annotationMemento.isShowPosition());
    }

    private void saveAxisPropsToMemento(Axis axis, AxisMemento axisMemento) {
        axisMemento.setTitle(axis.getTitle());
        axisMemento.setTitleFont(axis.getTitleFont());
        axisMemento.setForegroundColor(axis.getForegroundColor());
        axisMemento.setPrimarySide(axis.isOnPrimarySide());
        axisMemento.setLogScale(axis.isLogScaleEnabled());
        axisMemento.setAutoScale(axis.isAutoScale());
        axisMemento.setAutoScaleThreshold(axis.getAutoScaleThreshold());
        axisMemento.setRange(axis.getRange());
        axisMemento.setDateEnabled(axis.isDateEnabled());
        axisMemento.setAutoFormat(axis.isAutoFormat());
        axisMemento.setFormatPattern(axis.getFormatPattern());
        axisMemento.setShowMajorGrid(axis.isShowMajorGrid());
        axisMemento.setDashGridLine(axis.isDashGridLine());
        axisMemento.setMajorGridColor(axis.getMajorGridColor());
    }

    private void restoreAxisPropsFromMemento(Axis axis, AxisMemento axisMemento) {
        axis.setTitle(axisMemento.getTitle());
        axis.setTitleFont(axisMemento.getTitleFont());
        axis.setForegroundColor(axisMemento.getForegroundColor());
        axis.setPrimarySide(axisMemento.isOnPrimarySide());
        axis.setLogScale(axisMemento.isLogScaleEnabled());
        axis.setAutoScale(axisMemento.isAutoScale());
        axis.setAutoScaleThreshold(axisMemento.getAutoScaleThreshold());
        axis.setRange(axisMemento.getRange());
        axis.setDateEnabled(axisMemento.isDateEnabled());
        axis.setAutoFormat(axisMemento.isAutoFormat());
        axis.setFormatPattern(axisMemento.getFormatPattern());
        axis.setShowMajorGrid(axisMemento.isShowMajorGrid());
        axis.setDashGridLine(axisMemento.isDashGridLine());
        axis.setMajorGridColor(axisMemento.getMajorGridColor());
    }

    private void saveTracePropsToMemento(Trace trace, TraceMemento traceMemento) {
        traceMemento.setName(trace.getName());
        traceMemento.setXAxis(trace.getXAxis());
        traceMemento.setYAxis(trace.getYAxis());
        traceMemento.setTraceColor(trace.getTraceColor());
        traceMemento.setTraceType(trace.getTraceType());
        traceMemento.setLineWidth(trace.getLineWidth());
        traceMemento.setPointStyle(trace.getPointStyle());
        traceMemento.setPointSize(trace.getPointSize());
        traceMemento.setBaseLine(trace.getBaseLine());
        traceMemento.setAreaAlpha(trace.getAreaAlpha());
        traceMemento.setAntiAliasing(trace.isAntiAliasing());
        traceMemento.setErrorBarEnabled(trace.isErrorBarEnabled());
        traceMemento.setXErrorBarType(trace.getXErrorBarType());
        traceMemento.setYErrorBarType(trace.getYErrorBarType());
        traceMemento.setErrorBarColor(trace.getErrorBarColor());
        traceMemento.setErrorBarCapWidth(trace.getErrorBarCapWidth());
        traceMemento.setDrawYErrorInArea(trace.isDrawYErrorInArea());
    }

    private void restoreTracePropsFromMemento(Trace trace, TraceMemento traceMemento) {
        trace.setName(traceMemento.getName());
        trace.setXAxis(traceMemento.getXAxis());
        trace.setYAxis(traceMemento.getYAxis());
        trace.setTraceColor(traceMemento.getTraceColor());
        trace.setTraceType(traceMemento.getTraceType());
        trace.setLineWidth(traceMemento.getLineWidth());
        trace.setPointStyle(traceMemento.getPointStyle());
        trace.setPointSize(traceMemento.getPointSize());
        trace.setBaseLine(traceMemento.getBaseLine());
        trace.setAreaAlpha(traceMemento.getAreaAlpha());
        trace.setAntiAliasing(traceMemento.isAntiAliasing());
        trace.setErrorBarEnabled(traceMemento.isErrorBarEnabled());
        trace.setXErrorBarType(traceMemento.getXErrorBarType());
        trace.setYErrorBarType(traceMemento.getYErrorBarType());
        trace.setErrorBarColor(traceMemento.getErrorBarColor());
        trace.setErrorBarCapWidth(traceMemento.getErrorBarCapWidth());
        trace.setDrawYErrorInArea(traceMemento.isDrawYErrorInArea());
    }
}

