/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.undo;

import java.util.ArrayList;
import java.util.List;
import org.csstudio.swt.xygraph.undo.IOperationsManagerListener;
import org.csstudio.swt.xygraph.undo.IUndoableCommand;
import org.csstudio.swt.xygraph.undo.SizeLimitedStack;

public class OperationsManager {
    private SizeLimitedStack<IUndoableCommand> undoStack = new SizeLimitedStack(30);
    private SizeLimitedStack<IUndoableCommand> redoStack = new SizeLimitedStack(30);
    private List<IOperationsManagerListener> listeners = new ArrayList<IOperationsManagerListener>();

    public void addCommand(IUndoableCommand iUndoableCommand) {
        this.undoStack.push(iUndoableCommand);
        this.redoStack.clear();
        this.fireOperationsHistoryChanged();
    }

    public void undoCommand(IUndoableCommand iUndoableCommand) {
        IUndoableCommand iUndoableCommand2;
        do {
            iUndoableCommand2 = this.undoStack.pop();
            iUndoableCommand2.undo();
            this.redoStack.push(iUndoableCommand2);
        } while (iUndoableCommand2 != iUndoableCommand);
        this.fireOperationsHistoryChanged();
    }

    public void redoCommand(IUndoableCommand iUndoableCommand) {
        IUndoableCommand iUndoableCommand2;
        do {
            iUndoableCommand2 = this.redoStack.pop();
            iUndoableCommand2.redo();
            this.undoStack.push(iUndoableCommand2);
        } while (iUndoableCommand2 != iUndoableCommand);
        this.fireOperationsHistoryChanged();
    }

    public void undo() {
        if (this.undoStack.size() > 0) {
            this.undoCommand(this.undoStack.peek());
        }
    }

    public void redo() {
        if (this.redoStack.size() > 0) {
            this.redoCommand(this.redoStack.peek());
        }
    }

    public Object[] getUndoCommands() {
        return this.undoStack.toArray();
    }

    public Object[] getRedoCommands() {
        return this.redoStack.toArray();
    }

    public void addListener(IOperationsManagerListener iOperationsManagerListener) {
        this.listeners.add(iOperationsManagerListener);
    }

    public boolean removeListener(IOperationsManagerListener iOperationsManagerListener) {
        return this.listeners.remove(iOperationsManagerListener);
    }

    private void fireOperationsHistoryChanged() {
        for (IOperationsManagerListener iOperationsManagerListener : this.listeners) {
            iOperationsManagerListener.operationsHistoryChanged(this);
        }
    }

    public int getUndoCommandsSize() {
        return this.undoStack.size();
    }

    public int getRedoCommandsSize() {
        return this.redoStack.size();
    }
}

