/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.undo;

import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.figures.Annotation;
import org.csstudio.swt.xygraph.undo.IUndoableCommand;
import org.eclipse.draw2d.geometry.Point;

public class MovingAnnotationCommand
implements IUndoableCommand {
    private Annotation annotation;
    private Point beforeMovePosition;
    private Point afterMovePosition;
    private ISample beforeMoveSnappedSample;
    private ISample afterMoveSnappedSample;
    private double beforeDx;
    private double beforeDy;
    private double afterDx;
    private double afterDy;

    public MovingAnnotationCommand(Annotation annotation) {
        this.annotation = annotation;
    }

    @Override
    public void redo() {
        if (this.annotation.isFree()) {
            this.annotation.setCurrentPosition(this.afterMovePosition, false);
        } else {
            this.annotation.setCurrentSnappedSample(this.afterMoveSnappedSample, false);
        }
        this.annotation.setdxdy(this.afterDx, this.afterDy);
    }

    @Override
    public void undo() {
        if (this.annotation.isFree()) {
            this.annotation.setCurrentPosition(this.beforeMovePosition, false);
        } else {
            this.annotation.setCurrentSnappedSample(this.beforeMoveSnappedSample, false);
        }
        this.annotation.setdxdy(this.beforeDx, this.beforeDy);
    }

    public void setBeforeDxDy(double d, double d2) {
        this.beforeDx = d;
        this.beforeDy = d2;
    }

    public void setAfterDxDy(double d, double d2) {
        this.afterDx = d;
        this.afterDy = d2;
    }

    public void setBeforeMovePosition(Point point) {
        this.beforeMovePosition = point;
    }

    public void setAfterMovePosition(Point point) {
        this.afterMovePosition = point;
    }

    public void setBeforeMoveSnappedSample(ISample iSample) {
        this.beforeMoveSnappedSample = iSample;
    }

    public void setAfterMoveSnappedSample(ISample iSample) {
        this.afterMoveSnappedSample = iSample;
    }

    public String toString() {
        return "Move Annotation";
    }
}

