/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.toolbar;

import java.util.List;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.toolbar.AddAnnotationDialog;
import org.csstudio.swt.xygraph.toolbar.CheckableActionGroup;
import org.csstudio.swt.xygraph.toolbar.GrayableButton;
import org.csstudio.swt.xygraph.toolbar.RemoveAnnotationDialog;
import org.csstudio.swt.xygraph.toolbar.WrappableToolbarLayout;
import org.csstudio.swt.xygraph.toolbar.XYGraphConfigDialog;
import org.csstudio.swt.xygraph.undo.AddAnnotationCommand;
import org.csstudio.swt.xygraph.undo.IOperationsManagerListener;
import org.csstudio.swt.xygraph.undo.OperationsManager;
import org.csstudio.swt.xygraph.undo.RemoveAnnotationCommand;
import org.csstudio.swt.xygraph.undo.ZoomType;
import org.csstudio.swt.xygraph.util.XYGraphMediaFactory;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.ButtonGroup;
import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToggleButton;
import org.eclipse.draw2d.ToggleModel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;

public class XYGraphToolbar
extends Figure {
    private static final int BUTTON_SIZE = 25;
    protected final XYGraph xyGraph;
    protected final ButtonGroup zoomGroup;

    public XYGraphToolbar(XYGraph xYGraph) {
        this(xYGraph, 1);
    }

    public XYGraphToolbar(final XYGraph xYGraph, int n) {
        this.xyGraph = xYGraph;
        this.setLayoutManager((LayoutManager)new WrappableToolbarLayout());
        Button button = new Button(XYGraphToolbar.createImage("icons/Configure.png"));
        button.setToolTip((IFigure)new Label("Configure Settings..."));
        this.addButton((Clickable)button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XYGraphToolbar.this.openConfigurationDialog();
            }
        });
        ToggleButton toggleButton = new ToggleButton("", XYGraphToolbar.createImage("icons/ShowLegend.png"));
        toggleButton.setToolTip((IFigure)new Label("Show Legend"));
        this.addButton((Clickable)toggleButton);
        toggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                xYGraph.setShowLegend(!xYGraph.isShowLegend());
            }
        });
        toggleButton.setSelected(xYGraph.isShowLegend());
        this.addSeparator("org.csstudio.swt.xygraph.toolbar.showLegend");
        Button button2 = new Button(XYGraphToolbar.createImage("icons/Add_Annotation.png"));
        button2.setToolTip((IFigure)new Label("Add Annotation..."));
        this.addButton((Clickable)button2);
        button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddAnnotationDialog addAnnotationDialog = new AddAnnotationDialog(Display.getCurrent().getActiveShell(), xYGraph);
                if (addAnnotationDialog.open() == 0) {
                    xYGraph.addAnnotation(addAnnotationDialog.getAnnotation());
                    xYGraph.getOperationsManager().addCommand(new AddAnnotationCommand(xYGraph, addAnnotationDialog.getAnnotation()));
                }
            }
        });
        Button button3 = new Button(XYGraphToolbar.createImage("icons/Del_Annotation.png"));
        button3.setToolTip((IFigure)new Label("Remove Annotation..."));
        this.addButton((Clickable)button3);
        button3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoveAnnotationDialog removeAnnotationDialog = new RemoveAnnotationDialog(Display.getCurrent().getActiveShell(), xYGraph);
                if (removeAnnotationDialog.open() == 0 && removeAnnotationDialog.getAnnotation() != null) {
                    xYGraph.removeAnnotation(removeAnnotationDialog.getAnnotation());
                    xYGraph.getOperationsManager().addCommand(new RemoveAnnotationCommand(xYGraph, removeAnnotationDialog.getAnnotation()));
                }
            }
        });
        this.addSeparator("org.csstudio.swt.xygraph.toolbar.annotation");
        this.addSeparator("org.csstudio.swt.xygraph.toolbar.extra");
        if ((n & 4) > 0) {
            Button button4 = new Button(XYGraphToolbar.createImage("icons/stagger.png"));
            button4.setToolTip((IFigure)new Label("Stagger axes so they don't overlap"));
            this.addButton((Clickable)button4);
            button4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    xYGraph.performStagger();
                }
            });
        } else {
            Button button5 = new Button(XYGraphToolbar.createImage("icons/AutoScale.png"));
            button5.setToolTip((IFigure)new Label("Perform Auto Scale"));
            this.addButton((Clickable)button5);
            button5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    xYGraph.performAutoScale();
                }
            });
        }
        this.zoomGroup = new ButtonGroup();
        this.createZoomButtons(n);
        this.addSeparator("org.csstudio.swt.xygraph.toolbar.undoredo");
        this.addUndoRedoButtons();
        this.addSeparator("org.csstudio.swt.xygraph.toolbar.snapshot");
        this.addSnapshotButton();
    }

    protected static Image createImage(String string) {
        Image image = XYGraphMediaFactory.getInstance().getImage(string);
        return image;
    }

    protected void addSnapshotButton() {
        Button button = new Button(XYGraphToolbar.createImage("icons/camera.gif"));
        button.setToolTip((IFigure)new Label("Print scaled image to printer"));
        this.addButton((Clickable)button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintDialog printDialog = new PrintDialog(Display.getCurrent().getActiveShell(), 0);
                PrinterData printerData = printDialog.open();
                printerData.orientation = 2;
                if (printerData != null) {
                    Printer printer = new Printer(printerData);
                    Point point = Display.getCurrent().getDPI();
                    Point point2 = printer.getDPI();
                    int n = point2.x / point.x;
                    Rectangle rectangle = printer.getClientArea();
                    Rectangle rectangle2 = printer.computeTrim(0, 0, 0, 0);
                    Rectangle rectangle3 = new Rectangle(rectangle.x / n, rectangle.y / n, rectangle.width / n, rectangle.height / n);
                    if (printer.startJob("Print Plot") && printer.startPage()) {
                        GC gC = new GC((Drawable)printer);
                        Image image = XYGraphToolbar.this.xyGraph.getImage(rectangle3);
                        Image image2 = new Image((Device)printer, image.getImageData());
                        image.dispose();
                        gC.drawImage(image2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, -rectangle2.x, -rectangle2.y, rectangle.width - rectangle2.width, rectangle.height - rectangle2.height);
                        image2.dispose();
                        gC.dispose();
                        printer.endPage();
                    }
                    printer.endJob();
                    printer.dispose();
                }
            }
        });
    }

    private void addUndoRedoButtons() {
        final GrayableButton grayableButton = new GrayableButton(XYGraphToolbar.createImage("icons/Undo.png"));
        grayableButton.setToolTip((IFigure)new Label("Undo"));
        grayableButton.setEnabled(false);
        this.addButton((Clickable)grayableButton);
        grayableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XYGraphToolbar.this.xyGraph.getOperationsManager().undo();
            }
        });
        this.xyGraph.getOperationsManager().addListener(new IOperationsManagerListener(){

            @Override
            public void operationsHistoryChanged(OperationsManager operationsManager) {
                if (operationsManager.getUndoCommandsSize() > 0) {
                    grayableButton.setEnabled(true);
                    String string = operationsManager.getUndoCommands()[operationsManager.getUndoCommandsSize() - 1].toString();
                    grayableButton.setToolTip((IFigure)new Label(NLS.bind((String)"Undo {0}", (Object)string)));
                } else {
                    grayableButton.setEnabled(false);
                    grayableButton.setToolTip((IFigure)new Label("Undo"));
                }
            }
        });
        final GrayableButton grayableButton2 = new GrayableButton(XYGraphToolbar.createImage("icons/Redo.png"));
        grayableButton2.setToolTip((IFigure)new Label("Redo"));
        grayableButton2.setEnabled(false);
        this.addButton((Clickable)grayableButton2);
        grayableButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XYGraphToolbar.this.xyGraph.getOperationsManager().redo();
            }
        });
        this.xyGraph.getOperationsManager().addListener(new IOperationsManagerListener(){

            @Override
            public void operationsHistoryChanged(OperationsManager operationsManager) {
                if (operationsManager.getRedoCommandsSize() > 0) {
                    grayableButton2.setEnabled(true);
                    String string = operationsManager.getRedoCommands()[operationsManager.getRedoCommandsSize() - 1].toString();
                    grayableButton2.setToolTip((IFigure)new Label(NLS.bind((String)"Redo {0}", (Object)string)));
                } else {
                    grayableButton2.setEnabled(false);
                    grayableButton2.setToolTip((IFigure)new Label("Redo"));
                }
            }
        });
    }

    protected void createZoomButtons(int n) {
        ZoomType[] zoomTypeArray = ZoomType.values();
        int n2 = zoomTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            final ZoomType zoomType = zoomTypeArray[n3];
            if (zoomType.useWithFlags(n)) {
                ImageFigure imageFigure = new ImageFigure(zoomType.getIconImage());
                Label label = new Label(zoomType.getDescription());
                final ToggleButton toggleButton = new ToggleButton((IFigure)imageFigure);
                toggleButton.setBackgroundColor(ColorConstants.button);
                toggleButton.setOpaque(true);
                ToggleModel toggleModel = new ToggleModel();
                toggleModel.addChangeListener(new ChangeListener(){

                    public void handleStateChanged(ChangeEvent changeEvent) {
                        if (changeEvent.getPropertyName().equals("selected") && toggleButton.isSelected()) {
                            XYGraphToolbar.this.xyGraph.setZoomType(zoomType);
                        }
                    }
                });
                toggleButton.setModel((ButtonModel)toggleModel);
                toggleButton.setToolTip((IFigure)label);
                this.addButton((Clickable)toggleButton);
                this.zoomGroup.add((ButtonModel)toggleModel);
                if (zoomType == ZoomType.NONE) {
                    this.zoomGroup.setDefault((ButtonModel)toggleModel);
                }
            }
            ++n3;
        }
    }

    protected void openConfigurationDialog() {
        XYGraphConfigDialog xYGraphConfigDialog = new XYGraphConfigDialog(Display.getCurrent().getActiveShell(), this.xyGraph);
        xYGraphConfigDialog.open();
    }

    public void addButton(Clickable clickable) {
        clickable.setPreferredSize(25, 25);
        this.add((IFigure)clickable);
    }

    public void addSeparator(String string) {
        ToolbarSeparator toolbarSeparator = new ToolbarSeparator(string);
        toolbarSeparator.setPreferredSize(12, 25);
        this.add((IFigure)toolbarSeparator);
    }

    public void createGraphActions(IContributionManager iContributionManager, IContributionManager iContributionManager2) {
        CheckableActionGroup checkableActionGroup = new CheckableActionGroup();
        for (Object e : this.getChildren()) {
            if (!(e instanceof Figure)) continue;
            Figure figure = (Figure)e;
            if (figure instanceof Clickable) {
                final Clickable clickable = (Clickable)figure;
                int n = clickable instanceof ToggleButton ? 2 : 1;
                String string = ((Label)clickable.getToolTip()).getText();
                Object e2 = clickable.getChildren().get(0);
                final Image image = e2 instanceof ImageFigure ? ((ImageFigure)e2).getImage() : ((Label)e2).getIcon();
                final Action action = new Action(string, n){

                    public void run() {
                        if (clickable.getModel() instanceof ToggleModel) {
                            ((ToggleModel)clickable.getModel()).fireActionPerformed();
                        } else {
                            clickable.doClick();
                        }
                    }
                };
                if (n == 2) {
                    boolean bl = clickable.isSelected();
                    action.setChecked(bl);
                }
                if (clickable instanceof GrayableButton) {
                    final GrayableButton grayableButton = (GrayableButton)clickable;
                    grayableButton.addChangeListener(new ChangeListener(){

                        public void handleStateChanged(ChangeEvent changeEvent) {
                            if (changeEvent.getPropertyName().equals("enabled")) {
                                action.setEnabled(grayableButton.isEnabled());
                            }
                        }
                    });
                }
                action.setImageDescriptor(new ImageDescriptor(){

                    public ImageData getImageData() {
                        return image.getImageData();
                    }
                });
                iContributionManager.add((IAction)action);
                iContributionManager2.add((IAction)action);
                List list = this.zoomGroup.getElements();
                if (!list.contains(clickable.getModel())) continue;
                checkableActionGroup.add((IAction)action);
                continue;
            }
            if (!(figure instanceof ToolbarSeparator)) continue;
            iContributionManager.add((IContributionItem)new Separator(((ToolbarSeparator)figure).getId()));
            iContributionManager2.add((IContributionItem)new Separator(((ToolbarSeparator)figure).getId()));
        }
    }

    protected static final class ToolbarSeparator
    extends Figure {
        protected String id;
        private final Color GRAY_COLOR = XYGraphMediaFactory.getInstance().getColor(new RGB(130, 130, 130));

        ToolbarSeparator(String string) {
            this.id = string;
        }

        protected void paintClientArea(Graphics graphics) {
            super.paintClientArea(graphics);
            graphics.setForegroundColor(this.GRAY_COLOR);
            graphics.setLineWidth(1);
            graphics.drawLine(this.bounds.x + this.bounds.width / 2, this.bounds.y, this.bounds.x + this.bounds.width / 2, this.bounds.y + this.bounds.height);
        }

        public String getId() {
            return this.id;
        }
    }
}

