/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.toolbar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.csstudio.swt.xygraph.figures.Annotation;
import org.csstudio.swt.xygraph.figures.Axis;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.toolbar.AnnotationConfigPage;
import org.csstudio.swt.xygraph.toolbar.AxisConfigPage;
import org.csstudio.swt.xygraph.toolbar.GraphConfigPage;
import org.csstudio.swt.xygraph.toolbar.TraceConfigPage;
import org.csstudio.swt.xygraph.undo.XYGraphConfigCommand;
import org.eclipse.draw2d.Figure;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class XYGraphConfigDialog
extends Dialog {
    private GraphConfigPage graphConfigPage;
    private List<AnnotationConfigPage> annotationConfigPageList;
    private List<AxisConfigPage> axisConfigPageList;
    private List<TraceConfigPage> traceConfigPageList;
    protected XYGraph xyGraph;
    protected XYGraphConfigCommand command;
    private boolean changed = false;

    protected XYGraphConfigDialog(Shell shell, XYGraph xYGraph) {
        super(shell);
        this.xyGraph = xYGraph;
        this.graphConfigPage = new GraphConfigPage(xYGraph);
        this.annotationConfigPageList = new ArrayList<AnnotationConfigPage>();
        this.axisConfigPageList = new ArrayList<AxisConfigPage>();
        this.traceConfigPageList = new ArrayList<TraceConfigPage>();
        this.command = new XYGraphConfigCommand(xYGraph);
        this.command.savePreviousStates();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Configure Graph Settings");
    }

    protected Control createDialogArea(Composite composite) {
        Object object;
        Group group;
        Iterator<Figure> iterator;
        TabItem tabItem;
        AxisConfigPage axisConfigPage;
        Group group2;
        Axis axis32;
        Axis axis222;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new FillLayout());
        TabFolder tabFolder = new TabFolder(composite2, 0);
        Composite composite3 = new Composite((Composite)tabFolder, 0);
        this.graphConfigPage.createPage(composite3);
        TabItem tabItem2 = new TabItem(tabFolder, 0);
        tabItem2.setText("Graph");
        tabItem2.setToolTipText("Configure General Graph Settings");
        tabItem2.setControl((Control)composite3);
        Composite composite4 = new Composite((Composite)tabFolder, 0);
        composite4.setLayout((Layout)new GridLayout(1, false));
        TabItem tabItem3 = new TabItem(tabFolder, 0);
        tabItem3.setText("Axes");
        tabItem3.setToolTipText("Configure Axes Settings");
        tabItem3.setControl((Control)composite4);
        Group group3 = new Group(composite4, 0);
        group3.setLayoutData((Object)new GridData(4, 4, true, false));
        group3.setText("Select Axis");
        group3.setLayout((Layout)new GridLayout(1, false));
        final Combo combo = new Combo((Composite)group3, 4);
        combo.setLayoutData((Object)new GridData(4, 0, true, false));
        for (Axis axis222 : this.xyGraph.getAxisList()) {
            combo.add(String.valueOf(axis222.getTitle()) + (axis222.isHorizontal() ? "(X-Axis)" : "(Y-Axis)"));
        }
        combo.select(0);
        axis222 = new Composite(composite4, 0);
        axis222.setLayoutData(new GridData(4, 4, true, false));
        final StackLayout stackLayout = new StackLayout();
        axis222.setLayout((Layout)stackLayout);
        for (Axis axis32 : this.xyGraph.getAxisList()) {
            group2 = new Group((Composite)axis222, 0);
            group2.setText("Change Settings");
            group2.setLayoutData((Object)new GridData(4, 4, true, true));
            axisConfigPage = new AxisConfigPage(this.xyGraph, axis32);
            this.axisConfigPageList.add(axisConfigPage);
            axisConfigPage.createPage((Composite)group2);
        }
        stackLayout.topControl = this.axisConfigPageList.get(0).getComposite();
        combo.addSelectionListener((SelectionListener)new SelectionAdapter((Composite)axis222){
            private final /* synthetic */ Composite val$axisConfigComposite;
            {
                this.val$axisConfigComposite = composite;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                stackLayout.topControl = ((AxisConfigPage)XYGraphConfigDialog.this.axisConfigPageList.get(combo.getSelectionIndex())).getComposite();
                this.val$axisConfigComposite.layout(true, true);
            }
        });
        if (this.xyGraph.getPlotArea().getTraceList().size() > 0) {
            axis32 = new Composite((Composite)tabFolder, 0);
            axis32.setLayout((Layout)new GridLayout(1, false));
            tabItem = new TabItem(tabFolder, 0);
            tabItem.setText("Traces");
            tabItem.setToolTipText("Configure Traces Settings");
            tabItem.setControl((Control)axis32);
            group2 = new Group((Composite)axis32, 0);
            group2.setLayoutData((Object)new GridData(4, 4, true, false));
            group2.setText("Select Trace");
            group2.setLayout((Layout)new GridLayout(1, false));
            axisConfigPage = new Combo((Composite)group2, 4);
            axisConfigPage.setLayoutData(new GridData(4, 0, true, false));
            for (Trace figure2 : this.xyGraph.getPlotArea().getTraceList()) {
                axisConfigPage.add(figure2.getName());
            }
            axisConfigPage.select(0);
            Composite composite5 = new Composite((Composite)axis32, 0);
            composite5.setLayoutData((Object)new GridData(4, 4, true, false));
            iterator = new StackLayout();
            composite5.setLayout(iterator);
            for (Trace trace : this.xyGraph.getPlotArea().getTraceList()) {
                group = new Group(composite5, 0);
                group.setText("Change Settings");
                group.setLayoutData((Object)new GridData(4, 4, true, true));
                object = new TraceConfigPage(this.xyGraph, trace);
                this.traceConfigPageList.add((TraceConfigPage)object);
                ((TraceConfigPage)object).createPage((Composite)group);
            }
            ((StackLayout)iterator).topControl = this.traceConfigPageList.get(0).getComposite();
            axisConfigPage.addSelectionListener((SelectionListener)new SelectionAdapter((StackLayout)iterator, (Combo)axisConfigPage, composite5){
                private final /* synthetic */ StackLayout val$traceStackLayout;
                private final /* synthetic */ Combo val$traceCombo;
                private final /* synthetic */ Composite val$traceConfigComposite;
                {
                    this.val$traceStackLayout = stackLayout;
                    this.val$traceCombo = combo;
                    this.val$traceConfigComposite = composite;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.val$traceStackLayout.topControl = ((TraceConfigPage)XYGraphConfigDialog.this.traceConfigPageList.get(this.val$traceCombo.getSelectionIndex())).getComposite();
                    this.val$traceConfigComposite.layout(true, true);
                }
            });
        }
        if (this.xyGraph.getPlotArea().getAnnotationList().size() > 0) {
            axis32 = new Composite((Composite)tabFolder, 0);
            axis32.setLayout((Layout)new GridLayout(1, false));
            tabItem = new TabItem(tabFolder, 0);
            tabItem.setText("Annotations");
            tabItem.setToolTipText("Configure Annotation Settings");
            tabItem.setControl((Control)axis32);
            group2 = new Group((Composite)axis32, 0);
            group2.setLayoutData((Object)new GridData(4, 4, true, false));
            group2.setText("Select Annotation");
            group2.setLayout((Layout)new GridLayout(1, false));
            axisConfigPage = new Combo((Composite)group2, 4);
            axisConfigPage.setLayoutData(new GridData(4, 0, true, false));
            for (Annotation annotation : this.xyGraph.getPlotArea().getAnnotationList()) {
                axisConfigPage.add(annotation.getName());
            }
            axisConfigPage.select(0);
            Composite composite6 = new Composite((Composite)axis32, 0);
            composite6.setLayoutData((Object)new GridData(4, 4, true, false));
            iterator = new StackLayout();
            composite6.setLayout(iterator);
            for (Annotation annotation : this.xyGraph.getPlotArea().getAnnotationList()) {
                group = new Group(composite6, 0);
                group.setText("Change Settings");
                group.setLayoutData((Object)new GridData(4, 4, true, true));
                object = new AnnotationConfigPage(this.xyGraph, annotation);
                this.annotationConfigPageList.add((AnnotationConfigPage)object);
                ((AnnotationConfigPage)object).createPage((Composite)group);
            }
            ((StackLayout)iterator).topControl = this.annotationConfigPageList.get(0).getComposite();
            axisConfigPage.addSelectionListener((SelectionListener)new SelectionAdapter((StackLayout)iterator, (Combo)axisConfigPage, composite6){
                private final /* synthetic */ StackLayout val$stackLayout;
                private final /* synthetic */ Combo val$annotationsCombo;
                private final /* synthetic */ Composite val$annoConfigComposite;
                {
                    this.val$stackLayout = stackLayout;
                    this.val$annotationsCombo = combo;
                    this.val$annoConfigComposite = composite;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.val$stackLayout.topControl = ((AnnotationConfigPage)XYGraphConfigDialog.this.annotationConfigPageList.get(this.val$annotationsCombo.getSelectionIndex())).getComposite();
                    this.val$annoConfigComposite.layout(true, true);
                }
            });
        }
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        ++((GridLayout)composite.getLayout()).numColumns;
        Button button = new Button(composite, 8);
        button.setText("Apply");
        GridData gridData = new GridData(256);
        int n = this.convertHorizontalDLUsToPixels(61);
        Point point = button.computeSize(-1, -1, true);
        gridData.widthHint = Math.max(n, point.x);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                XYGraphConfigDialog.this.applyChanges();
            }
        });
        super.createButtonsForButtonBar(composite);
        Shell shell = composite.getShell();
        if (shell != null) {
            shell.setDefaultButton(button);
        }
    }

    protected void okPressed() {
        this.applyChanges();
        this.command.saveAfterStates();
        this.xyGraph.getOperationsManager().addCommand(this.command);
        super.okPressed();
    }

    protected void applyChanges() {
        this.changed = true;
        this.graphConfigPage.applyChanges();
        for (AxisConfigPage object : this.axisConfigPageList) {
            object.applyChanges();
        }
        for (TraceConfigPage traceConfigPage : this.traceConfigPageList) {
            traceConfigPage.applyChanges();
        }
        for (AnnotationConfigPage annotationConfigPage : this.annotationConfigPageList) {
            annotationConfigPage.applyChanges();
        }
    }

    protected void cancelPressed() {
        if (this.changed) {
            this.command.saveAfterStates();
            this.xyGraph.getOperationsManager().addCommand(this.command);
        }
        super.cancelPressed();
    }
}

