/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.toolbar;

import java.util.Arrays;
import org.csstudio.swt.xygraph.figures.Axis;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.util.XYGraphMediaFactory;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class TraceConfigPage {
    private XYGraph xyGraph;
    private Trace trace;
    private Text nameText;
    private Combo xAxisCombo;
    private Combo yAxisCombo;
    private ColorSelector traceColorSelector;
    private Combo traceTypeCombo;
    private Spinner lineWidthSpinner;
    private Combo pointStyleCombo;
    private Spinner pointSizeSpinner;
    private Combo baseLineCombo;
    private Spinner areaAlphaSpinner;
    private Button antiAliasing;
    private Button errorBarEnabledButton;
    private Combo xErrorBarTypeCombo;
    private Combo yErrorBarTypeCombo;
    private ColorSelector errorBarColorSelector;
    private Spinner errorBarCapWidthSpinner;
    private Button drawYErrorInAreaButton;
    private Composite composite;

    public TraceConfigPage(XYGraph xYGraph, Trace trace) {
        this.xyGraph = xYGraph;
        this.trace = trace;
    }

    public void createPage(Composite composite) {
        Axis axis2;
        this.composite = composite;
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite2.setLayout((Layout)new GridLayout(3, false));
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("Error Bar");
        GridData gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        Label label = new Label(composite2, 0);
        label.setText("Name: ");
        label.setLayoutData((Object)gridData);
        this.nameText = new Text(composite2, 2052);
        GridData gridData2 = new GridData(4, 0x1000000, true, false, 2, 1);
        this.nameText.setLayoutData((Object)gridData2);
        Label label2 = new Label(composite2, 0);
        label2.setText("X-Axis: ");
        gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        label2.setLayoutData((Object)gridData);
        this.xAxisCombo = new Combo(composite2, 4);
        for (Axis axis2 : this.xyGraph.getXAxisList()) {
            this.xAxisCombo.add(axis2.getTitle());
        }
        gridData2 = new GridData(4, 0x1000000, true, false, 2, 1);
        this.xAxisCombo.setLayoutData((Object)gridData2);
        axis2 = new Label(composite2, 0);
        axis2.setText("Y-Axis: ");
        gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        axis2.setLayoutData(gridData);
        this.yAxisCombo = new Combo(composite2, 4);
        for (Axis axis3 : this.xyGraph.getYAxisList()) {
            this.yAxisCombo.add(axis3.getTitle());
        }
        gridData2 = new GridData(4, 0x1000000, true, false, 2, 1);
        this.yAxisCombo.setLayoutData((Object)gridData2);
        Label label3 = new Label(composite2, 0);
        label3.setText("Trace Color: ");
        gridData = new GridData(4, 0x1000000, false, false, 2, 1);
        label3.setLayoutData((Object)gridData);
        this.traceColorSelector = new ColorSelector(composite2);
        gridData2 = new GridData(1, 0x1000000, false, false, 1, 1);
        this.traceColorSelector.getButton().setLayoutData((Object)gridData2);
        Label label4 = new Label(composite2, 0);
        label4.setText("Trace Type: ");
        gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        label4.setLayoutData((Object)gridData);
        this.traceTypeCombo = new Combo(composite2, 4);
        this.traceTypeCombo.setItems(Trace.TraceType.stringValues());
        gridData2 = new GridData(4, 0x1000000, true, false, 2, 1);
        this.traceTypeCombo.setLayoutData((Object)gridData2);
        this.traceTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TraceConfigPage.this.baseLineCombo.setEnabled(TraceConfigPage.this.traceTypeCombo.getSelectionIndex() == Arrays.asList(Trace.TraceType.values()).indexOf((Object)Trace.TraceType.BAR) || TraceConfigPage.this.traceTypeCombo.getSelectionIndex() == Arrays.asList(Trace.TraceType.values()).indexOf((Object)Trace.TraceType.AREA));
            }
        });
        Label label5 = new Label(composite2, 0);
        label5.setText("Line Width (pixels): ");
        gridData = new GridData(4, 0x1000000, false, false, 2, 1);
        label5.setLayoutData((Object)gridData);
        this.lineWidthSpinner = new Spinner(composite2, 2048);
        this.lineWidthSpinner.setMaximum(100);
        this.lineWidthSpinner.setMinimum(0);
        gridData2 = new GridData(4, 0x1000000, true, false, 1, 1);
        this.lineWidthSpinner.setLayoutData((Object)gridData2);
        Label label6 = new Label(composite2, 0);
        label6.setText("Point Style: ");
        gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        label6.setLayoutData((Object)gridData);
        this.pointStyleCombo = new Combo(composite2, 4);
        this.pointStyleCombo.setItems(Trace.PointStyle.stringValues());
        gridData2 = new GridData(4, 0x1000000, true, false, 2, 1);
        this.pointStyleCombo.setLayoutData((Object)gridData2);
        Label label7 = new Label(composite2, 0);
        label7.setText("Point Size (pixels): ");
        gridData = new GridData(4, 0x1000000, false, false, 2, 1);
        label7.setLayoutData((Object)gridData);
        this.pointSizeSpinner = new Spinner(composite2, 2048);
        this.pointSizeSpinner.setMaximum(100);
        this.pointSizeSpinner.setMinimum(0);
        gridData2 = new GridData(4, 0x1000000, true, false, 1, 1);
        this.pointSizeSpinner.setLayoutData((Object)gridData2);
        Label label8 = new Label(composite2, 0);
        label8.setText("Base Line: ");
        gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        label8.setLayoutData((Object)gridData);
        label8.setToolTipText("The baseline for BAR or AREA trace type");
        this.baseLineCombo = new Combo(composite2, 4);
        this.baseLineCombo.setItems(Trace.BaseLine.stringValues());
        gridData2 = new GridData(4, 0x1000000, true, false, 2, 1);
        this.baseLineCombo.setLayoutData((Object)gridData2);
        Label label9 = new Label(composite2, 0);
        label9.setText("Area Alpha: ");
        gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        label9.setLayoutData((Object)gridData);
        this.areaAlphaSpinner = new Spinner(composite2, 2048);
        this.areaAlphaSpinner.setMaximum(255);
        this.areaAlphaSpinner.setMinimum(0);
        gridData2 = new GridData(1, 0x1000000, true, false, 2, 1);
        this.areaAlphaSpinner.setLayoutData((Object)gridData2);
        this.areaAlphaSpinner.setToolTipText("0 for transparent, 255 for opaque");
        this.antiAliasing = new Button(composite2, 32);
        this.antiAliasing.setText("Anti Aliasing Enabled");
        this.antiAliasing.setLayoutData((Object)new GridData(1, 1, false, false, 3, 1));
        this.errorBarEnabledButton = new Button((Composite)group, 32);
        this.errorBarEnabledButton.setText("Error Bar Enabled");
        this.errorBarEnabledButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.errorBarEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = TraceConfigPage.this.errorBarEnabledButton.getSelection();
                TraceConfigPage.this.xErrorBarTypeCombo.setEnabled(bl);
                TraceConfigPage.this.yErrorBarTypeCombo.setEnabled(bl);
                TraceConfigPage.this.errorBarColorSelector.setEnabled(bl);
                TraceConfigPage.this.errorBarCapWidthSpinner.setEnabled(bl);
                TraceConfigPage.this.drawYErrorInAreaButton.setEnabled(bl);
            }
        });
        Label label10 = new Label((Composite)group, 0);
        label10.setText("X Error Bar Type: ");
        gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        label10.setLayoutData((Object)gridData);
        this.xErrorBarTypeCombo = new Combo((Composite)group, 4);
        this.xErrorBarTypeCombo.setItems(Trace.ErrorBarType.stringValues());
        gridData2 = new GridData(4, 0x1000000, true, false, 1, 1);
        this.xErrorBarTypeCombo.setLayoutData((Object)gridData2);
        Label label11 = new Label((Composite)group, 0);
        label11.setText("Y Error Bar Type: ");
        gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        label11.setLayoutData((Object)gridData);
        this.yErrorBarTypeCombo = new Combo((Composite)group, 4);
        this.yErrorBarTypeCombo.setItems(Trace.ErrorBarType.stringValues());
        gridData2 = new GridData(4, 0x1000000, true, false, 1, 1);
        this.yErrorBarTypeCombo.setLayoutData((Object)gridData2);
        Label label12 = new Label((Composite)group, 0);
        label12.setText("Error Bar Color: ");
        gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        label12.setLayoutData((Object)gridData);
        this.errorBarColorSelector = new ColorSelector((Composite)group);
        gridData2 = new GridData(1, 0x1000000, false, false, 1, 1);
        this.errorBarColorSelector.getButton().setLayoutData((Object)gridData2);
        Label label13 = new Label((Composite)group, 0);
        label13.setText("Error Bar Cap Width \n(pixels): ");
        gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        label13.setLayoutData((Object)gridData);
        this.errorBarCapWidthSpinner = new Spinner((Composite)group, 2048);
        this.errorBarCapWidthSpinner.setMaximum(100);
        this.errorBarCapWidthSpinner.setMinimum(0);
        gridData2 = new GridData(4, 0x1000000, true, false, 1, 1);
        this.errorBarCapWidthSpinner.setLayoutData((Object)gridData2);
        this.drawYErrorInAreaButton = new Button((Composite)group, 32);
        this.drawYErrorInAreaButton.setText("Draw Y Error In Area");
        this.drawYErrorInAreaButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.initialize();
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void applyChanges() {
        this.trace.setName(this.nameText.getText());
        this.trace.setXAxis(this.xyGraph.getXAxisList().get(this.xAxisCombo.getSelectionIndex()));
        this.trace.setYAxis(this.xyGraph.getYAxisList().get(this.yAxisCombo.getSelectionIndex()));
        this.trace.setTraceColor(XYGraphMediaFactory.getInstance().getColor(this.traceColorSelector.getColorValue()));
        this.trace.setTraceType(Trace.TraceType.values()[this.traceTypeCombo.getSelectionIndex()]);
        this.trace.setLineWidth(this.lineWidthSpinner.getSelection());
        this.trace.setPointStyle(Trace.PointStyle.values()[this.pointStyleCombo.getSelectionIndex()]);
        this.trace.setPointSize(this.pointSizeSpinner.getSelection());
        this.trace.setBaseLine(Trace.BaseLine.values()[this.baseLineCombo.getSelectionIndex()]);
        this.trace.setAreaAlpha(this.areaAlphaSpinner.getSelection());
        this.trace.setAntiAliasing(this.antiAliasing.getSelection());
        this.trace.setErrorBarEnabled(this.errorBarEnabledButton.getSelection());
        this.trace.setXErrorBarType(Trace.ErrorBarType.values()[this.xErrorBarTypeCombo.getSelectionIndex()]);
        this.trace.setYErrorBarType(Trace.ErrorBarType.values()[this.yErrorBarTypeCombo.getSelectionIndex()]);
        this.trace.setErrorBarColor(XYGraphMediaFactory.getInstance().getColor(this.errorBarColorSelector.getColorValue()));
        this.trace.setErrorBarCapWidth(this.errorBarCapWidthSpinner.getSelection());
        this.trace.setDrawYErrorInArea(this.drawYErrorInAreaButton.getSelection());
    }

    private void initialize() {
        this.nameText.setText(this.trace.getName());
        this.xAxisCombo.select(this.xyGraph.getXAxisList().indexOf((Object)this.trace.getXAxis()));
        this.yAxisCombo.select(this.xyGraph.getYAxisList().indexOf((Object)this.trace.getYAxis()));
        this.traceColorSelector.setColorValue(this.trace.getTraceColor().getRGB());
        this.traceTypeCombo.select(Arrays.asList(Trace.TraceType.values()).indexOf((Object)this.trace.getTraceType()));
        this.lineWidthSpinner.setSelection(this.trace.getLineWidth());
        this.pointStyleCombo.select(Arrays.asList(Trace.PointStyle.values()).indexOf((Object)this.trace.getPointStyle()));
        this.pointSizeSpinner.setSelection(this.trace.getPointSize());
        this.baseLineCombo.select(Arrays.asList(Trace.BaseLine.values()).indexOf((Object)this.trace.getBaseLine()));
        this.areaAlphaSpinner.setSelection(this.trace.getAreaAlpha());
        this.antiAliasing.setSelection(this.trace.isAntiAliasing());
        this.errorBarEnabledButton.setSelection(this.trace.isErrorBarEnabled());
        this.xErrorBarTypeCombo.select(Arrays.asList(Trace.ErrorBarType.values()).indexOf((Object)this.trace.getXErrorBarType()));
        this.yErrorBarTypeCombo.select(Arrays.asList(Trace.ErrorBarType.values()).indexOf((Object)this.trace.getYErrorBarType()));
        this.errorBarColorSelector.setColorValue(this.trace.getErrorBarColor().getRGB());
        this.errorBarCapWidthSpinner.setSelection(this.trace.getErrorBarCapWidth());
        this.drawYErrorInAreaButton.setSelection(this.trace.isDrawYErrorInArea());
        boolean bl = this.errorBarEnabledButton.getSelection();
        this.xErrorBarTypeCombo.setEnabled(bl);
        this.yErrorBarTypeCombo.setEnabled(bl);
        this.errorBarColorSelector.setEnabled(bl);
        this.errorBarCapWidthSpinner.setEnabled(bl);
        this.drawYErrorInAreaButton.setEnabled(bl);
        this.baseLineCombo.setEnabled(this.traceTypeCombo.getSelectionIndex() == Arrays.asList(Trace.TraceType.values()).indexOf((Object)Trace.TraceType.BAR) || this.traceTypeCombo.getSelectionIndex() == Arrays.asList(Trace.TraceType.values()).indexOf((Object)Trace.TraceType.AREA));
    }
}

