/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.toolbar;

import org.csstudio.swt.xygraph.figures.Annotation;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RemoveAnnotationDialog
extends Dialog {
    private XYGraph xyGraph;
    private Combo annotationsCombo;
    private Annotation removedAnnotation;

    protected RemoveAnnotationDialog(Shell shell, XYGraph xYGraph) {
        super(shell);
        this.xyGraph = xYGraph;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Remove Annotation");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        composite3.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite3, 0);
        label.setLayoutData((Object)new GridData());
        if (this.xyGraph.getPlotArea().getAnnotationList().size() > 0) {
            label.setText("Select the annotation to be removed: ");
            this.annotationsCombo = new Combo(composite3, 4);
            this.annotationsCombo.setLayoutData((Object)new GridData(4, 0, true, false));
            for (Annotation annotation : this.xyGraph.getPlotArea().getAnnotationList()) {
                this.annotationsCombo.add(annotation.getName());
            }
            this.annotationsCombo.select(0);
        } else {
            label.setText("There is no annotation on the graph.");
        }
        return composite2;
    }

    protected void okPressed() {
        if (this.annotationsCombo != null) {
            this.removedAnnotation = this.xyGraph.getPlotArea().getAnnotationList().get(this.annotationsCombo.getSelectionIndex());
        }
        super.okPressed();
    }

    public Annotation getAnnotation() {
        return this.removedAnnotation;
    }
}

