/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.toolbar;

import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.util.XYGraphMediaFactory;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GraphConfigPage {
    private XYGraph xyGraph;
    private Text titleText;
    private Font titleFont;
    private ColorSelector titleColorSelector;
    private ColorSelector plotAreaColorSelector;
    private Button showTitle;
    private Button showLegend;
    private Button showPlotAreaBorder;
    private Button transparent;

    public GraphConfigPage(XYGraph xYGraph) {
        this.xyGraph = xYGraph;
        this.titleFont = xYGraph.getTitleFont();
    }

    public void createPage(final Composite composite) {
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        Label label = new Label(composite, 0);
        label.setText("Title: ");
        label.setLayoutData((Object)gridData);
        this.titleText = new Text(composite, 2052);
        this.titleText.setText(this.xyGraph.getTitle());
        GridData gridData2 = new GridData(4, 0x1000000, true, false, 2, 1);
        this.titleText.setLayoutData((Object)gridData2);
        final Label label2 = new Label(composite, 0);
        label2.setText("Title Font: " + (this.titleFont == null ? "System Default" : this.titleFont.getFontData()[0].getName()));
        label2.setFont(this.titleFont);
        label2.setForeground(this.xyGraph.getTitleColor());
        gridData = new GridData(4, 0x1000000, false, false, 2, 1);
        label2.setLayoutData((Object)gridData);
        Button button = new Button(composite, 8);
        button.setText("Change...");
        gridData2 = new GridData(1, 0x1000000, false, false, 1, 1);
        button.setLayoutData((Object)gridData2);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FontData fontData;
                FontDialog fontDialog = new FontDialog(composite.getShell());
                if (GraphConfigPage.this.titleFont != null) {
                    fontDialog.setFontList(GraphConfigPage.this.titleFont.getFontData());
                }
                if ((fontData = fontDialog.open()) != null) {
                    GraphConfigPage.this.titleFont = XYGraphMediaFactory.getInstance().getFont(fontData);
                    label2.setFont(GraphConfigPage.this.titleFont);
                    label2.setText("Title Font: " + fontData.getName());
                    composite.getShell().layout(true, true);
                }
            }
        });
        Label label3 = new Label(composite, 0);
        label3.setText("Title Color:");
        gridData = new GridData(4, 0x1000000, false, false, 2, 1);
        label3.setLayoutData((Object)gridData);
        this.titleColorSelector = new ColorSelector(composite);
        gridData2 = new GridData(1, 0x1000000, false, false, 1, 1);
        this.titleColorSelector.getButton().setLayoutData((Object)gridData2);
        this.titleColorSelector.setColorValue(this.xyGraph.getTitleColor().getRGB());
        this.titleColorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                label2.setForeground(XYGraphMediaFactory.getInstance().getColor(GraphConfigPage.this.titleColorSelector.getColorValue()));
            }
        });
        Label label4 = new Label(composite, 0);
        label4.setText("Plot Area Background Color:");
        gridData = new GridData(4, 0x1000000, false, false, 2, 1);
        label4.setLayoutData((Object)gridData);
        this.plotAreaColorSelector = new ColorSelector(composite);
        gridData2 = new GridData(1, 0x1000000, false, false, 1, 1);
        this.plotAreaColorSelector.getButton().setLayoutData((Object)gridData2);
        this.plotAreaColorSelector.setColorValue(this.xyGraph.getPlotArea().getBackgroundColor().getRGB());
        this.showTitle = new Button(composite, 32);
        this.showTitle.setSelection(this.xyGraph.isShowTitle());
        this.showTitle.setText("Show Title");
        gridData2 = new GridData(1, 0x1000000, false, false, 3, 1);
        this.showTitle.setLayoutData((Object)gridData2);
        this.showLegend = new Button(composite, 32);
        this.showLegend.setSelection(this.xyGraph.isShowLegend());
        this.showLegend.setText("Show Legend");
        gridData2 = new GridData(1, 0x1000000, false, false, 3, 1);
        this.showLegend.setLayoutData((Object)gridData2);
        this.showPlotAreaBorder = new Button(composite, 32);
        this.showPlotAreaBorder.setSelection(this.xyGraph.getPlotArea().isShowBorder());
        this.showPlotAreaBorder.setText("Show Plot Area Border");
        gridData2 = new GridData(1, 0x1000000, false, false, 3, 1);
        this.showPlotAreaBorder.setLayoutData((Object)gridData2);
        this.transparent = new Button(composite, 32);
        this.transparent.setSelection(this.xyGraph.isTransparent());
        this.transparent.setText("Transparent");
        gridData2 = new GridData(1, 0x1000000, false, false, 3, 1);
        this.transparent.setLayoutData((Object)gridData2);
    }

    public void applyChanges() {
        this.xyGraph.setTitle(this.titleText.getText());
        this.xyGraph.setTitleFont(this.titleFont);
        this.xyGraph.setTitleColor(XYGraphMediaFactory.getInstance().getColor(this.titleColorSelector.getColorValue()));
        this.xyGraph.getPlotArea().setBackgroundColor(XYGraphMediaFactory.getInstance().getColor(this.plotAreaColorSelector.getColorValue()));
        this.xyGraph.setShowTitle(this.showTitle.getSelection());
        this.xyGraph.setShowLegend(this.showLegend.getSelection());
        this.xyGraph.getPlotArea().setShowBorder(this.showPlotAreaBorder.getSelection());
        this.xyGraph.setTransparent(this.transparent.getSelection());
    }

    public XYGraph getXYGraph() {
        return this.xyGraph;
    }
}

