/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.toolbar;

import org.csstudio.swt.xygraph.linearscale.Range;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class DoubleInputText {
    private Text text;
    private String previousText;
    private Range range;

    public DoubleInputText(Composite composite, int n) {
        this.text = new Text(composite, n);
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                DoubleInputText.this.previousText = DoubleInputText.this.text.getText();
            }

            public void focusLost(FocusEvent focusEvent) {
                try {
                    double d = Double.parseDouble(DoubleInputText.this.text.getText());
                    if (DoubleInputText.this.range != null) {
                        if (d > DoubleInputText.this.range.getUpper()) {
                            d = DoubleInputText.this.range.getUpper();
                        } else if (d < DoubleInputText.this.range.getLower()) {
                            d = DoubleInputText.this.range.getLower();
                        }
                    }
                    DoubleInputText.this.text.setText(String.valueOf(d));
                }
                catch (Exception exception) {
                    DoubleInputText.this.text.setText(DoubleInputText.this.previousText);
                    return;
                }
            }
        });
    }

    public DoubleInputText(Composite composite, int n, double d, double d2) {
        this(composite, n);
        this.range = new Range(d2, d);
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public Text getText() {
        return this.text;
    }

    public double getDoubleValue() {
        return Double.parseDouble(this.text.getText());
    }
}

