/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.toolbar;

import org.csstudio.swt.xygraph.figures.Axis;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.csstudio.swt.xygraph.toolbar.DoubleInputText;
import org.csstudio.swt.xygraph.util.XYGraphMediaFactory;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class AxisConfigPage {
    private XYGraph xyGraph;
    private Axis axis;
    private Text titleText;
    private Label scaleFontLabel;
    private Font scaleFont;
    private Label titleFontLabel;
    private Font titleFont;
    private ColorSelector axisColorSelector;
    private Button primaryButton;
    private Button logButton;
    private Button autoScaleButton;
    private Label maxOrAutoScaleLabel;
    private DoubleInputText maxOrAutoScaleThrText;
    private Label minLabel;
    private DoubleInputText minText;
    private Button dateEnabledButton;
    private Button autoFormat;
    private Label formatLabel;
    private Text formatText;
    private Button showGridButton;
    private Button dashGridLineButton;
    private ColorSelector gridColorSelector;
    private Composite composite;

    public AxisConfigPage(XYGraph xYGraph, Axis axis) {
        this.xyGraph = xYGraph;
        this.axis = axis;
        this.scaleFont = axis.getFont();
        this.titleFont = axis.getTitleFont();
    }

    public void createPage(final Composite composite) {
        this.composite = composite;
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        Label label = new Label(composite, 0);
        label.setText("Title: ");
        label.setLayoutData((Object)gridData);
        this.titleText = new Text(composite, 2052);
        GridData gridData2 = new GridData(4, 0x1000000, true, false, 2, 1);
        this.titleText.setLayoutData((Object)gridData2);
        this.titleFontLabel = new Label(composite, 0);
        gridData = new GridData(4, 0x1000000, false, false, 2, 1);
        this.titleFontLabel.setLayoutData((Object)gridData);
        Button button = new Button(composite, 8);
        button.setText("Change...");
        gridData2 = new GridData(1, 0x1000000, false, false, 1, 1);
        button.setLayoutData((Object)gridData2);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FontData fontData;
                FontDialog fontDialog = new FontDialog(composite.getShell());
                if (AxisConfigPage.this.titleFont != null) {
                    fontDialog.setFontList(AxisConfigPage.this.titleFont.getFontData());
                }
                if ((fontData = fontDialog.open()) != null) {
                    AxisConfigPage.this.titleFont = XYGraphMediaFactory.getInstance().getFont(fontData);
                    AxisConfigPage.this.titleFontLabel.setFont(AxisConfigPage.this.titleFont);
                    AxisConfigPage.this.titleFontLabel.setText("Title Font: " + fontData.getName());
                    composite.getShell().layout(true, true);
                }
            }
        });
        this.scaleFontLabel = new Label(composite, 0);
        gridData = new GridData(4, 0x1000000, false, false, 2, 1);
        this.scaleFontLabel.setLayoutData((Object)gridData);
        Button button2 = new Button(composite, 8);
        button2.setText("Change...");
        gridData2 = new GridData(1, 0x1000000, false, false, 1, 1);
        button2.setLayoutData((Object)gridData2);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FontData fontData;
                FontDialog fontDialog = new FontDialog(composite.getShell());
                if (AxisConfigPage.this.scaleFont != null) {
                    fontDialog.setFontList(AxisConfigPage.this.scaleFont.getFontData());
                }
                if ((fontData = fontDialog.open()) != null) {
                    AxisConfigPage.this.scaleFont = XYGraphMediaFactory.getInstance().getFont(fontData);
                    AxisConfigPage.this.scaleFontLabel.setFont(AxisConfigPage.this.scaleFont);
                    AxisConfigPage.this.scaleFontLabel.setText("Scale Font: " + fontData.getName());
                    composite.getShell().layout(true, true);
                }
            }
        });
        Label label2 = new Label(composite, 0);
        label2.setText("Axis Color:");
        gridData = new GridData(4, 0x1000000, false, false, 2, 1);
        label2.setLayoutData((Object)gridData);
        this.axisColorSelector = new ColorSelector(composite);
        gridData2 = new GridData(1, 0x1000000, false, false, 1, 1);
        this.axisColorSelector.getButton().setLayoutData((Object)gridData2);
        this.axisColorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AxisConfigPage.this.scaleFontLabel.setForeground(XYGraphMediaFactory.getInstance().getColor(AxisConfigPage.this.axisColorSelector.getColorValue()));
                AxisConfigPage.this.titleFontLabel.setForeground(XYGraphMediaFactory.getInstance().getColor(AxisConfigPage.this.axisColorSelector.getColorValue()));
            }
        });
        this.primaryButton = new Button(composite, 32);
        this.configCheckButton(this.primaryButton, "On Primary Side(Bottom/Left)");
        this.logButton = new Button(composite, 32);
        this.configCheckButton(this.logButton, "Log");
        this.autoScaleButton = new Button(composite, 32);
        this.configCheckButton(this.autoScaleButton, "Auto Scale Enabled");
        this.maxOrAutoScaleLabel = new Label(composite, 0);
        gridData = new GridData(1, 0x1000000, false, false, 1, 1);
        this.maxOrAutoScaleLabel.setLayoutData((Object)gridData);
        this.maxOrAutoScaleThrText = new DoubleInputText(composite, 2052);
        gridData2 = new GridData(4, 1, true, false, 2, 1);
        this.maxOrAutoScaleThrText.getText().setLayoutData((Object)gridData2);
        this.minLabel = new Label(composite, 0);
        this.minLabel.setText("Minimum: ");
        gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.minLabel.setLayoutData((Object)gridData);
        this.minText = new DoubleInputText(composite, 2052);
        gridData2 = new GridData(4, 1, true, false, 2, 1);
        this.minText.getText().setLayoutData((Object)gridData2);
        this.autoScaleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (AxisConfigPage.this.autoScaleButton.getSelection()) {
                    AxisConfigPage.this.maxOrAutoScaleLabel.setText("Auto Scale Threshold(%)");
                    AxisConfigPage.this.maxOrAutoScaleThrText.setRange(new Range(0.0, 100.0));
                    AxisConfigPage.this.maxOrAutoScaleThrText.getText().setText(String.valueOf(AxisConfigPage.this.axis.getAutoScaleThreshold()));
                    AxisConfigPage.this.minLabel.setVisible(false);
                    AxisConfigPage.this.minText.getText().setVisible(false);
                } else {
                    AxisConfigPage.this.maxOrAutoScaleLabel.setText("Maximum");
                    AxisConfigPage.this.maxOrAutoScaleThrText.setRange(null);
                    AxisConfigPage.this.maxOrAutoScaleThrText.getText().setText(String.valueOf(AxisConfigPage.this.axis.getRange().getUpper()));
                    AxisConfigPage.this.minLabel.setVisible(true);
                    AxisConfigPage.this.minText.getText().setVisible(true);
                }
                composite.getShell().layout(true, true);
            }
        });
        this.dateEnabledButton = new Button(composite, 32);
        this.configCheckButton(this.dateEnabledButton, "Time Format Enabled");
        this.autoFormat = new Button(composite, 32);
        this.configCheckButton(this.autoFormat, "Auto Format");
        this.formatLabel = new Label(composite, 0);
        gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.formatLabel.setLayoutData((Object)gridData);
        this.formatText = new Text(composite, 2052);
        gridData2 = new GridData(4, 0x1000000, true, false, 2, 1);
        this.formatText.setLayoutData((Object)gridData2);
        this.dateEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = AxisConfigPage.this.axis.isDateEnabled();
                boolean bl2 = AxisConfigPage.this.axis.isAutoFormat();
                AxisConfigPage.this.axis.setDateEnabled(AxisConfigPage.this.dateEnabledButton.getSelection());
                AxisConfigPage.this.axis.setAutoFormat(true);
                AxisConfigPage.this.formatLabel.setText(AxisConfigPage.this.dateEnabledButton.getSelection() ? "Time Format: " : "Numeric Format: ");
                AxisConfigPage.this.formatText.setText(AxisConfigPage.this.axis.getFormatPattern());
                AxisConfigPage.this.axis.setDateEnabled(bl);
                AxisConfigPage.this.axis.setAutoFormat(bl2);
                composite.getShell().layout(true, true);
            }
        });
        this.autoFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AxisConfigPage.this.formatText.setEnabled(!AxisConfigPage.this.autoFormat.getSelection());
                if (AxisConfigPage.this.autoFormat.getSelection()) {
                    boolean bl = AxisConfigPage.this.axis.isDateEnabled();
                    boolean bl2 = AxisConfigPage.this.axis.isAutoFormat();
                    AxisConfigPage.this.axis.setDateEnabled(AxisConfigPage.this.dateEnabledButton.getSelection());
                    AxisConfigPage.this.axis.setAutoFormat(AxisConfigPage.this.autoFormat.getSelection());
                    AxisConfigPage.this.formatText.setText(AxisConfigPage.this.axis.getFormatPattern());
                    AxisConfigPage.this.axis.setDateEnabled(bl);
                    AxisConfigPage.this.axis.setAutoFormat(bl2);
                }
            }
        });
        this.showGridButton = new Button(composite, 32);
        this.configCheckButton(this.showGridButton, "Show Grid Line");
        this.dashGridLineButton = new Button(composite, 32);
        this.configCheckButton(this.dashGridLineButton, "Dash Grid Line");
        Label label3 = new Label(composite, 0);
        label3.setText("Grid Color");
        gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        label3.setLayoutData((Object)gridData);
        this.gridColorSelector = new ColorSelector(composite);
        gridData2 = new GridData(1, 0x1000000, false, false, 1, 1);
        this.gridColorSelector.getButton().setLayoutData((Object)gridData2);
        this.initialize();
    }

    private void configCheckButton(Button button, String string) {
        button.setText(string);
        button.setLayoutData((Object)new GridData(1, 1, false, false, 3, 2));
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void applyChanges() {
        this.axis.setTitle(this.titleText.getText());
        this.axis.setFont(this.scaleFont);
        this.axis.setTitleFont(this.titleFont);
        this.axis.setForegroundColor(XYGraphMediaFactory.getInstance().getColor(this.axisColorSelector.getColorValue()));
        this.axis.setPrimarySide(this.primaryButton.getSelection());
        this.axis.setLogScale(this.logButton.getSelection());
        this.axis.setAutoScale(this.autoScaleButton.getSelection());
        if (this.autoScaleButton.getSelection()) {
            this.axis.setAutoScaleThreshold(this.maxOrAutoScaleThrText.getDoubleValue());
        } else {
            this.axis.setRange(this.minText.getDoubleValue(), this.maxOrAutoScaleThrText.getDoubleValue());
        }
        this.axis.setDateEnabled(this.dateEnabledButton.getSelection());
        this.axis.setAutoFormat(this.autoFormat.getSelection());
        if (!this.autoFormat.getSelection()) {
            String string = this.axis.getFormatPattern();
            this.axis.setFormatPattern(this.formatText.getText());
            try {
                this.axis.format(0);
            }
            catch (Exception exception) {
                this.axis.setFormatPattern(string);
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 33);
                messageBox.setMessage("Failed to set format due to incorrect format pattern: " + exception.getMessage());
                messageBox.setText("Format pattern error!");
                messageBox.open();
            }
        }
        this.axis.setShowMajorGrid(this.showGridButton.getSelection());
        this.axis.setDashGridLine(this.dashGridLineButton.getSelection());
        this.axis.setMajorGridColor(XYGraphMediaFactory.getInstance().getColor(this.gridColorSelector.getColorValue()));
    }

    private void initialize() {
        this.titleText.setText(this.axis.getTitle());
        this.scaleFontLabel.setForeground(this.axis.getForegroundColor());
        this.scaleFontLabel.setFont(this.scaleFont);
        this.scaleFontLabel.setText("Scale Font: " + this.scaleFont.getFontData()[0].getName());
        this.titleFontLabel.setForeground(this.axis.getForegroundColor());
        this.titleFontLabel.setFont(this.titleFont);
        this.titleFontLabel.setText("Title Font: " + this.titleFont.getFontData()[0].getName());
        this.axisColorSelector.setColorValue(this.axis.getForegroundColor().getRGB());
        this.primaryButton.setSelection(this.axis.isOnPrimarySide());
        if (this.axis == this.xyGraph.primaryXAxis || this.axis == this.xyGraph.primaryYAxis) {
            this.primaryButton.setEnabled(false);
        }
        this.logButton.setSelection(this.axis.isLogScaleEnabled());
        this.autoScaleButton.setSelection(this.axis.isAutoScale());
        if (this.autoScaleButton.getSelection()) {
            this.maxOrAutoScaleLabel.setText("Auto Scale Threshold(%)");
            this.maxOrAutoScaleThrText.setRange(new Range(0.0, 100.0));
            this.maxOrAutoScaleThrText.getText().setText(String.valueOf(this.axis.getAutoScaleThreshold()));
            this.minLabel.setVisible(false);
            this.minText.getText().setVisible(false);
        } else {
            this.maxOrAutoScaleLabel.setText("Maximum");
            this.maxOrAutoScaleThrText.setRange(null);
            this.maxOrAutoScaleThrText.getText().setText(String.valueOf(this.axis.getRange().getUpper()));
            this.minLabel.setVisible(true);
            this.minText.getText().setVisible(true);
        }
        this.minText.getText().setText(String.valueOf(this.axis.getRange().getLower()));
        this.dateEnabledButton.setSelection(this.axis.isDateEnabled());
        this.autoFormat.setSelection(this.axis.isAutoFormat());
        this.formatLabel.setText(this.dateEnabledButton.getSelection() ? "Time Format: " : "Numeric Format: ");
        this.formatText.setText(this.axis.getFormatPattern());
        this.formatText.setEnabled(!this.autoFormat.getSelection());
        this.showGridButton.setSelection(this.axis.isShowMajorGrid());
        this.dashGridLineButton.setSelection(this.axis.isDashGridLine());
        this.gridColorSelector.setColorValue(this.axis.getMajorGridColor().getRGB());
    }
}

