/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.toolbar;

import java.util.List;
import org.csstudio.swt.xygraph.Messages;
import org.csstudio.swt.xygraph.figures.Annotation;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.toolbar.AnnotationConfigPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AddAnnotationDialog
extends Dialog {
    private AnnotationConfigPage configPage;

    protected AddAnnotationDialog(Shell shell, XYGraph xYGraph) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        int n = xYGraph.getPlotArea().getAnnotationList().size();
        String string = NLS.bind((String)Messages.Annotation_DefaultNameFmt, (Object)(n + 1));
        List<Trace> list = xYGraph.getPlotArea().getTraceList();
        Annotation annotation = list.size() > 0 ? new Annotation(string, list.get(0)) : new Annotation(string, xYGraph.primaryXAxis, xYGraph.primaryYAxis);
        this.configPage = new AnnotationConfigPage(xYGraph, annotation);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.Annotation_Add);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        this.configPage.createPage(composite3);
        return composite2;
    }

    protected void okPressed() {
        this.configPage.applyChanges();
        super.okPressed();
    }

    public Annotation getAnnotation() {
        return this.configPage.getAnnotation();
    }
}

