/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.linearscale;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.csstudio.swt.xygraph.linearscale.AbstractScale;
import org.csstudio.swt.xygraph.linearscale.LinearScale;
import org.csstudio.swt.xygraph.util.XYGraphMediaFactory;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;

public class LinearScaledMarker
extends Figure {
    private Map<String, MarkerProperties> markersMap = new LinkedHashMap<String, MarkerProperties>();
    private static final RGB DEFAULT_MARKER_COLOR = XYGraphMediaFactory.COLOR_RED;
    private String[] labels;
    private double[] markerValues;
    private Dimension[] markerLabelDimensions;
    private List<Color> markerColorsList = new ArrayList<Color>();
    private LinearScale scale;
    private AbstractScale.LabelSide makerLablesPosition = AbstractScale.LabelSide.Secondary;
    private boolean markerLineVisible = false;
    private boolean markerLableVisible = true;
    private int tickLabelMaxLength;
    private boolean dirty = true;
    private int[] markerPositions;
    private static final int TICK_LENGTH = 10;
    private static final int TICK_LINE_WIDTH = 2;
    private static final int GAP_BTW_MARK_LABEL = 3;

    public LinearScaledMarker(LinearScale linearScale) {
        this.scale = linearScale;
        this.setFont(XYGraphMediaFactory.getInstance().getFont(XYGraphMediaFactory.FONT_TAHOMA));
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public void setMarkerElementValue(String string, double d) {
        if (this.markersMap.containsKey(string)) {
            this.markersMap.get(string).value = d;
            this.dirty = true;
        }
    }

    public void setMarkerElementColor(String string, RGB rGB) {
        if (this.markersMap.containsKey(string)) {
            this.markersMap.get(string).color = rGB;
            this.dirty = true;
        }
    }

    public void addMarkerElement(String string, double d, RGB rGB) {
        if (this.markersMap.containsKey(string)) {
            this.markersMap.get(string).value = d;
            this.markersMap.get(string).color = rGB;
        } else {
            this.markersMap.put(string, new MarkerProperties(d, rGB));
        }
        this.dirty = true;
    }

    public void addMarkerElement(String string, double d) {
        if (this.markersMap.containsKey(string)) {
            this.markersMap.get(string).value = d;
        } else {
            this.markersMap.put(string, new MarkerProperties(d, DEFAULT_MARKER_COLOR));
        }
        this.dirty = true;
    }

    public void removeMarkerElement(String string) {
        this.markersMap.remove(string);
        this.dirty = true;
    }

    protected void paintClientArea(Graphics graphics) {
        graphics.translate(this.bounds.x, this.bounds.y);
        this.updateTick();
        this.drawMarkerTick(graphics);
        super.paintClientArea(graphics);
    }

    private void drawMarkerTick(Graphics graphics) {
        graphics.setLineWidth(2);
        if (this.scale.isHorizontal()) {
            if (this.makerLablesPosition == AbstractScale.LabelSide.Primary) {
                int n = 0;
                int[] nArray = this.markerPositions;
                int n2 = this.markerPositions.length;
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = nArray[n3];
                    graphics.setForegroundColor(this.markerColorsList.get(n));
                    graphics.drawLine(n4, 0, n4, 10);
                    if (this.isMarkerLableVisible()) {
                        graphics.drawText(this.labels[n], n4 - this.markerLabelDimensions[n].width / 2, 13);
                    }
                    ++n;
                    ++n3;
                }
            } else {
                int n = 0;
                int[] nArray = this.markerPositions;
                int n5 = this.markerPositions.length;
                int n6 = 0;
                while (n6 < n5) {
                    int n7 = nArray[n6];
                    graphics.setForegroundColor(this.markerColorsList.get(n));
                    graphics.drawLine(n7, this.bounds.height, n7, this.bounds.height - 10);
                    if (this.isMarkerLableVisible()) {
                        graphics.drawText(this.labels[n], n7 - this.markerLabelDimensions[n].width / 2, this.bounds.height - 10 - 3 - this.markerLabelDimensions[n].height);
                    }
                    ++n;
                    ++n6;
                }
            }
        } else if (this.makerLablesPosition == AbstractScale.LabelSide.Primary) {
            int n = 0;
            while (n < this.markerPositions.length) {
                graphics.setForegroundColor(this.markerColorsList.get(n));
                graphics.drawLine(this.bounds.width, this.markerPositions[n], this.bounds.width - 10, this.markerPositions[n]);
                if (this.isMarkerLableVisible()) {
                    graphics.drawText(this.labels[n], this.bounds.width - 10 - 3 - this.markerLabelDimensions[n].width, this.markerPositions[n] - this.markerLabelDimensions[n].height / 2);
                }
                ++n;
            }
        } else {
            int n = 0;
            int[] nArray = this.markerPositions;
            int n8 = this.markerPositions.length;
            int n9 = 0;
            while (n9 < n8) {
                int n10 = nArray[n9];
                graphics.setForegroundColor(this.markerColorsList.get(n));
                graphics.drawLine(0, n10, 10, n10);
                if (this.isMarkerLableVisible()) {
                    graphics.drawText(this.labels[n], 13, n10 - this.markerLabelDimensions[n].height / 2);
                }
                ++n;
                ++n9;
            }
        }
    }

    public void setBounds(Rectangle rectangle) {
        if (!this.bounds.equals((Object)rectangle)) {
            this.dirty = true;
        }
        super.setBounds(rectangle);
    }

    public void updateTick() {
        if (this.dirty) {
            this.updateMarkerElments();
            this.updateTickLabelMaxLength();
        }
        this.dirty = false;
    }

    private void updateTickLabelMaxLength() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.labels.length) {
            Dimension dimension = FigureUtilities.getTextExtents((String)this.labels[n2], (Font)this.scale.getFont());
            if (dimension.width > n) {
                n = dimension.width;
            }
            ++n2;
        }
        this.tickLabelMaxLength = n;
    }

    public String[] getLabels() {
        String[] stringArray = new String[this.markersMap.size()];
        int n = 0;
        Iterator<String> iterator = this.markersMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            stringArray[n] = string = iterator.next();
            ++n;
        }
        return stringArray;
    }

    public void updateMarkerElments() {
        this.labels = new String[this.markersMap.size()];
        this.markerColorsList.clear();
        this.markerValues = new double[this.markersMap.size()];
        this.markerLabelDimensions = new Dimension[this.markersMap.size()];
        this.markerPositions = new int[this.markerValues.length];
        int n = 0;
        Iterator<String> iterator = this.markersMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            this.labels[n] = string = iterator.next();
            this.markerValues[n] = this.markersMap.get(string).value;
            this.markerPositions[n] = this.scale.getValuePosition(this.markerValues[n], true);
            this.markerLabelDimensions[n] = FigureUtilities.getTextExtents((String)string, (Font)this.getFont());
            this.markerColorsList.add(XYGraphMediaFactory.getInstance().getColor(this.markersMap.get(string).color));
            ++n;
        }
    }

    public void setScale(LinearScale linearScale) {
        this.scale = linearScale;
        this.dirty = true;
    }

    public LinearScale getScale() {
        return this.scale;
    }

    public void setLabelSide(AbstractScale.LabelSide labelSide) {
        this.makerLablesPosition = labelSide;
        this.dirty = true;
    }

    public AbstractScale.LabelSide getMakerLablesPosition() {
        return this.makerLablesPosition;
    }

    public void setMarkerLineVisible(boolean bl) {
        this.markerLineVisible = bl;
        this.dirty = true;
    }

    public boolean isMarkerLineVisible() {
        return this.markerLineVisible;
    }

    public void setMarkerLableVisible(boolean bl) {
        this.markerLableVisible = bl;
        this.dirty = true;
    }

    public boolean isMarkerLableVisible() {
        return this.markerLableVisible;
    }

    public Dimension getPreferredSize(int n, int n2) {
        this.updateTick();
        Dimension dimension = new Dimension(n, n2);
        if (this.scale.isHorizontal()) {
            dimension.width = this.scale.getSize().width;
            dimension.height = FigureUtilities.getTextExtents((String)"dummy", (Font)this.getFont()).height + 3 + 10;
        } else {
            this.updateTickLabelMaxLength();
            dimension.width = this.tickLabelMaxLength + 3 + 10;
            dimension.height = this.scale.getSize().height;
        }
        return dimension;
    }

    private static class MarkerProperties {
        private double value;
        private RGB color;

        public MarkerProperties(double d, RGB rGB) {
            this.value = d;
            this.color = rGB;
        }
    }
}

