/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.linearscale;

import java.util.ArrayList;
import org.csstudio.swt.xygraph.linearscale.AbstractScale;
import org.csstudio.swt.xygraph.linearscale.LinearScale;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;

public class LinearScaleTickMarks
extends Figure {
    private LinearScale scale;
    protected static final int LINE_WIDTH = 1;
    public static final int MAJOR_TICK_LENGTH = 6;
    public static final int MINOR_TICK_LENGTH = 3;
    private int minorGridStepInPixel;
    private int minorTicksNumber;

    public LinearScaleTickMarks(LinearScale linearScale) {
        this.scale = linearScale;
        this.setForegroundColor(linearScale.getForegroundColor());
    }

    public LinearScale getAxis() {
        return this.scale;
    }

    protected void paintClientArea(Graphics graphics) {
        graphics.translate(this.bounds.x, this.bounds.y);
        ArrayList<Integer> arrayList = this.scale.getScaleTickLabels().getTickLabelPositions();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (this.scale.isHorizontal()) {
            this.drawXTickMarks(graphics, arrayList, this.scale.getTickLablesSide(), n, n2);
        } else {
            this.drawYTickMarks(graphics, arrayList, this.scale.getTickLablesSide(), n, n2);
        }
    }

    public void updateMinorTickParas() {
        if (this.scale.isDateEnabled()) {
            this.minorTicksNumber = 6;
            this.minorGridStepInPixel = (int)((double)this.scale.getScaleTickLabels().getGridStepInPixel() / 6.0);
            return;
        }
        if (this.scale.getScaleTickLabels().getGridStepInPixel() / 5 >= this.scale.getMinorTickMarkStepHint()) {
            this.minorTicksNumber = 5;
            this.minorGridStepInPixel = (int)((double)this.scale.getScaleTickLabels().getGridStepInPixel() / 5.0);
            return;
        }
        if (this.scale.getScaleTickLabels().getGridStepInPixel() / 4 >= this.scale.getMinorTickMarkStepHint()) {
            this.minorTicksNumber = 4;
            this.minorGridStepInPixel = (int)((double)this.scale.getScaleTickLabels().getGridStepInPixel() / 4.0);
            return;
        }
        this.minorTicksNumber = 2;
        this.minorGridStepInPixel = (int)((double)this.scale.getScaleTickLabels().getGridStepInPixel() / 2.0);
    }

    private void drawXTickMarks(Graphics graphics, ArrayList<Integer> arrayList, AbstractScale.LabelSide labelSide, int n, int n2) {
        this.updateMinorTickParas();
        graphics.setLineStyle(1);
        if (this.scale.isLogScaleEnabled()) {
            ArrayList<Boolean> arrayList2 = this.scale.getScaleTickLabels().getTickVisibilities();
            int n3 = 0;
            while (n3 < arrayList.size()) {
                int n4 = arrayList.get(n3);
                int n5 = 0;
                int n6 = 0;
                n6 = arrayList2.get(n3) != false ? 6 : 3;
                if (labelSide == AbstractScale.LabelSide.Secondary) {
                    n5 = n2 - 1 - 1 - n6;
                }
                if (arrayList2.get(n3).booleanValue() || this.scale.isMinorTicksVisible()) {
                    graphics.drawLine(n4, n5, n4, n5 + n6);
                }
                ++n3;
            }
        } else {
            int n7 = 0;
            while (n7 < arrayList.size()) {
                int n8 = arrayList.get(n7);
                int n9 = 0;
                if (labelSide == AbstractScale.LabelSide.Secondary) {
                    n9 = n2 - 1 - 1 - 6;
                }
                graphics.drawLine(n8, n9, n8, n9 + 6);
                if (this.scale.isMinorTicksVisible() && n7 > 0) {
                    if (n7 == 1 && arrayList.get(1) - arrayList.get(0) < this.scale.getScaleTickLabels().getGridStepInPixel()) {
                        n8 = arrayList.get(1);
                        while (n8 - arrayList.get(0) > this.minorGridStepInPixel + 3) {
                            this.drawXMinorTicks(graphics, labelSide, n8 -= this.minorGridStepInPixel, n9);
                        }
                    } else if (n7 == arrayList.size() - 1 && arrayList.get(n7) - arrayList.get(n7 - 1) < this.scale.getScaleTickLabels().getGridStepInPixel()) {
                        n8 = arrayList.get(n7 - 1);
                        while (arrayList.get(n7) - n8 > this.minorGridStepInPixel + 3) {
                            this.drawXMinorTicks(graphics, labelSide, n8 += this.minorGridStepInPixel, n9);
                        }
                    } else {
                        int n10 = 0;
                        while (n10 < this.minorTicksNumber) {
                            n8 = arrayList.get(n7 - 1) + (arrayList.get(n7) - arrayList.get(n7 - 1)) * n10 / this.minorTicksNumber;
                            this.drawXMinorTicks(graphics, labelSide, n8, n9);
                            ++n10;
                        }
                    }
                }
                ++n7;
            }
        }
        if (this.scale.isScaleLineVisible()) {
            if (labelSide == AbstractScale.LabelSide.Primary) {
                graphics.drawLine(this.scale.getMargin(), 0, n - this.scale.getMargin(), 0);
            } else {
                graphics.drawLine(this.scale.getMargin(), n2 - 1, n - this.scale.getMargin(), n2 - 1);
            }
        }
    }

    private void drawXMinorTicks(Graphics graphics, AbstractScale.LabelSide labelSide, int n, int n2) {
        if (labelSide == AbstractScale.LabelSide.Primary) {
            graphics.drawLine(n, n2, n, n2 + 3);
        } else {
            graphics.drawLine(n, n2 + 6 - 3, n, n2 + 6);
        }
    }

    private void drawYTickMarks(Graphics graphics, ArrayList<Integer> arrayList, AbstractScale.LabelSide labelSide, int n, int n2) {
        this.updateMinorTickParas();
        graphics.setLineStyle(1);
        int n3 = 0;
        int n4 = 0;
        if (this.scale.isLogScaleEnabled()) {
            ArrayList<Boolean> arrayList2 = this.scale.getScaleTickLabels().getTickVisibilities();
            int n5 = 0;
            while (n5 < arrayList.size()) {
                int n6 = 0;
                n6 = arrayList2.get(n5) != false ? 6 : 3;
                n3 = labelSide == AbstractScale.LabelSide.Primary ? n - 1 - 1 - n6 : 1;
                n4 = n2 - arrayList.get(n5);
                if (arrayList2.get(n5).booleanValue() || this.scale.isMinorTicksVisible()) {
                    graphics.drawLine(n3, n4, n3 + n6, n4);
                }
                ++n5;
            }
        } else {
            int n7 = 0;
            while (n7 < arrayList.size()) {
                n3 = labelSide == AbstractScale.LabelSide.Primary ? n - 1 - 1 - 6 : 1;
                n4 = n2 - arrayList.get(n7);
                graphics.drawLine(n3, n4, n3 + 6, n4);
                if (this.scale.isMinorTicksVisible() && n7 > 0) {
                    if (n7 == 1 && arrayList.get(1) - arrayList.get(0) < this.scale.getScaleTickLabels().getGridStepInPixel()) {
                        n4 = arrayList.get(1);
                        while (n4 - arrayList.get(0) > this.minorGridStepInPixel + 3) {
                            this.drawYMinorTicks(graphics, labelSide, n3, n2 - (n4 -= this.minorGridStepInPixel));
                        }
                    } else if (n7 == arrayList.size() - 1 && arrayList.get(n7) - arrayList.get(n7 - 1) < this.scale.getScaleTickLabels().getGridStepInPixel()) {
                        n4 = arrayList.get(n7 - 1);
                        while (arrayList.get(n7) - n4 > this.minorGridStepInPixel + 3) {
                            this.drawYMinorTicks(graphics, labelSide, n3, n2 - (n4 += this.minorGridStepInPixel));
                        }
                    } else {
                        int n8 = 0;
                        while (n8 < this.minorTicksNumber) {
                            n4 = n2 - arrayList.get(n7 - 1) - (arrayList.get(n7) - arrayList.get(n7 - 1)) * n8 / this.minorTicksNumber;
                            this.drawYMinorTicks(graphics, labelSide, n3, n4);
                            ++n8;
                        }
                    }
                }
                ++n7;
            }
        }
        if (this.scale.isScaleLineVisible()) {
            if (labelSide == AbstractScale.LabelSide.Primary) {
                graphics.drawLine(n - 1, this.scale.getMargin(), n - 1, n2 - this.scale.getMargin());
            } else {
                graphics.drawLine(0, this.scale.getMargin(), 0, n2 - this.scale.getMargin());
            }
        }
    }

    private void drawYMinorTicks(Graphics graphics, AbstractScale.LabelSide labelSide, int n, int n2) {
        int n3 = 2;
        if (labelSide == AbstractScale.LabelSide.Primary) {
            graphics.drawLine(n + 6 - n3, n2, n + 6, n2);
        } else {
            graphics.drawLine(n, n2, n + n3, n2);
        }
    }
}

