/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.linearscale;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.csstudio.swt.xygraph.linearscale.LinearScale;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Font;

public class LinearScaleTickLabels
extends Figure {
    private ArrayList<Double> tickLabelValues;
    private ArrayList<String> tickLabels;
    private ArrayList<Integer> tickLabelPositions;
    private ArrayList<Boolean> tickVisibilities;
    private int tickLabelMaxLength;
    private int tickLabelMaxHeight;
    private int gridStepInPixel;
    private LinearScale scale;

    protected LinearScaleTickLabels(LinearScale linearScale) {
        this.scale = linearScale;
        this.tickLabelValues = new ArrayList();
        this.tickLabels = new ArrayList();
        this.tickLabelPositions = new ArrayList();
        this.tickVisibilities = new ArrayList();
        this.setFont(this.scale.getFont());
        this.setForegroundColor(this.scale.getForegroundColor());
    }

    protected void update(int n) {
        this.tickLabelValues.clear();
        this.tickLabels.clear();
        this.tickLabelPositions.clear();
        if (this.scale.isLogScaleEnabled()) {
            this.updateTickLabelForLogScale(n);
        } else {
            this.updateTickLabelForLinearScale(n);
        }
        this.updateTickVisibility();
        this.updateTickLabelMaxLengthAndHeight();
    }

    private void updateTickLabelForLogScale(int n) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        double d = this.scale.getRange().getLower();
        double d2 = this.scale.getRange().getUpper();
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("the range for log scale must be in positive range");
        }
        boolean bl = d2 < d;
        int n2 = (int)Math.ceil(Math.log10(d));
        int n3 = (int)Math.ceil(Math.log10(d2));
        BigDecimal bigDecimal3 = (bigDecimal2 = new BigDecimal(new Double(d).toString())).remainder(bigDecimal = this.pow(10.0, n2 - 1)).doubleValue() <= 0.0 ? bigDecimal2.subtract(bigDecimal2.remainder(bigDecimal)) : (bl ? bigDecimal2.subtract(bigDecimal2.remainder(bigDecimal)) : bigDecimal2.subtract(bigDecimal2.remainder(bigDecimal)).add(bigDecimal));
        if (bigDecimal2.compareTo(bigDecimal3) == (bl ? 1 : -1)) {
            this.tickLabelValues.add(d);
            if (this.scale.isDateEnabled()) {
                Date date = new Date((long)bigDecimal2.doubleValue());
                this.tickLabels.add(this.scale.format(date));
            } else {
                this.tickLabels.add(this.scale.format(bigDecimal2.doubleValue()));
            }
            this.tickLabelPositions.add(this.scale.getMargin());
        }
        int n4 = n2;
        while (!(bl ? n4 < n3 : n4 > n3)) {
            int n5;
            BigDecimal bigDecimal4;
            if (Math.abs(n3 - n2) > 20) {
                bigDecimal4 = this.pow(10.0, n4);
                if (bigDecimal4.doubleValue() > d2) break;
                if (this.scale.isDateEnabled()) {
                    Date date = new Date((long)bigDecimal4.doubleValue());
                    this.tickLabels.add(this.scale.format(date));
                } else {
                    this.tickLabels.add(this.scale.format(bigDecimal4.doubleValue()));
                }
                this.tickLabelValues.add(bigDecimal4.doubleValue());
                n5 = (int)((Math.log10(bigDecimal4.doubleValue()) - Math.log10(d)) / (Math.log10(d2) - Math.log10(d)) * (double)n) + this.scale.getMargin();
                this.tickLabelPositions.add(n5);
            } else {
                bigDecimal4 = bigDecimal3;
                while (!(bl ? !(bigDecimal4.doubleValue() >= this.pow(10.0, n4 - 1).doubleValue()) : !(bigDecimal4.doubleValue() <= this.pow(10.0, n4).doubleValue()))) {
                    if (!bl ? bigDecimal4.doubleValue() > d2 : bigDecimal4.doubleValue() < d2) break;
                    if (this.scale.isDateEnabled()) {
                        Date date = new Date((long)bigDecimal4.doubleValue());
                        this.tickLabels.add(this.scale.format(date));
                    } else {
                        this.tickLabels.add(this.scale.format(bigDecimal4.doubleValue()));
                    }
                    this.tickLabelValues.add(bigDecimal4.doubleValue());
                    n5 = (int)((Math.log10(bigDecimal4.doubleValue()) - Math.log10(d)) / (Math.log10(d2) - Math.log10(d)) * (double)n) + this.scale.getMargin();
                    this.tickLabelPositions.add(n5);
                    BigDecimal bigDecimal5 = bigDecimal4 = bl ? bigDecimal4.subtract(bigDecimal) : bigDecimal4.add(bigDecimal);
                }
                bigDecimal = bl ? bigDecimal.divide(this.pow(10.0, 1)) : bigDecimal.multiply(this.pow(10.0, 1));
                bigDecimal3 = bl ? this.pow(10.0, n4 - 1) : bigDecimal.add(this.pow(10.0, n4));
            }
            n4 += bl ? -1 : 1;
        }
        if (bl ? d2 < this.tickLabelValues.get(this.tickLabelValues.size() - 1) : d2 > this.tickLabelValues.get(this.tickLabelValues.size() - 1)) {
            this.tickLabelValues.add(d2);
            if (this.scale.isDateEnabled()) {
                Date date = new Date((long)d2);
                this.tickLabels.add(this.scale.format(date));
            } else {
                this.tickLabels.add(this.scale.format(d2));
            }
            this.tickLabelPositions.add(this.scale.getMargin() + n);
        }
    }

    private void updateTickLabelForLinearScale(int n) {
        double d = this.scale.getRange().getLower();
        double d2 = this.scale.getRange().getUpper();
        BigDecimal bigDecimal = this.getGridStep(n, d, d2);
        this.gridStepInPixel = (int)((double)n * bigDecimal.doubleValue() / (d2 - d));
        this.updateTickLabelForLinearScale(n, bigDecimal);
    }

    private void updateTickLabelForLinearScale(int n, BigDecimal bigDecimal) {
        Comparable<BigDecimal> comparable;
        int n2;
        BigDecimal bigDecimal2;
        double d = this.scale.getRange().getLower();
        double d2 = this.scale.getRange().getUpper();
        boolean bl = d2 < d;
        BigDecimal bigDecimal3 = new BigDecimal(new Double(d).toString());
        BigDecimal bigDecimal4 = bigDecimal3.remainder(bigDecimal).doubleValue() <= 0.0 ? bigDecimal3.subtract(bigDecimal3.remainder(bigDecimal)) : bigDecimal3.subtract(bigDecimal3.remainder(bigDecimal)).add(bigDecimal);
        if (this.scale.isDateEnabled() && bigDecimal3.compareTo(bigDecimal2 = bigDecimal4.subtract(new BigDecimal(new Double(3600000.0).toString()))) == -1) {
            bigDecimal4 = bigDecimal2;
        }
        int n3 = n2 = bl ? 1 : -1;
        if (bigDecimal3.compareTo(bigDecimal4) == n2) {
            this.tickLabelValues.add(d);
            if (this.scale.isDateEnabled()) {
                comparable = new Date((long)bigDecimal3.doubleValue());
                this.tickLabels.add(this.scale.format(comparable));
            } else {
                this.tickLabels.add(this.scale.format(bigDecimal3.doubleValue()));
            }
            this.tickLabelPositions.add(this.scale.getMargin());
        }
        comparable = bigDecimal4;
        while (!(d2 >= d ? !(((BigDecimal)comparable).doubleValue() <= d2) : !(((BigDecimal)comparable).doubleValue() >= d2))) {
            if (this.scale.isDateEnabled()) {
                Date date = new Date((long)((BigDecimal)comparable).doubleValue());
                this.tickLabels.add(this.scale.format(date));
            } else {
                this.tickLabels.add(this.scale.format(((BigDecimal)comparable).doubleValue()));
            }
            this.tickLabelValues.add(((BigDecimal)comparable).doubleValue());
            int n4 = (int)((((BigDecimal)comparable).doubleValue() - d) / (d2 - d) * (double)n) + this.scale.getMargin();
            this.tickLabelPositions.add(n4);
            comparable = ((BigDecimal)comparable).add(bigDecimal);
        }
        if (bl ? d2 < this.tickLabelValues.get(this.tickLabelValues.size() - 1) : d2 > this.tickLabelValues.get(this.tickLabelValues.size() - 1)) {
            this.tickLabelValues.add(d2);
            if (this.scale.isDateEnabled()) {
                comparable = new Date((long)d2);
                this.tickLabels.add(this.scale.format(comparable));
            } else {
                this.tickLabels.add(this.scale.format(d2));
            }
            this.tickLabelPositions.add(this.scale.getMargin() + n);
        }
    }

    private void updateTickVisibility() {
        this.tickVisibilities.clear();
        int n = 0;
        while (n < this.tickLabelPositions.size()) {
            this.tickVisibilities.add(Boolean.TRUE);
            ++n;
        }
        if (this.tickLabelPositions.size() == 0) {
            return;
        }
        n = 0;
        String string = null;
        int n2 = 0;
        while (n2 < this.tickLabelPositions.size()) {
            String string2;
            boolean bl = true;
            if (n2 != 0) {
                bl = this.hasSpaceToDraw(n, this.tickLabelPositions.get(n2), string, this.tickLabels.get(n2));
            }
            boolean bl2 = (string2 = this.tickLabels.get(n2)).equals(string) && n2 != 0 && n2 != this.tickLabelPositions.size() - 1;
            boolean bl3 = true;
            if (this.scale.isLogScaleEnabled()) {
                boolean bl4 = bl3 = this.isMajorTick(this.tickLabelValues.get(n2)) || n2 == 0 || n2 == this.tickLabelPositions.size() - 1;
            }
            if (!bl || bl2 || !bl3) {
                this.tickVisibilities.set(n2, Boolean.FALSE);
            } else {
                n = this.tickLabelPositions.get(n2);
                string = string2;
            }
            ++n2;
        }
    }

    private boolean isMajorTick(double d) {
        if (!this.scale.isLogScaleEnabled()) {
            return true;
        }
        return Math.log10(d) % 1.0 == 0.0;
    }

    private boolean hasSpaceToDraw(int n, int n2, String string, String string2) {
        Dimension dimension = FigureUtilities.getTextExtents((String)string2, (Font)this.scale.getFont());
        Dimension dimension2 = FigureUtilities.getTextExtents((String)string, (Font)this.scale.getFont());
        int n3 = n2 - n;
        int n4 = (int)(this.scale.isHorizontal() ? (double)dimension.width / 2.0 + (double)dimension2.width / 2.0 : (double)dimension.height);
        boolean bl = n3 > n4;
        boolean bl2 = true;
        if (n2 != this.tickLabelPositions.get(this.tickLabelPositions.size() - 1)) {
            Dimension dimension3 = FigureUtilities.getTextExtents((String)this.tickLabels.get(this.tickLabels.size() - 1), (Font)this.scale.getFont());
            n3 = this.tickLabelPositions.get(this.tickLabelPositions.size() - 1) - n2;
            n4 = (int)(this.scale.isHorizontal() ? (double)dimension.width / 2.0 + (double)dimension3.width / 2.0 : (double)dimension.height);
            boolean bl3 = bl2 = n3 > n4;
        }
        return bl && bl2;
    }

    private void updateTickLabelMaxLengthAndHeight() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.tickLabels.size()) {
            if (this.tickVisibilities.size() > n3 && this.tickVisibilities.get(n3).booleanValue()) {
                Dimension dimension = FigureUtilities.getTextExtents((String)this.tickLabels.get(n3), (Font)this.scale.getFont());
                if (this.tickLabels.get(0).startsWith("-") && !this.tickLabels.get(n3).startsWith("-")) {
                    dimension.width += FigureUtilities.getTextExtents((String)"-", (Font)this.getFont()).width;
                }
                if (dimension.width > n) {
                    n = dimension.width;
                }
                if (dimension.height > n2) {
                    n2 = dimension.height;
                }
            }
            ++n3;
        }
        this.tickLabelMaxLength = n;
        this.tickLabelMaxHeight = n2;
    }

    private BigDecimal pow(double d, int n) {
        BigDecimal bigDecimal = n > 0 ? new BigDecimal(new Double(d).toString()).pow(n) : BigDecimal.ONE.divide(new BigDecimal(new Double(d).toString()).pow(-n));
        return bigDecimal;
    }

    /*
     * Unable to fully structure code
     */
    private BigDecimal getGridStep(int var1_1, double var2_2, double var4_3) {
        block24: {
            if ((int)this.scale.getMajorGridStep() != 0) {
                return new BigDecimal(this.scale.getMajorGridStep());
            }
            if (var1_1 <= 0) {
                var1_1 = 1;
            }
            var6_4 = false;
            if (var2_2 >= var4_3) {
                if (var4_3 == var2_2) {
                    var4_3 += 1.0;
                } else {
                    var6_4 = true;
                    var7_5 = var2_2;
                    var2_2 = var4_3;
                    var4_3 = var7_5;
                }
            }
            var7_5 = Math.abs(var4_3 - var2_2);
            var9_6 = this.scale.getMajorTickMarkStepHint();
            if (var9_6 > (double)var1_1) {
                var9_6 = var1_1;
            }
            var11_7 = var7_5 / (double)var1_1 * var9_6;
            if (this.scale.isDateEnabled()) {
                var13_8 = var4_3 - var2_2 < 10000.0 ? 1000L : (var4_3 - var2_2 < 60000.0 ? 10000L : (var4_3 - var2_2 < 4.32E7 ? 60000L : (var4_3 - var2_2 < 6.048E8 ? 3600000L : 86400000L)));
                if (this.scale.getTimeUnit() == 13) {
                    var13_8 = 1000L;
                } else if (this.scale.getTimeUnit() == 12) {
                    var13_8 = 60000L;
                } else if (this.scale.getTimeUnit() == 11) {
                    var13_8 = 3600000L;
                } else if (this.scale.getTimeUnit() == 5) {
                    var13_8 = 86400000L;
                } else if (this.scale.getTimeUnit() == 2) {
                    var13_8 = 2592000000L;
                } else if (this.scale.getTimeUnit() == 1) {
                    var13_8 = 31536000000L;
                }
                var15_10 = var11_7 + ((double)var13_8 - var11_7 % (double)var13_8);
                return new BigDecimal(var15_10);
            }
            var13_9 = var11_7;
            var15_11 = 0;
            if (!(var13_9 < 1.0)) ** GOTO lbl51
            if (var13_9 == 0.0) break block24;
            while (var13_9 < 1.0) {
                var13_9 *= 10.0;
                --var15_11;
            }
            break block24;
lbl-1000:
            // 1 sources

            {
                var13_9 /= 10.0;
                ++var15_11;
lbl51:
                // 2 sources

                ** while (var13_9 >= 10.0)
            }
        }
        var16_12 = var13_9 > 7.5 ? BigDecimal.TEN.multiply(this.pow(10.0, var15_11)) : (var13_9 > 3.5 ? new BigDecimal(new Double(5.0).toString()).multiply(this.pow(10.0, var15_11)) : (var13_9 > 1.5 ? new BigDecimal(new Double(2.0).toString()).multiply(this.pow(10.0, var15_11)) : this.pow(10.0, var15_11)));
        if (var6_4) {
            var16_12 = var16_12.negate();
        }
        return var16_12;
    }

    public ArrayList<Integer> getTickLabelPositions() {
        return this.tickLabelPositions;
    }

    protected void paintClientArea(Graphics graphics) {
        graphics.translate(this.bounds.x, this.bounds.y);
        if (this.scale.isHorizontal()) {
            this.drawXTick(graphics);
        } else {
            this.drawYTick(graphics);
        }
        super.paintClientArea(graphics);
    }

    private void drawXTick(Graphics graphics) {
        graphics.setFont(this.scale.getFont());
        int n = 0;
        while (n < this.tickLabelPositions.size()) {
            if (this.tickVisibilities.get(n).booleanValue()) {
                String string = this.tickLabels.get(n);
                int n2 = FigureUtilities.getTextExtents((String)string, (Font)this.getFont()).width;
                int n3 = (int)Math.ceil((double)this.tickLabelPositions.get(n).intValue() - (double)n2 / 2.0);
                graphics.drawText(string, n3, 0);
            }
            ++n;
        }
    }

    private void drawYTick(Graphics graphics) {
        graphics.setFont(this.scale.getFont());
        int n = this.tickLabelMaxHeight;
        int n2 = 0;
        while (n2 < this.tickLabelPositions.size()) {
            if (this.tickVisibilities.size() == 0 || this.tickLabels.size() == 0) break;
            if (this.tickVisibilities.get(n2).booleanValue()) {
                String string = this.tickLabels.get(n2);
                int n3 = 0;
                if (this.tickLabels.get(0).startsWith("-") && !string.startsWith("-")) {
                    n3 += FigureUtilities.getTextExtents((String)"-", (Font)this.getFont()).width;
                }
                int n4 = (int)Math.ceil((double)(this.scale.getLength() - this.tickLabelPositions.get(n2)) - (double)n / 2.0);
                graphics.drawText(string, n3, n4);
            }
            ++n2;
        }
    }

    public int getTickLabelMaxLength() {
        return this.tickLabelMaxLength;
    }

    public int getTickLabelMaxHeight() {
        return this.tickLabelMaxHeight;
    }

    public ArrayList<Boolean> getTickVisibilities() {
        return this.tickVisibilities;
    }

    public int getGridStepInPixel() {
        return this.gridStepInPixel;
    }
}

