/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.linearscale;

import org.csstudio.swt.xygraph.linearscale.AbstractScale;
import org.csstudio.swt.xygraph.linearscale.LinearScaleTickLabels;
import org.csstudio.swt.xygraph.linearscale.LinearScaleTickMarks;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class LinearScale
extends AbstractScale {
    private static final int SPACE_BTW_MARK_LABEL = 2;
    private Orientation orientation = Orientation.HORIZONTAL;
    private LinearScaleTickLabels tickLabels = new LinearScaleTickLabels(this);
    private LinearScaleTickMarks tickMarks = new LinearScaleTickMarks(this);
    private int length;
    private int margin;

    public LinearScale() {
        this.add((IFigure)this.tickMarks);
        this.add((IFigure)this.tickLabels);
    }

    private void calcMargin() {
        this.margin = this.isHorizontal() ? (int)Math.ceil((double)Math.max(FigureUtilities.getTextExtents((String)this.format((Object)Double.valueOf((double)this.getRange().getLower())), (Font)this.getFont()).width, FigureUtilities.getTextExtents((String)this.format((Object)Double.valueOf((double)this.getRange().getUpper())), (Font)this.getFont()).width) / 2.0) : (int)Math.ceil((double)Math.max(FigureUtilities.getTextExtents((String)this.format((Object)Double.valueOf((double)this.getRange().getLower())), (Font)this.getFont()).height, FigureUtilities.getTextExtents((String)this.format((Object)Double.valueOf((double)this.getRange().getUpper())), (Font)this.getFont()).height) / 2.0);
    }

    public int getLength() {
        return this.length;
    }

    public int getMargin() {
        if (this.isDirty()) {
            this.calcMargin();
        }
        return this.margin;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public Dimension getPreferredSize(int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        LinearScaleTickLabels linearScaleTickLabels = new LinearScaleTickLabels(this);
        if (this.isHorizontal()) {
            linearScaleTickLabels.update(n - 2 * this.getMargin());
            dimension.height = linearScaleTickLabels.getTickLabelMaxHeight() + 2 + 6;
        } else {
            linearScaleTickLabels.update(n2 - 2 * this.getMargin());
            dimension.width = linearScaleTickLabels.getTickLabelMaxLength() + 2 + 6;
        }
        return dimension;
    }

    public LinearScaleTickLabels getScaleTickLabels() {
        return this.tickLabels;
    }

    public LinearScaleTickMarks getScaleTickMarks() {
        return this.tickMarks;
    }

    public int getTickLength() {
        return this.length - 2 * this.getMargin();
    }

    public int getValuePosition(double d, boolean bl) {
        if (this.dirty) {
            this.updateTick();
        }
        int n = 0;
        if (this.logScaleEnabled) {
            if (d <= 0.0) {
                d = this.min;
            }
            n = (int)((Math.log10(d) - Math.log10(this.min)) / (Math.log10(this.max) - Math.log10(this.min)) * (double)(this.length - 2 * this.margin)) + this.margin;
        } else {
            n = (int)((d - this.min) / (this.max - this.min) * (double)(this.length - 2 * this.margin)) + this.margin;
        }
        if (bl) {
            if (this.orientation == Orientation.HORIZONTAL) {
                return n;
            }
            return this.length - n;
        }
        if (this.orientation == Orientation.HORIZONTAL) {
            return n + this.bounds.x;
        }
        return this.length - n + this.bounds.y;
    }

    public double getPositionValue(int n, boolean bl) {
        this.updateTick();
        double d = this.getRange().getLower();
        double d2 = this.getRange().getUpper();
        int n2 = bl ? (this.isHorizontal() ? n : this.length - n) : (this.isHorizontal() ? n - this.bounds.x : this.length + this.bounds.y - n);
        double d3 = this.isLogScaleEnabled() ? Math.pow(10.0, (double)(n2 - this.margin) * (Math.log10(d2) - Math.log10(d)) / (double)(this.length - 2 * this.margin) + Math.log10(d)) : (double)(n2 - this.margin) * (d2 - d) / (double)(this.length - 2 * this.margin) + d;
        return d3;
    }

    public boolean isHorizontal() {
        return this.orientation == Orientation.HORIZONTAL;
    }

    protected void layout() {
        super.layout();
        this.updateTick();
        Rectangle rectangle = this.getClientArea();
        if (this.isHorizontal() && this.getTickLablesSide() == AbstractScale.LabelSide.Primary) {
            this.tickLabels.setBounds(new Rectangle(rectangle.x, rectangle.y + 6 + 2, rectangle.width, rectangle.height - 6));
            this.tickMarks.setBounds(rectangle);
        } else if (this.isHorizontal() && this.getTickLablesSide() == AbstractScale.LabelSide.Secondary) {
            this.tickLabels.setBounds(new Rectangle(rectangle.x, rectangle.y + rectangle.height - 6 - this.tickLabels.getTickLabelMaxHeight() - 2, rectangle.width, this.tickLabels.getTickLabelMaxHeight()));
            this.tickMarks.setBounds(new Rectangle(rectangle.x, rectangle.y + rectangle.height - 6, rectangle.width, 6));
        } else if (this.getTickLablesSide() == AbstractScale.LabelSide.Primary) {
            this.tickLabels.setBounds(new Rectangle(rectangle.x + rectangle.width - 6 - this.tickLabels.getTickLabelMaxLength() - 2, rectangle.y, this.tickLabels.getTickLabelMaxLength(), rectangle.height));
            this.tickMarks.setBounds(new Rectangle(rectangle.x + rectangle.width - 6, rectangle.y, 6, rectangle.height));
        } else {
            this.tickLabels.setBounds(new Rectangle(rectangle.x + 6 + 2, rectangle.y, this.tickLabels.getTickLabelMaxLength(), rectangle.height));
            this.tickMarks.setBounds(new Rectangle(rectangle.x, rectangle.y, 6, rectangle.height));
        }
    }

    public void setBounds(Rectangle rectangle) {
        if (!this.bounds.equals((Object)rectangle)) {
            this.setDirty(true);
            this.length = this.isHorizontal() ? rectangle.width - this.getInsets().getWidth() : rectangle.height - this.getInsets().getHeight();
        }
        super.setBounds(rectangle);
    }

    @Override
    public void setFont(Font font) {
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.tickLabels.setFont(font);
        super.setFont(font);
    }

    public void setForegroundColor(Color color) {
        this.tickMarks.setForegroundColor(color);
        this.tickLabels.setForegroundColor(color);
        super.setForegroundColor(color);
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.setDirty(true);
        this.revalidate();
    }

    @Override
    public void updateTick() {
        if (this.isDirty()) {
            int n = this.length = this.isHorizontal() ? this.getClientArea().width : this.getClientArea().height;
            if (this.length > 2 * this.getMargin()) {
                this.tickLabels.update(this.length - 2 * this.getMargin());
            }
            this.setDirty(false);
        }
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

