/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.linearscale;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.eclipse.draw2d.Figure;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;

public abstract class AbstractScale
extends Figure {
    public static final double DEFAULT_MAX = 100.0;
    public static final double DEFAULT_MIN = 0.0;
    public static final String DEFAULT_ENGINEERING_FORMAT = "0.####E0";
    private static final int ENGINEERING_LIMIT = 4;
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd\nHH:mm:ss";
    private LabelSide tickLableSide = LabelSide.Primary;
    public static final double DEFAULT_LOG_SCALE_MIN = 0.1;
    public static final double DEFAULT_LOG_SCALE_MAX = 100.0;
    private String default_decimal_format = "############.##";
    protected boolean logScaleEnabled = false;
    protected double min = 0.0;
    protected double max = 100.0;
    private String formatPattern;
    private int timeUnit = 0;
    protected boolean dirty = true;
    private boolean dateEnabled = false;
    private boolean scaleLineVisible = true;
    private int majorTickMarkStepHint = 30;
    private int minorTickMarkStepHint = 4;
    private boolean minorTicksVisible = true;
    private double majorGridStep = 0.0;
    private boolean autoFormat = true;
    private Range range = new Range(this.min, this.max);

    public String format(Object object) {
        if (this.isDateEnabled()) {
            if (this.autoFormat || this.formatPattern == null || this.formatPattern.equals("") || this.formatPattern.equals(this.default_decimal_format) || this.formatPattern.equals(DEFAULT_ENGINEERING_FORMAT)) {
                this.formatPattern = DEFAULT_DATE_FORMAT;
                double d = Math.abs(this.max - this.min);
                this.formatPattern = d <= 1000.0 || this.timeUnit == 14 ? "HH:mm:ss.SSS" : (d <= 3600000.0 || this.timeUnit == 13 ? "HH:mm:ss" : (d <= 8.64E7 || this.timeUnit == 12 ? "HH:mm" : (d <= 6.048E8 || this.timeUnit == 11 ? "dd HH:mm" : (d <= 2.592E9 || this.timeUnit == 5 ? "MMMMM d" : (d <= 3.1536E10 || this.timeUnit == 2 ? "yyyy MMMMM" : "yyyy")))));
                this.autoFormat = true;
            }
            return new SimpleDateFormat(this.formatPattern).format(object);
        }
        if (this.formatPattern == null || this.formatPattern.equals("")) {
            this.formatPattern = this.default_decimal_format;
            this.autoFormat = true;
        }
        return new DecimalFormat(this.formatPattern).format(object);
    }

    public int getMajorTickMarkStepHint() {
        return this.majorTickMarkStepHint;
    }

    public Range getRange() {
        return this.range;
    }

    public LabelSide getTickLablesSide() {
        return this.tickLableSide;
    }

    public int getTimeUnit() {
        return this.timeUnit;
    }

    public boolean isDateEnabled() {
        return this.dateEnabled;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isLogScaleEnabled() {
        return this.logScaleEnabled;
    }

    public boolean isMinorTicksVisible() {
        return this.minorTicksVisible;
    }

    public boolean isScaleLineVisible() {
        return this.scaleLineVisible;
    }

    public void setDateEnabled(boolean bl) {
        this.dateEnabled = bl;
        this.setDirty(true);
        this.revalidate();
    }

    protected void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public void setFormatPattern(String string) {
        try {
            new DecimalFormat(string);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        this.formatPattern = string;
        this.autoFormat = false;
        this.setDirty(true);
        this.revalidate();
        this.repaint();
    }

    public String getFormatPattern() {
        return this.formatPattern;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setDirty(true);
        this.revalidate();
    }

    public void setLogScale(boolean bl) throws IllegalStateException {
        if (this.logScaleEnabled == bl) {
            return;
        }
        if (bl) {
            if (this.min == 0.0 && this.max == 100.0) {
                this.min = 0.1;
                this.max = 100.0;
            }
            if (this.min <= 0.0) {
                this.min = 0.1;
            }
            if (this.max <= this.min) {
                this.max = this.min + 100.0;
            }
        } else if (this.min == 0.1 && this.max == 100.0) {
            this.min = 0.0;
            this.max = 100.0;
        }
        this.logScaleEnabled = bl;
        this.range = new Range(this.min, this.max);
        this.setDirty(true);
        this.revalidate();
        this.repaint();
    }

    public void setMajorTickMarkStepHint(int n) {
        this.majorTickMarkStepHint = n;
        this.setDirty(true);
        this.revalidate();
        this.repaint();
    }

    public void setMinorTicksVisible(boolean bl) {
        this.minorTicksVisible = bl;
    }

    public void setRange(Range range) {
        if (range == null) {
            SWT.error((int)4);
            return;
        }
        this.setRange(range.getLower(), range.getUpper());
    }

    public void setRange(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isInfinite(d) || Double.isInfinite(d2) || Double.isInfinite(d2 - d)) {
            throw new IllegalArgumentException("Illegal range: lower=" + d + ", upper=" + d2);
        }
        if (d == d2 && Double.isInfinite(d2 = d + 1.0)) {
            throw new IllegalArgumentException("Illegal range: lower=" + d + ", upper=" + d2);
        }
        if (this.logScaleEnabled && d <= 0.0) {
            d = 0.1;
        }
        this.min = d;
        this.max = d2;
        if (this.formatPattern == null || this.formatPattern == this.default_decimal_format) {
            if (Math.abs(this.max - this.min) > 0.1) {
                this.default_decimal_format = "############.##";
            } else {
                this.default_decimal_format = "##.##";
                double d3 = Math.abs(this.max - this.min);
                while (d3 < 1.0) {
                    d3 *= 10.0;
                    this.default_decimal_format = String.valueOf(this.default_decimal_format) + "#";
                }
            }
            this.formatPattern = this.default_decimal_format;
            this.autoFormat = true;
        }
        if (this.formatPattern.equals(this.default_decimal_format) || this.formatPattern.equals(DEFAULT_ENGINEERING_FORMAT)) {
            this.formatPattern = this.max != 0.0 && Math.abs(Math.log10(Math.abs(this.max))) >= 4.0 || this.min != 0.0 && Math.abs(Math.log10(Math.abs(this.min))) >= 4.0 ? DEFAULT_ENGINEERING_FORMAT : this.default_decimal_format;
            this.autoFormat = true;
        }
        this.range = new Range(this.min, this.max);
        this.setDirty(true);
        this.revalidate();
        this.repaint();
    }

    public void setScaleLineVisible(boolean bl) {
        this.scaleLineVisible = bl;
    }

    public void setTickLableSide(LabelSide labelSide) {
        this.tickLableSide = labelSide;
        this.revalidate();
    }

    public void setTimeUnit(int n) {
        this.timeUnit = n;
        this.setDirty(true);
    }

    public abstract void updateTick();

    public void setMajorGridStep(double d) {
        this.majorGridStep = d;
        this.setDirty(true);
    }

    public double getMajorGridStep() {
        return this.majorGridStep;
    }

    public void setMinorTickMarkStepHint(int n) {
        this.minorTickMarkStepHint = n;
    }

    public int getMinorTickMarkStepHint() {
        return this.minorTickMarkStepHint;
    }

    public void setAutoFormat(boolean bl) {
        this.autoFormat = bl;
        if (bl) {
            this.formatPattern = null;
            this.setRange(this.getRange());
            this.format(0);
        }
    }

    public boolean isAutoFormat() {
        return this.autoFormat;
    }

    public static enum LabelSide {
        Primary,
        Secondary;

    }
}

