/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.figures;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.csstudio.swt.xygraph.figures.Annotation;
import org.csstudio.swt.xygraph.figures.Axis;
import org.csstudio.swt.xygraph.figures.Grid;
import org.csstudio.swt.xygraph.figures.Legend;
import org.csstudio.swt.xygraph.figures.PlotArea;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.linearscale.AbstractScale;
import org.csstudio.swt.xygraph.linearscale.LinearScale;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.csstudio.swt.xygraph.undo.OperationsManager;
import org.csstudio.swt.xygraph.undo.ZoomCommand;
import org.csstudio.swt.xygraph.undo.ZoomType;
import org.csstudio.swt.xygraph.util.Log10;
import org.csstudio.swt.xygraph.util.SingleSourceHelper;
import org.csstudio.swt.xygraph.util.XYGraphMediaFactory;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class XYGraph
extends Figure {
    private static final int GAP = 2;
    public static final RGB[] DEFAULT_TRACES_COLOR = new RGB[]{new RGB(21, 21, 196), new RGB(242, 26, 26), new RGB(33, 179, 33), new RGB(0, 0, 0), new RGB(128, 0, 255), new RGB(255, 170, 0), new RGB(255, 0, 240), new RGB(243, 132, 132), new RGB(0, 255, 11), new RGB(0, 214, 255), new RGB(114, 40, 3), new RGB(219, 128, 4)};
    private int traceNum = 0;
    private boolean transparent = false;
    protected boolean showLegend = true;
    private Map<Axis, Legend> legendMap;
    private String title = "";
    private Color titleColor;
    private Label titleLabel;
    private List<Axis> xAxisList;
    private List<Axis> yAxisList;
    private PlotArea plotArea;
    public Axis primaryXAxis;
    public Axis primaryYAxis;
    private OperationsManager operationsManager;
    private ZoomType zoomType;

    public XYGraph() {
        this.setOpaque(!this.transparent);
        this.legendMap = new LinkedHashMap<Axis, Legend>();
        this.titleLabel = new Label();
        String string = Display.getCurrent().getSystemFont().getFontData()[0].getName();
        this.setTitleFont(XYGraphMediaFactory.getInstance().getFont(new FontData(string, 12, 1)));
        this.xAxisList = new ArrayList<Axis>();
        this.yAxisList = new ArrayList<Axis>();
        this.plotArea = this.createPlotArea(this);
        this.getPlotArea().setOpaque(!this.transparent);
        this.add((IFigure)this.titleLabel);
        this.add((IFigure)this.plotArea);
        this.primaryYAxis = new Axis("Y-Axis", true);
        this.primaryYAxis.setOrientation(LinearScale.Orientation.VERTICAL);
        this.primaryYAxis.setTickLableSide(AbstractScale.LabelSide.Primary);
        this.primaryYAxis.setAutoScaleThreshold(0.1);
        this.addAxis(this.primaryYAxis);
        this.primaryXAxis = new Axis("X-Axis", false);
        this.primaryXAxis.setOrientation(LinearScale.Orientation.HORIZONTAL);
        this.primaryXAxis.setTickLableSide(AbstractScale.LabelSide.Primary);
        this.addAxis(this.primaryXAxis);
        this.operationsManager = new OperationsManager();
    }

    protected PlotArea createPlotArea(XYGraph xYGraph) {
        return new PlotArea(xYGraph);
    }

    public boolean isOpaque() {
        return false;
    }

    protected void layout() {
        Dimension dimension;
        Dimension dimension2;
        Object object;
        Dimension dimension3;
        Rectangle rectangle = this.getClientArea().getCopy();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.titleLabel != null && this.titleLabel.isVisible() && this.titleLabel.getText().length() > 0) {
            dimension3 = this.titleLabel.getPreferredSize();
            this.titleLabel.setBounds(new Rectangle(rectangle.x + rectangle.width / 2 - dimension3.width / 2, rectangle.y, dimension3.width, dimension3.height));
            rectangle.y += dimension3.height + 2;
            rectangle.height -= dimension3.height + 2;
        }
        if (this.showLegend) {
            dimension3 = new ArrayList();
            object = new ArrayList();
            dimension2 = new ArrayList();
            dimension = new ArrayList();
            Object[] objectArray = this.legendMap.keySet().toArray();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < objectArray.length) {
                Legend legend = this.legendMap.get(objectArray[n3]);
                if (legend != null && legend.isVisible()) {
                    dimension.add(legend);
                    Dimension dimension4 = legend.getPreferredSize(rectangle.width, rectangle.height);
                    object.add(dimension4);
                    if (n + dimension4.width + 2 > rectangle.width) {
                        if (n2 == 0) break;
                        dimension3.add(rectangle.x + (rectangle.width - n) / 2);
                        dimension2.add(n2);
                        n2 = 1;
                        n = dimension4.width + 2;
                        rectangle.height -= dimension4.height + 2;
                        if (n3 == objectArray.length - 1) {
                            n = dimension4.width + 2;
                            n2 = 1;
                            dimension3.add(rectangle.x + (rectangle.width - n) / 2);
                            dimension2.add(n2);
                            rectangle.height -= dimension4.height + 2;
                        }
                    } else {
                        n += dimension4.width + 2;
                        ++n2;
                        if (n3 == objectArray.length - 1) {
                            dimension3.add(rectangle.x + (rectangle.width - n) / 2);
                            dimension2.add(n2);
                            rectangle.height -= dimension4.height + 2;
                        }
                    }
                }
                ++n3;
            }
            n3 = 0;
            int n4 = rectangle.y + rectangle.height + 2;
            int n5 = 0;
            while (n5 < dimension2.size()) {
                n = (Integer)dimension3.get(n5);
                int n6 = 0;
                while (n6 < (Integer)dimension2.get(n5)) {
                    ((Legend)((Object)dimension.get(n3))).setBounds(new Rectangle(n, n4, ((Dimension)object.get((int)n3)).width, ((Dimension)object.get((int)n3)).height));
                    n += ((Dimension)object.get((int)n3)).width + 2;
                    ++n3;
                    ++n6;
                }
                n4 += ((Dimension)object.get((int)(n3 - 1))).height + 2;
                ++n5;
            }
        }
        int n = this.xAxisList.size() - 1;
        while (n >= 0) {
            object = this.xAxisList.get(n);
            dimension2 = ((Axis)((Object)object)).getPreferredSize(rectangle.width, rectangle.height);
            if (((AbstractScale)((Object)object)).getTickLablesSide() == AbstractScale.LabelSide.Primary) {
                if (object.isVisible()) {
                    bl4 = true;
                }
                ((LinearScale)((Object)object)).setBounds(new Rectangle(rectangle.x, rectangle.y + rectangle.height - dimension2.height, dimension2.width, dimension2.height));
                rectangle.height -= dimension2.height;
            } else {
                if (object.isVisible()) {
                    bl2 = true;
                }
                ((LinearScale)((Object)object)).setBounds(new Rectangle(rectangle.x, rectangle.y + 1, dimension2.width, dimension2.height));
                rectangle.y += dimension2.height;
                rectangle.height -= dimension2.height;
            }
            --n;
        }
        n = this.yAxisList.size() - 1;
        while (n >= 0) {
            int n7 = rectangle.height + (bl2 ? 1 : 0) * ((LinearScale)((Object)(object = this.yAxisList.get(n)))).getMargin() + (bl4 ? 1 : 0) * ((LinearScale)((Object)object)).getMargin();
            if (n7 > this.getClientArea().height) {
                n7 = rectangle.height;
            }
            dimension = ((Axis)((Object)object)).getPreferredSize(rectangle.width, n7);
            if (((AbstractScale)((Object)object)).getTickLablesSide() == AbstractScale.LabelSide.Primary) {
                if (object.isVisible()) {
                    bl3 = true;
                }
                ((LinearScale)((Object)object)).setBounds(new Rectangle(rectangle.x, rectangle.y - (bl2 ? ((LinearScale)((Object)object)).getMargin() : 0), dimension.width, dimension.height));
                rectangle.x += dimension.width;
                rectangle.width -= dimension.width;
            } else {
                if (object.isVisible()) {
                    bl = true;
                }
                ((LinearScale)((Object)object)).setBounds(new Rectangle(rectangle.x + rectangle.width - dimension.width - 1, rectangle.y - (bl2 ? ((LinearScale)((Object)object)).getMargin() : 0), dimension.width, dimension.height));
                rectangle.width -= dimension.width;
            }
            --n;
        }
        n = this.xAxisList.size() - 1;
        while (n >= 0) {
            object = this.xAxisList.get(n);
            Rectangle rectangle2 = object.getBounds().getCopy();
            if (bl3) {
                rectangle2.x = rectangle.x - ((LinearScale)((Object)object)).getMargin() - 1;
            }
            rectangle2.width = rectangle.width + (bl3 ? ((LinearScale)((Object)object)).getMargin() : -1) + (bl ? ((LinearScale)((Object)object)).getMargin() : 0);
            ((LinearScale)((Object)object)).setBounds(rectangle2);
            --n;
        }
        if (this.plotArea != null && this.plotArea.isVisible()) {
            Rectangle rectangle3 = new Rectangle(this.primaryXAxis.getBounds().x + this.primaryXAxis.getMargin(), this.primaryYAxis.getBounds().y + this.primaryYAxis.getMargin(), this.primaryXAxis.getBounds().width - 2 * this.primaryXAxis.getMargin(), this.primaryYAxis.getBounds().height - 2 * this.primaryYAxis.getMargin());
            this.plotArea.setBounds(rectangle3);
        }
        super.layout();
    }

    public void setZoomType(ZoomType zoomType) {
        this.zoomType = zoomType;
        this.plotArea.setZoomType(zoomType);
        for (Axis axis : this.xAxisList) {
            axis.setZoomType(zoomType);
        }
        for (Axis axis : this.yAxisList) {
            axis.setZoomType(zoomType);
        }
    }

    public ZoomType getZoomType() {
        return this.zoomType;
    }

    public void setTitle(String string) {
        this.title = string.trim();
        this.titleLabel.setText(string);
    }

    public void setShowTitle(boolean bl) {
        this.titleLabel.setVisible(bl);
        this.revalidate();
    }

    public boolean isShowTitle() {
        return this.titleLabel.isVisible();
    }

    public void setShowLegend(boolean bl) {
        this.showLegend = bl;
        for (Axis axis : this.legendMap.keySet()) {
            Legend legend = this.legendMap.get((Object)axis);
            legend.setVisible(bl);
        }
        this.revalidate();
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void addAxis(Axis axis) {
        if (axis.isHorizontal()) {
            this.xAxisList.add(axis);
        } else {
            this.yAxisList.add(axis);
        }
        this.plotArea.addGrid(new Grid(axis));
        this.add((IFigure)axis);
        axis.setXyGraph(this);
        this.revalidate();
    }

    public boolean removeAxis(Axis axis) {
        this.remove((IFigure)axis);
        this.plotArea.removeGrid(axis.getGrid());
        this.revalidate();
        if (axis.isHorizontal()) {
            return this.xAxisList.remove((Object)axis);
        }
        return this.yAxisList.remove((Object)axis);
    }

    public void addTrace(Trace trace) {
        if (trace.getTraceColor() == null) {
            trace.setTraceColor(XYGraphMediaFactory.getInstance().getColor(DEFAULT_TRACES_COLOR[this.traceNum % DEFAULT_TRACES_COLOR.length]));
            ++this.traceNum;
        }
        if (this.legendMap.containsKey((Object)trace.getYAxis())) {
            this.legendMap.get((Object)trace.getYAxis()).addTrace(trace);
        } else {
            this.legendMap.put(trace.getYAxis(), new Legend(this));
            this.legendMap.get((Object)trace.getYAxis()).addTrace(trace);
            this.add((IFigure)this.legendMap.get((Object)trace.getYAxis()));
        }
        this.plotArea.addTrace(trace);
        trace.setXYGraph(this);
        trace.dataChanged(null);
        this.revalidate();
        this.repaint();
    }

    public void removeTrace(Trace trace) {
        if (this.legendMap.containsKey((Object)trace.getYAxis())) {
            this.legendMap.get((Object)trace.getYAxis()).removeTrace(trace);
            if (this.legendMap.get((Object)trace.getYAxis()).getTraceList().size() <= 0) {
                this.remove((IFigure)this.legendMap.remove((Object)trace.getYAxis()));
            }
        }
        this.plotArea.removeTrace(trace);
        this.revalidate();
        this.repaint();
    }

    public void addAnnotation(Annotation annotation) {
        this.plotArea.addAnnotation(annotation);
    }

    public void removeAnnotation(Annotation annotation) {
        this.plotArea.removeAnnotation(annotation);
    }

    public void setTitleFont(Font font) {
        this.titleLabel.setFont(font);
    }

    public Font getTitleFont() {
        return this.titleLabel.getFont();
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
        this.titleLabel.setForegroundColor(color);
    }

    public void paintFigure(Graphics graphics) {
        if (!this.transparent) {
            graphics.fillRectangle(this.getClientArea());
        }
        super.paintFigure(graphics);
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
        this.getPlotArea().setOpaque(!bl);
        this.repaint();
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public PlotArea getPlotArea() {
        return this.plotArea;
    }

    public Image getImage() {
        return SingleSourceHelper.getXYGraphSnapShot(this);
    }

    public Color getTitleColor() {
        if (this.titleColor == null) {
            return this.getForegroundColor();
        }
        return this.titleColor;
    }

    public String getTitle() {
        return this.title;
    }

    public OperationsManager getOperationsManager() {
        return this.operationsManager;
    }

    public List<Axis> getXAxisList() {
        return this.xAxisList;
    }

    public List<Axis> getYAxisList() {
        return this.yAxisList;
    }

    public List<Axis> getAxisList() {
        ArrayList<Axis> arrayList = new ArrayList<Axis>();
        arrayList.addAll(this.xAxisList);
        arrayList.addAll(this.yAxisList);
        return arrayList;
    }

    public Map<Axis, Legend> getLegendMap() {
        return this.legendMap;
    }

    public void performAutoScale() {
        ZoomCommand zoomCommand = new ZoomCommand("Auto Scale", this.xAxisList, this.yAxisList);
        for (Axis axis : this.xAxisList) {
            axis.performAutoScale(true);
        }
        for (Axis axis : this.yAxisList) {
            axis.performAutoScale(true);
        }
        zoomCommand.saveState();
        this.operationsManager.addCommand(zoomCommand);
    }

    public void performStagger() {
        ZoomCommand zoomCommand = new ZoomCommand("Stagger Axes", null, this.yAxisList);
        int n = this.yAxisList.size();
        int n2 = 0;
        while (n2 < n) {
            Range range;
            Axis axis = this.yAxisList.get(n2);
            if (!axis.isAutoScale() && (range = axis.getTraceDataRange()) != null) {
                double d;
                double d2;
                double d3 = range.getLower();
                if (d3 == (d2 = range.getUpper())) {
                    d = Math.abs(d3 / 2.0);
                    d3 -= d;
                    d2 += d;
                }
                if (axis.isLogScaleEnabled()) {
                    d3 = Log10.log10(d3);
                    d2 = Log10.log10(d2);
                }
                d = d2 - d3;
                d3 -= 0.1 * d;
                d2 += 0.1 * d;
                d = d2 - d3;
                d3 -= (double)(n - n2 - 1) * d;
                d2 += (double)n2 * d;
                if (axis.isLogScaleEnabled()) {
                    d3 = Log10.pow10(d3);
                    d2 = Log10.pow10(d2);
                }
                if (d3 < d2 && !Double.isInfinite(d3) && !Double.isInfinite(d2)) {
                    axis.setRange(d3, d2);
                }
            }
            ++n2;
        }
        zoomCommand.saveState();
        this.operationsManager.addCommand(zoomCommand);
    }

    public Image getImage(org.eclipse.swt.graphics.Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(this.bounds);
        try {
            this.setBounds(new Rectangle(0, 0, rectangle.width, rectangle.height));
            this.layout();
            this.plotArea.layout();
            this.plotArea.layout();
            this.primaryYAxis.layout();
            this.primaryXAxis.layout();
            Image image = new Image(null, this.bounds.width + 6, this.bounds.height + 6);
            GC gC = new GC((Drawable)image);
            SWTGraphics sWTGraphics = new SWTGraphics(gC);
            sWTGraphics.translate(-this.bounds.x + 3, -this.bounds.y + 3);
            sWTGraphics.setForegroundColor(this.getForegroundColor());
            sWTGraphics.setBackgroundColor(this.getBackgroundColor());
            this.paint((Graphics)sWTGraphics);
            gC.dispose();
            Image image2 = image;
            return image2;
        }
        finally {
            this.setBounds(rectangle2);
            this.layout();
            this.plotArea.layout();
            this.plotArea.layout();
            this.primaryYAxis.layout();
            this.primaryXAxis.layout();
        }
    }
}

