/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.figures;

import java.util.ArrayList;
import java.util.List;
import org.csstudio.swt.xygraph.Preferences;
import org.csstudio.swt.xygraph.dataprovider.IDataProvider;
import org.csstudio.swt.xygraph.dataprovider.IDataProviderListener;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Axis;
import org.csstudio.swt.xygraph.figures.IAxisListener;
import org.csstudio.swt.xygraph.figures.Legend;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.linearscale.AbstractScale;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class Trace
extends Figure
implements IDataProviderListener,
IAxisListener {
    private static final int MARKER_SIZE = 6;
    private static final boolean use_advanced_graphics = Preferences.useAdvancedGraphics();
    private String name;
    private String internalName;
    private IDataProvider traceDataProvider;
    private Axis xAxis;
    private Axis yAxis;
    private Color traceColor;
    private TraceType traceType = TraceType.SOLID_LINE;
    private BaseLine baseLine = BaseLine.ZERO;
    private PointStyle pointStyle = PointStyle.NONE;
    private int lineWidth = 1;
    private int pointSize = 4;
    private int areaAlpha = 100;
    private boolean antiAliasing = true;
    private boolean errorBarEnabled = false;
    private ErrorBarType yErrorBarType = ErrorBarType.BOTH;
    private ErrorBarType xErrorBarType = ErrorBarType.BOTH;
    private int errorBarCapWidth = 4;
    private boolean errorBarColorSetFlag = false;
    private Color errorBarColor;
    private boolean drawYErrorInArea = false;
    private XYGraph xyGraph;
    private List<ISample> hotSampleist;

    public Trace(String string, Axis axis, Axis axis2, IDataProvider iDataProvider) {
        this.setName(string);
        this.xAxis = axis;
        this.yAxis = axis2;
        axis.addTrace(this);
        axis2.addTrace(this);
        axis.addListener(this);
        axis2.addListener(this);
        this.setDataProvider(iDataProvider);
        this.hotSampleist = new ArrayList<ISample>();
        this.setOpaque(false);
    }

    private void drawErrorBar(Graphics graphics, Point point, ISample iSample) {
        Point point2;
        graphics.pushState();
        graphics.setForegroundColor(this.errorBarColor);
        graphics.setLineStyle(1);
        graphics.setLineWidth(1);
        switch (this.yErrorBarType) {
            case MINUS: 
            case BOTH: {
                point2 = new Point(this.xAxis.getValuePosition(iSample.getXValue(), false), this.yAxis.getValuePosition(iSample.getYValue() - iSample.getYMinusError(), false));
                graphics.drawLine(point, point2);
                graphics.drawLine(point2.x - this.errorBarCapWidth / 2, point2.y, point2.x + this.errorBarCapWidth / 2, point2.y);
                if (this.yErrorBarType != ErrorBarType.BOTH) break;
            }
            case PLUS: {
                point2 = new Point(this.xAxis.getValuePosition(iSample.getXValue(), false), this.yAxis.getValuePosition(iSample.getYValue() + iSample.getYPlusError(), false));
                graphics.drawLine(point, point2);
                graphics.drawLine(point2.x - this.errorBarCapWidth / 2, point2.y, point2.x + this.errorBarCapWidth / 2, point2.y);
                break;
            }
        }
        switch (this.xErrorBarType) {
            case MINUS: 
            case BOTH: {
                point2 = new Point(this.xAxis.getValuePosition(iSample.getXValue() - iSample.getXMinusError(), false), this.yAxis.getValuePosition(iSample.getYValue(), false));
                graphics.drawLine(point, point2);
                graphics.drawLine(point2.x, point2.y - this.errorBarCapWidth / 2, point2.x, point2.y + this.errorBarCapWidth / 2);
                if (this.xErrorBarType != ErrorBarType.BOTH) break;
            }
            case PLUS: {
                point2 = new Point(this.xAxis.getValuePosition(iSample.getXValue() + iSample.getXPlusError(), false), this.yAxis.getValuePosition(iSample.getYValue(), false));
                graphics.drawLine(point, point2);
                graphics.drawLine(point2.x, point2.y - this.errorBarCapWidth / 2, point2.x, point2.y + this.errorBarCapWidth / 2);
                break;
            }
        }
        graphics.popState();
    }

    private void drawYErrorArea(Graphics graphics, ISample iSample, ISample iSample2, Point point, Point point2) {
        Object object;
        graphics.pushState();
        Color color = null;
        if (use_advanced_graphics) {
            graphics.setBackgroundColor(this.errorBarColor);
            graphics.setAlpha(this.areaAlpha);
        } else {
            object = this.errorBarColor.getRGB().getHSB();
            color = new Color((Device)Display.getCurrent(), new RGB(object[0], object[1] * (float)this.areaAlpha / 255.0f, 1.0f));
            graphics.setBackgroundColor(color);
        }
        switch (this.yErrorBarType) {
            case PLUS: 
            case BOTH: {
                object = new Point(this.xAxis.getValuePosition(iSample.getXValue(), false), this.yAxis.getValuePosition(iSample.getYValue() + iSample.getYPlusError(), false));
                Point point3 = new Point(this.xAxis.getValuePosition(iSample2.getXValue(), false), this.yAxis.getValuePosition(iSample2.getYValue() + iSample2.getYPlusError(), false));
                graphics.fillPolygon(new int[]{point.x, point.y, object.x, object.y, point3.x, point3.y, point2.x, point2.y});
                if (this.yErrorBarType != ErrorBarType.BOTH) break;
            }
            case MINUS: {
                object = new Point(this.xAxis.getValuePosition(iSample.getXValue(), false), this.yAxis.getValuePosition(iSample.getYValue() - iSample.getYMinusError(), false));
                Point point3 = new Point(this.xAxis.getValuePosition(iSample2.getXValue(), false), this.yAxis.getValuePosition(iSample2.getYValue() - iSample2.getYMinusError(), false));
                graphics.fillPolygon(new int[]{point.x, point.y, object.x, object.y, point3.x, point3.y, point2.x, point2.y});
                break;
            }
        }
        graphics.popState();
        if (color != null) {
            color.dispose();
        }
    }

    public void drawPoint(Graphics graphics, Point point) {
        if (this.pointStyle == PointStyle.NONE) {
            return;
        }
        graphics.pushState();
        graphics.setBackgroundColor(this.traceColor);
        graphics.setLineWidth(1);
        graphics.setLineStyle(1);
        switch (this.pointStyle) {
            case POINT: {
                graphics.fillOval(new Rectangle(point.x - this.pointSize / 2, point.y - this.pointSize / 2, this.pointSize, this.pointSize));
                break;
            }
            case CIRCLE: {
                graphics.drawOval(new Rectangle(point.x - this.pointSize / 2, point.y - this.pointSize / 2, this.pointSize, this.pointSize));
                break;
            }
            case TRIANGLE: {
                graphics.drawPolygon(new int[]{point.x - this.pointSize / 2, point.y + this.pointSize / 2, point.x, point.y - this.pointSize / 2, point.x + this.pointSize / 2, point.y + this.pointSize / 2});
                break;
            }
            case FILLED_TRIANGLE: {
                graphics.fillPolygon(new int[]{point.x - this.pointSize / 2, point.y + this.pointSize / 2, point.x, point.y - this.pointSize / 2, point.x + this.pointSize / 2, point.y + this.pointSize / 2});
                break;
            }
            case SQUARE: {
                graphics.drawRectangle(new Rectangle(point.x - this.pointSize / 2, point.y - this.pointSize / 2, this.pointSize, this.pointSize));
                break;
            }
            case FILLED_SQUARE: {
                graphics.fillRectangle(new Rectangle(point.x - this.pointSize / 2, point.y - this.pointSize / 2, this.pointSize, this.pointSize));
                break;
            }
            case BAR: {
                graphics.drawLine(point.x, point.y - this.pointSize / 2, point.x, point.y + this.pointSize / 2);
                break;
            }
            case CROSS: {
                graphics.drawLine(point.x, point.y - this.pointSize / 2, point.x, point.y + this.pointSize / 2);
                graphics.drawLine(point.x - this.pointSize / 2, point.y, point.x + this.pointSize / 2, point.y);
                break;
            }
            case XCROSS: {
                graphics.drawLine(point.x - this.pointSize / 2, point.y - this.pointSize / 2, point.x + this.pointSize / 2, point.y + this.pointSize / 2);
                graphics.drawLine(point.x + this.pointSize / 2, point.y - this.pointSize / 2, point.x - this.pointSize / 2, point.y + this.pointSize / 2);
                break;
            }
            case DIAMOND: {
                graphics.drawPolyline(new int[]{point.x, point.y - this.pointSize / 2, point.x - this.pointSize / 2, point.y, point.x, point.y + this.pointSize / 2, point.x + this.pointSize / 2, point.y, point.x, point.y - this.pointSize / 2});
                break;
            }
            case FILLED_DIAMOND: {
                graphics.fillPolygon(new int[]{point.x, point.y - this.pointSize / 2, point.x - this.pointSize / 2, point.y, point.x, point.y + this.pointSize / 2, point.x + this.pointSize / 2, point.y});
                break;
            }
        }
        graphics.popState();
    }

    public void drawLine(Graphics graphics, Point point, Point point2) {
        if (this.traceType == TraceType.STEP_HORIZONTALLY || this.traceType == TraceType.STEP_VERTICALLY || this.traceType == TraceType.BAR) {
            switch (this.traceType) {
                case STEP_HORIZONTALLY: {
                    graphics.pushState();
                    graphics.setLineStyle(1);
                    Point point3 = new Point(point2.x, point.y);
                    graphics.drawLine(point, point3);
                    graphics.drawLine(point3, point2);
                    graphics.popState();
                    return;
                }
                case STEP_VERTICALLY: {
                    graphics.pushState();
                    graphics.setLineStyle(1);
                    Point point4 = new Point(point.x, point2.y);
                    graphics.drawLine(point, point4);
                    graphics.drawLine(point4, point2);
                    graphics.popState();
                    return;
                }
                case BAR: {
                    graphics.pushState();
                    if (use_advanced_graphics) {
                        graphics.setAlpha(this.areaAlpha);
                    }
                    graphics.setLineStyle(1);
                    graphics.drawLine(point, point2);
                    graphics.popState();
                    return;
                }
            }
        }
        PointList pointList = new PointList(2);
        pointList.addPoint(point);
        pointList.addPoint(point2);
        this.drawLine(graphics, pointList, true);
    }

    private void drawLine(Graphics graphics, PointList pointList, boolean bl) {
        if (bl) {
            graphics.pushState();
        }
        switch (this.traceType) {
            case SOLID_LINE: {
                graphics.setLineStyle(1);
                graphics.drawPolyline(pointList);
                break;
            }
            case DASH_LINE: {
                graphics.setLineStyle(2);
                graphics.drawPolyline(pointList);
                break;
            }
            case AREA: {
                switch (this.baseLine) {
                    case NEGATIVE_INFINITY: {
                        this.yAxis.getValuePosition(this.yAxis.getRange().getLower(), false);
                        break;
                    }
                    case POSITIVE_INFINITY: {
                        this.yAxis.getValuePosition(this.yAxis.getRange().getUpper(), false);
                        break;
                    }
                    default: {
                        this.yAxis.getValuePosition(0.0, false);
                    }
                }
                if (use_advanced_graphics) {
                    graphics.setAlpha(this.areaAlpha);
                }
                graphics.setBackgroundColor(this.traceColor);
                graphics.fillPolygon(pointList);
                break;
            }
        }
        if (bl) {
            graphics.popState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void paintFigure(Graphics var1_1) {
        block27: {
            super.paintFigure(var1_1);
            if (this.isDisposed()) {
                return;
            }
            var1_1.pushState();
            if (Trace.use_advanced_graphics) {
                var1_1.setAntialias(this.antiAliasing != false ? 1 : 0);
            }
            var1_1.setForegroundColor(this.traceColor);
            var1_1.setLineWidth(this.lineWidth);
            var2_2 = null;
            var3_3 = false;
            var4_4 = null;
            this.hotSampleist.clear();
            if (this.traceDataProvider == null) {
                throw new RuntimeException("No DataProvider defined for trace: " + this.name);
            }
            var5_5 = this.traceDataProvider;
            synchronized (var5_5) {
                if (this.traceDataProvider.getSize() <= 0) break block27;
                if (this.traceDataProvider.isChronological()) {
                    var8_6 = this.getIndexRangeOnXAxis();
                    if (var8_6 == null) {
                        var6_7 = 0;
                        var7_8 = -1;
                    } else {
                        var6_7 = (int)var8_6.getLower();
                        var7_8 = (int)var8_6.getUpper();
                    }
                } else {
                    var6_7 = 0;
                    var7_8 = this.traceDataProvider.getSize() - 1;
                }
                var8_6 = new PointList();
                var9_9 = var6_7;
                while (var9_9 <= var7_8) {
                    block28: {
                        block32: {
                            block30: {
                                block31: {
                                    block29: {
                                        var10_10 = this.traceDataProvider.getSample(var9_9);
                                        var11_11 = this.xAxis.getRange().inRange(var10_10.getXValue());
                                        var12_12 = Double.isNaN(var10_10.getYValue());
                                        if (var11_11 && var12_12) {
                                            var13_14 = new Point(this.xAxis.getValuePosition(var10_10.getXValue(), false), this.yAxis.getValuePosition(this.xAxis.getTickLablesSide() == AbstractScale.LabelSide.Primary ? this.yAxis.getRange().getLower() : this.yAxis.getRange().getUpper(), false));
                                            var1_1.setBackgroundColor(this.traceColor);
                                            var1_1.fillRectangle(var13_14.x - 3, var13_14.y - 3, 6, 6);
                                            var14_15 = new Sample(var10_10.getXValue(), this.xAxis.getTickLablesSide() == AbstractScale.LabelSide.Primary ? this.yAxis.getRange().getLower() : this.yAxis.getRange().getUpper(), var10_10.getYPlusError(), var10_10.getYMinusError(), NaN, var10_10.getXMinusError(), var10_10.getInfo());
                                            this.hotSampleist.add(var14_15);
                                        }
                                        v0 = var13_13 = var11_11 != false || this.yAxis.getRange().inRange(var10_10.getYValue()) != false;
                                        if (var13_13) {
                                            var4_4 = new Point(this.xAxis.getValuePosition(var10_10.getXValue(), false), this.yAxis.getValuePosition(var10_10.getYValue(), false));
                                            this.hotSampleist.add(var10_10);
                                            this.drawPoint(var1_1, var4_4);
                                            if (this.errorBarEnabled && !this.drawYErrorInArea) {
                                                this.drawErrorBar(var1_1, var4_4, var10_10);
                                            }
                                        }
                                        if (this.traceType == TraceType.POINT && !this.drawYErrorInArea) break block28;
                                        if (this.traceType == TraceType.BAR) {
                                            switch (Trace.$SWITCH_TABLE$org$csstudio$swt$xygraph$figures$Trace$BaseLine()[this.baseLine.ordinal()]) {
                                                case 1: {
                                                    var2_2 = new Sample(var10_10.getXValue(), this.yAxis.getRange().getLower());
                                                    break;
                                                }
                                                case 3: {
                                                    var2_2 = new Sample(var10_10.getXValue(), this.yAxis.getRange().getUpper());
                                                    break;
                                                }
                                                default: {
                                                    var2_2 = new Sample(var10_10.getXValue(), 0.0);
                                                }
                                            }
                                            v1 = var3_3 = this.xAxis.getRange().inRange(var2_2.getXValue()) != false && this.yAxis.getRange().inRange(var2_2.getYValue()) != false;
                                        }
                                        if (var2_2 != null) break block29;
                                        var2_2 = var10_10;
                                        var3_3 = var13_13;
                                        break block28;
                                    }
                                    var14_15 = var10_10;
                                    var15_16 = var13_13;
                                    if (var12_12 && !Double.isNaN(var2_2.getYValue()) && (this.traceType == TraceType.STEP_HORIZONTALLY || this.traceType == TraceType.STEP_VERTICALLY)) {
                                        var10_10 = new Sample(var10_10.getXValue(), var2_2.getYValue());
                                        var13_13 = this.yAxis.getRange().inRange(var10_10.getYValue());
                                    }
                                    if (this.traceType == TraceType.AREA) ** GOTO lbl-1000
                                    if (var3_3 || var13_13) break block30;
                                    var16_17 = this.getIntersection(var2_2, var10_10);
                                    if (var16_17[0] != null && var16_17[1] != null) break block31;
                                    var2_2 = var14_15;
                                    var3_3 = var15_16;
                                    break block28;
                                }
                                var2_2 = var16_17[0];
                                var10_10 = var16_17[1];
                                ** GOTO lbl-1000
                            }
                            if (var3_3 && var13_13) ** GOTO lbl-1000
                            if (var3_3) break block32;
                            if ((var2_2 = this.getIntersection(var2_2, var10_10)[0]) != null) ** GOTO lbl-1000
                            var2_2 = var14_15;
                            var3_3 = var15_16;
                            break block28;
                        }
                        if ((var10_10 = this.getIntersection(var2_2, var10_10)[0]) == null) {
                            var2_2 = var14_15;
                            var3_3 = var15_16;
                        } else lbl-1000:
                        // 5 sources

                        {
                            var16_17 = new Point(this.xAxis.getValuePosition(var2_2.getXValue(), false), this.yAxis.getValuePosition(var2_2.getYValue(), false));
                            var4_4 = new Point(this.xAxis.getValuePosition(var10_10.getXValue(), false), this.yAxis.getValuePosition(var10_10.getYValue(), false));
                            if (!var4_4.equals((Object)var16_17)) {
                                if (this.errorBarEnabled && this.drawYErrorInArea && this.traceType != TraceType.BAR) {
                                    this.drawYErrorArea(var1_1, var2_2, var10_10, var16_17, var4_4);
                                }
                                if (this.traceType == TraceType.STEP_HORIZONTALLY || this.traceType == TraceType.STEP_VERTICALLY || this.traceType == TraceType.BAR) {
                                    this.drawLine(var1_1, var16_17, var4_4);
                                } else {
                                    var8_6.addPoint(var16_17);
                                    if (var9_9 == var7_8) {
                                        var8_6.addPoint(var4_4);
                                    }
                                }
                            }
                            var2_2 = var14_15;
                            var3_3 = var15_16;
                        }
                    }
                    ++var9_9;
                }
                this.drawLine(var1_1, (PointList)var8_6, false);
            }
        }
        var1_1.popState();
    }

    private ISample[] getIntersection(ISample iSample, ISample iSample2) {
        if (this.traceType == TraceType.STEP_HORIZONTALLY) {
            ISample[] iSampleArray;
            ISample[] iSampleArray2 = new Sample[2];
            int n = 0;
            Sample sample = new Sample(iSample2.getXValue(), iSample.getYValue());
            ISample[] iSampleArray3 = this.getStraightLineIntersection(iSample, sample);
            if (iSampleArray3[1] != null) {
                return iSampleArray3;
            }
            if (iSampleArray3[0] != null) {
                iSampleArray2[n++] = iSampleArray3[0];
            }
            if ((iSampleArray = this.getStraightLineIntersection(sample, iSample2))[1] != null) {
                return iSampleArray;
            }
            if (iSampleArray[0] != null) {
                iSampleArray2[n++] = iSampleArray[0];
            }
            return iSampleArray2;
        }
        if (this.traceType == TraceType.STEP_VERTICALLY) {
            ISample[] iSampleArray;
            ISample[] iSampleArray4 = new Sample[2];
            int n = 0;
            Sample sample = new Sample(iSample.getXValue(), iSample2.getYValue());
            ISample[] iSampleArray5 = this.getStraightLineIntersection(iSample, sample);
            if (iSampleArray5[1] != null) {
                return iSampleArray5;
            }
            if (iSampleArray5[0] != null) {
                iSampleArray4[n++] = iSampleArray5[0];
            }
            if ((iSampleArray = this.getStraightLineIntersection(sample, iSample2))[1] != null) {
                return iSampleArray;
            }
            if (iSampleArray[0] != null) {
                iSampleArray4[n++] = iSampleArray[0];
            }
            return iSampleArray4;
        }
        return this.getStraightLineIntersection(iSample, iSample2);
    }

    private ISample[] getStraightLineIntersection(ISample iSample, ISample iSample2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = iSample.getXValue();
        double d6 = iSample.getYValue();
        double d7 = iSample2.getXValue();
        double d8 = iSample2.getYValue();
        double d9 = d7 - d5;
        double d10 = d8 - d6;
        ISample[] iSampleArray = new Sample[2];
        int n = 0;
        if (d10 != 0.0) {
            d4 = this.yAxis.getRange().getLower();
            d3 = (d4 - d6) * d9 / d10 + d5;
            if (this.evalDP(d3, d2 = d4, iSample, iSample2)) {
                iSampleArray[n++] = new Sample(d3, d2);
            }
            if (this.evalDP(d3 = ((d = this.yAxis.getRange().getUpper()) - d6) * d9 / d10 + d5, d2 = d, iSample, iSample2)) {
                iSampleArray[n++] = new Sample(d3, d2);
            }
        }
        if (n == 2) {
            return iSampleArray;
        }
        if (d9 != 0.0) {
            d4 = this.xAxis.getRange().getLower();
            d3 = d4;
            if (this.evalDP(d3, d2 = (d4 - d5) * d10 / d9 + d6, iSample, iSample2)) {
                iSampleArray[n++] = new Sample(d3, d2);
            }
            d3 = d = this.xAxis.getRange().getUpper();
            d2 = (d - d5) * d10 / d9 + d6;
            if (d9 != 0.0 && this.evalDP(d3, d2, iSample, iSample2)) {
                iSampleArray[n++] = new Sample(d3, d2);
            }
        }
        return iSampleArray;
    }

    private boolean evalDP(double d, double d2, ISample iSample, ISample iSample2) {
        if (!this.xAxis.getRange().inRange(d) || !this.yAxis.getRange().inRange(d2)) {
            return false;
        }
        if (!new Range(iSample.getXValue(), iSample2.getXValue()).inRange(d) || !new Range(iSample.getYValue(), iSample2.getYValue()).inRange(d2)) {
            return false;
        }
        Sample sample = new Sample(d, d2);
        return !((Object)sample).equals(iSample) && !((Object)sample).equals(iSample2);
    }

    public void setXAxis(Axis axis) {
        if (this.xAxis == axis) {
            return;
        }
        if (this.xAxis != null) {
            this.xAxis.removeListenr(this);
            this.xAxis.removeTrace(this);
        }
        this.xAxis = axis;
        this.xAxis.addTrace(this);
        this.xAxis.addListener(this);
        this.revalidate();
    }

    public Axis getXAxis() {
        return this.xAxis;
    }

    public void setYAxis(Axis axis) {
        if (this.yAxis == axis) {
            return;
        }
        this.xyGraph.getLegendMap().get((Object)this.yAxis).removeTrace(this);
        if (this.xyGraph.getLegendMap().get((Object)this.yAxis).getTraceList().size() <= 0) {
            this.xyGraph.remove((IFigure)this.xyGraph.getLegendMap().get((Object)this.yAxis));
            this.xyGraph.getLegendMap().remove((Object)this.yAxis);
        }
        if (this.xyGraph.getLegendMap().containsKey((Object)axis)) {
            this.xyGraph.getLegendMap().get((Object)axis).addTrace(this);
        } else {
            this.xyGraph.getLegendMap().put(axis, new Legend(this.xyGraph));
            this.xyGraph.getLegendMap().get((Object)axis).addTrace(this);
            this.xyGraph.add((IFigure)this.xyGraph.getLegendMap().get((Object)axis));
        }
        if (this.yAxis != null) {
            this.yAxis.removeListenr(this);
            this.yAxis.removeTrace(this);
        }
        this.yAxis = axis;
        this.yAxis.addTrace(this);
        this.yAxis.addListener(this);
        this.xyGraph.repaint();
    }

    public void setDataProvider(IDataProvider iDataProvider) {
        iDataProvider.addDataProviderListener(this);
        this.traceDataProvider = iDataProvider;
    }

    public TraceType getTraceType() {
        return this.traceType;
    }

    public void setTraceColor(Color color) {
        this.traceColor = color;
        if (!this.errorBarColorSetFlag) {
            this.errorBarColor = color;
        }
    }

    public Color getTraceColor() {
        return this.traceColor;
    }

    public void setTraceType(TraceType traceType) {
        this.traceType = traceType;
    }

    public void setBaseLine(BaseLine baseLine) {
        this.baseLine = baseLine;
    }

    public void setPointStyle(PointStyle pointStyle) {
        this.pointStyle = pointStyle;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    public void setPointSize(int n) {
        this.pointSize = n;
    }

    public void setAreaAlpha(int n) {
        this.areaAlpha = n;
    }

    public void setAntiAliasing(boolean bl) {
        this.antiAliasing = bl;
    }

    public void setName(String string) {
        this.name = string;
        this.revalidate();
    }

    public String getName() {
        return this.name;
    }

    public int getPointSize() {
        return this.pointSize;
    }

    public int getAreaAlpha() {
        return this.areaAlpha;
    }

    public Axis getYAxis() {
        return this.yAxis;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void dataChanged(IDataProvider iDataProvider) {
        boolean bl = this.xAxis.performAutoScale(false);
        boolean bl2 = this.yAxis.performAutoScale(false);
        if (!bl && !bl2) {
            this.repaint();
        }
    }

    private Range getIndexRangeOnXAxis() {
        Range range = this.xAxis.getRange();
        if (this.traceDataProvider.getSize() <= 0) {
            return null;
        }
        if (range.getLower() > this.traceDataProvider.getSample(this.traceDataProvider.getSize() - 1).getXValue() || range.getUpper() < this.traceDataProvider.getSample(0).getXValue()) {
            return null;
        }
        int n = 0;
        int n2 = this.traceDataProvider.getSize() - 1;
        if (range.getLower() > this.traceDataProvider.getSample(0).getXValue()) {
            n = this.nearBinarySearchX(range.getLower(), true);
        }
        if (range.getUpper() < this.traceDataProvider.getSample(n2).getXValue()) {
            n2 = this.nearBinarySearchX(range.getUpper(), false);
        }
        return new Range(n, n2);
    }

    private int nearBinarySearchX(double d, boolean bl) {
        int n = 0;
        int n2 = this.traceDataProvider.getSize() - 1;
        while (n <= n2) {
            int n3;
            int n4 = n + n2 >>> 1;
            double d2 = this.traceDataProvider.getSample(n4).getXValue();
            if (d2 < d) {
                n3 = -1;
            } else if (d2 > d) {
                n3 = 1;
            } else {
                long l;
                long l2 = Double.doubleToLongBits(d2);
                int n5 = l2 == (l = Double.doubleToLongBits(d)) ? 0 : (n3 = l2 < l ? -1 : 1);
            }
            if (n3 < 0) {
                if (n4 < this.traceDataProvider.getSize() - 1 && d < this.traceDataProvider.getSample(n4 + 1).getXValue()) {
                    if (bl) {
                        return n4;
                    }
                    return n4 + 1;
                }
                n = n4 + 1;
                continue;
            }
            if (n3 > 0) {
                if (n4 > 0 && d > this.traceDataProvider.getSample(n4 - 1).getXValue()) {
                    if (bl) {
                        return n4 - 1;
                    }
                    return n4;
                }
                n2 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n + 1);
    }

    @Override
    public void axisRevalidated(Axis axis) {
        this.repaint();
    }

    @Override
    public void axisRangeChanged(Axis axis, Range range, Range range2) {
    }

    public IDataProvider getDataProvider() {
        return this.traceDataProvider;
    }

    public void setErrorBarEnabled(boolean bl) {
        this.errorBarEnabled = bl;
    }

    public void setYErrorBarType(ErrorBarType errorBarType) {
        this.yErrorBarType = errorBarType;
    }

    public void setXErrorBarType(ErrorBarType errorBarType) {
        this.xErrorBarType = errorBarType;
    }

    public void setDrawYErrorInArea(boolean bl) {
        this.drawYErrorInArea = bl;
    }

    public void setErrorBarCapWidth(int n) {
        this.errorBarCapWidth = n;
    }

    public void setErrorBarColor(Color color) {
        this.errorBarColor = color;
        this.errorBarColorSetFlag = true;
    }

    public List<ISample> getHotSampleList() {
        return this.hotSampleist;
    }

    public BaseLine getBaseLine() {
        return this.baseLine;
    }

    public PointStyle getPointStyle() {
        return this.pointStyle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public boolean isAntiAliasing() {
        return this.antiAliasing;
    }

    public boolean isErrorBarEnabled() {
        return this.errorBarEnabled;
    }

    public ErrorBarType getYErrorBarType() {
        return this.yErrorBarType;
    }

    public ErrorBarType getXErrorBarType() {
        return this.xErrorBarType;
    }

    public int getErrorBarCapWidth() {
        return this.errorBarCapWidth;
    }

    public Color getErrorBarColor() {
        return this.errorBarColor;
    }

    public boolean isDrawYErrorInArea() {
        return this.drawYErrorInArea;
    }

    public void setXYGraph(XYGraph xYGraph) {
        this.xyGraph = xYGraph;
    }

    public XYGraph getXYGraph() {
        return this.xyGraph;
    }

    public void dispose() {
        this.removeAll();
        this.hotSampleist.clear();
        this.name = null;
        this.traceDataProvider = null;
        this.xAxis = null;
        this.yAxis = null;
        this.traceColor = null;
        this.traceType = null;
        this.baseLine = null;
        this.pointStyle = null;
        this.yErrorBarType = null;
        this.xErrorBarType = null;
        this.errorBarColor = null;
        this.xyGraph = null;
    }

    public boolean isDisposed() {
        return this.xyGraph == null;
    }

    public String getInternalName() {
        if (this.internalName != null) {
            return this.internalName;
        }
        return this.getName();
    }

    public void setInternalName(String string) {
        this.internalName = string;
    }

    public static enum BaseLine {
        NEGATIVE_INFINITY,
        ZERO,
        POSITIVE_INFINITY;


        public static String[] stringValues() {
            String[] stringArray = new String[BaseLine.values().length];
            int n = 0;
            BaseLine[] baseLineArray = BaseLine.values();
            int n2 = baseLineArray.length;
            int n3 = 0;
            while (n3 < n2) {
                BaseLine baseLine = baseLineArray[n3];
                stringArray[n++] = baseLine.toString();
                ++n3;
            }
            return stringArray;
        }
    }

    public static enum ErrorBarType {
        NONE,
        PLUS,
        MINUS,
        BOTH;


        public static String[] stringValues() {
            String[] stringArray = new String[ErrorBarType.values().length];
            int n = 0;
            ErrorBarType[] errorBarTypeArray = ErrorBarType.values();
            int n2 = errorBarTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ErrorBarType errorBarType = errorBarTypeArray[n3];
                stringArray[n++] = errorBarType.toString();
                ++n3;
            }
            return stringArray;
        }
    }

    public static enum PointStyle {
        NONE("None"),
        POINT("point(\u0007)"),
        CIRCLE("Circle(o)"),
        TRIANGLE("Triangle"),
        FILLED_TRIANGLE("Filled Triangle"),
        SQUARE("Square"),
        FILLED_SQUARE("Filled Square"),
        DIAMOND("Diamond"),
        FILLED_DIAMOND("Filled Diamond"),
        XCROSS("XCross(x)"),
        CROSS("Cross(+)"),
        BAR("Bar(|)");

        private String description;

        private PointStyle(String string2) {
            this.description = string2;
        }

        public String toString() {
            return this.description;
        }

        public static String[] stringValues() {
            String[] stringArray = new String[PointStyle.values().length];
            int n = 0;
            PointStyle[] pointStyleArray = PointStyle.values();
            int n2 = pointStyleArray.length;
            int n3 = 0;
            while (n3 < n2) {
                PointStyle pointStyle = pointStyleArray[n3];
                stringArray[n++] = pointStyle.toString();
                ++n3;
            }
            return stringArray;
        }
    }

    public static enum TraceType {
        SOLID_LINE("Solid Line"),
        DASH_LINE("Dash Line"),
        POINT("Point"),
        BAR("Bar"),
        AREA("Area"),
        STEP_VERTICALLY("Step Vertically"),
        STEP_HORIZONTALLY("Step Horizontally");

        private String description;

        private TraceType(String string2) {
            this.description = string2;
        }

        public String toString() {
            return this.description;
        }

        public static String[] stringValues() {
            String[] stringArray = new String[TraceType.values().length];
            int n = 0;
            TraceType[] traceTypeArray = TraceType.values();
            int n2 = traceTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                TraceType traceType = traceTypeArray[n3];
                stringArray[n++] = traceType.toString();
                ++n3;
            }
            return stringArray;
        }
    }
}

