/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.figures;

import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.toolbar.XYGraphToolbar;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class ToolbarArmedXYGraph
extends Figure {
    private final XYGraph xyGraph;
    private final XYGraphToolbar toolbar;
    private boolean transparent;
    private static final int MARGIN = 3;

    public ToolbarArmedXYGraph() {
        this(new XYGraph());
    }

    public ToolbarArmedXYGraph(XYGraph xYGraph) {
        this(xYGraph, 1);
    }

    public ToolbarArmedXYGraph(XYGraph xYGraph, int n) {
        this.xyGraph = xYGraph;
        this.toolbar = new XYGraphToolbar(this.xyGraph, n);
        xYGraph.setOpaque(false);
        this.toolbar.setOpaque(false);
        this.add((IFigure)this.toolbar);
        this.add((IFigure)xYGraph);
    }

    protected void layout() {
        Rectangle rectangle = this.getClientArea().getCopy();
        if (this.toolbar.isVisible()) {
            this.toolbar.invalidate();
            Dimension dimension = this.toolbar.getPreferredSize(rectangle.width - 3, -1);
            this.toolbar.setBounds(new Rectangle(rectangle.x + 3, rectangle.y + 3, dimension.width, dimension.height));
            rectangle.y += dimension.height + 6;
            rectangle.height -= dimension.height + 6;
        }
        this.xyGraph.setBounds(new Rectangle(rectangle));
        super.layout();
    }

    public void setShowToolbar(boolean bl) {
        this.toolbar.setVisible(bl);
        this.revalidate();
    }

    public boolean isShowToolbar() {
        return this.toolbar.isVisible();
    }

    public XYGraph getXYGraph() {
        return this.xyGraph;
    }

    public boolean isOpaque() {
        return false;
    }

    public void paintFigure(Graphics graphics) {
        if (!this.transparent) {
            graphics.fillRectangle(this.getClientArea());
        }
        super.paintFigure(graphics);
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
        this.xyGraph.setTransparent(bl);
    }

    public void addToolbarButton(Clickable clickable) {
        this.toolbar.addButton(clickable);
    }
}

