/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.figures;

import java.util.ArrayList;
import java.util.List;
import org.csstudio.swt.xygraph.figures.Annotation;
import org.csstudio.swt.xygraph.figures.Axis;
import org.csstudio.swt.xygraph.figures.Grid;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.csstudio.swt.xygraph.undo.SaveStateCommand;
import org.csstudio.swt.xygraph.undo.ZoomCommand;
import org.csstudio.swt.xygraph.undo.ZoomType;
import org.csstudio.swt.xygraph.util.XYGraphMediaFactory;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class PlotArea
extends Figure {
    public static final String BACKGROUND_COLOR = "background_color";
    protected final XYGraph xyGraph;
    private final List<Trace> traceList = new ArrayList<Trace>();
    private final List<Grid> gridList = new ArrayList<Grid>();
    private final List<Annotation> annotationList = new ArrayList<Annotation>();
    private final Cursor grabbing;
    private boolean showBorder;
    private ZoomType zoomType;
    private Point start;
    private Point end;
    private boolean armed;
    private Color revertBackColor;

    public PlotArea(XYGraph xYGraph) {
        this.xyGraph = xYGraph;
        this.setBackgroundColor(XYGraphMediaFactory.getInstance().getColor(255, 255, 255));
        this.setForegroundColor(XYGraphMediaFactory.getInstance().getColor(0, 0, 0));
        this.setOpaque(true);
        RGB rGB = this.getBackgroundColor().getRGB();
        this.revertBackColor = XYGraphMediaFactory.getInstance().getColor(255 - rGB.red, 255 - rGB.green, 255 - rGB.blue);
        PlotMouseListener plotMouseListener = new PlotMouseListener();
        this.addMouseListener(plotMouseListener);
        this.addMouseMotionListener((MouseMotionListener)plotMouseListener);
        this.grabbing = XYGraphMediaFactory.getCursor(XYGraphMediaFactory.CURSOR_TYPE.GRABBING);
        this.zoomType = ZoomType.NONE;
    }

    public void setBackgroundColor(Color color) {
        RGB rGB = color.getRGB();
        this.revertBackColor = XYGraphMediaFactory.getInstance().getColor(255 - rGB.red, 255 - rGB.green, 255 - rGB.blue);
        Color color2 = this.getBackgroundColor();
        super.setBackgroundColor(color);
        this.firePropertyChange(BACKGROUND_COLOR, color2, color);
    }

    public void addTrace(Trace trace) {
        this.traceList.add(trace);
        this.add((IFigure)trace);
        this.revalidate();
    }

    public boolean removeTrace(Trace trace) {
        boolean bl = this.traceList.remove(trace);
        if (bl) {
            this.remove((IFigure)trace);
            this.revalidate();
        }
        return bl;
    }

    public void addGrid(Grid grid) {
        this.gridList.add(grid);
        this.add((IFigure)grid);
        this.revalidate();
    }

    public boolean removeGrid(Grid grid) {
        boolean bl = this.gridList.remove(grid);
        if (bl) {
            this.remove((IFigure)grid);
            this.revalidate();
        }
        return bl;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotationList.add(annotation);
        annotation.setxyGraph(this.xyGraph);
        this.add((IFigure)annotation);
        this.revalidate();
    }

    public boolean removeAnnotation(Annotation annotation) {
        boolean bl = this.annotationList.remove(annotation);
        if (!annotation.isFree()) {
            annotation.getTrace().getDataProvider().removeDataProviderListener(annotation);
        }
        if (bl) {
            this.remove((IFigure)annotation);
            this.revalidate();
        }
        return bl;
    }

    protected void layout() {
        Rectangle rectangle = this.getClientArea();
        for (Trace figure : this.traceList) {
            if (figure == null || !figure.isVisible()) continue;
            figure.setBounds(rectangle);
        }
        for (Grid grid : this.gridList) {
            if (grid == null || !grid.isVisible()) continue;
            grid.setBounds(rectangle);
        }
        for (Annotation annotation : this.annotationList) {
            if (annotation == null || !annotation.isVisible()) continue;
            annotation.setBounds(rectangle);
        }
        super.layout();
    }

    protected void paintClientArea(Graphics graphics) {
        super.paintClientArea(graphics);
        if (this.showBorder) {
            graphics.setLineWidth(2);
            graphics.drawLine(this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y);
            graphics.drawLine(this.bounds.x + this.bounds.width, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height);
        }
        if (this.armed && this.end != null && this.start != null) {
            switch (this.zoomType) {
                case RUBBERBAND_ZOOM: 
                case HORIZONTAL_ZOOM: 
                case VERTICAL_ZOOM: {
                    graphics.setLineStyle(3);
                    graphics.setLineWidth(1);
                    graphics.setForegroundColor(this.revertBackColor);
                    graphics.drawRectangle(this.start.x, this.start.y, this.end.x - this.start.x, this.end.y - this.start.y);
                    break;
                }
            }
        }
    }

    public void setShowBorder(boolean bl) {
        this.showBorder = bl;
        this.repaint();
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    public void setZoomType(ZoomType zoomType) {
        this.zoomType = zoomType;
        this.setCursor(zoomType.getCursor());
    }

    private void zoomInOut(boolean bl, boolean bl2, double d) {
        double d2;
        if (bl) {
            for (Axis axis : this.xyGraph.getXAxisList()) {
                d2 = axis.getPositionValue(this.start.x, false);
                axis.zoomInOut(d2, d);
            }
        }
        if (bl2) {
            for (Axis axis : this.xyGraph.getYAxisList()) {
                d2 = axis.getPositionValue(this.start.y, false);
                axis.zoomInOut(d2, d);
            }
        }
    }

    public List<Trace> getTraceList() {
        return this.traceList;
    }

    public List<Annotation> getAnnotationList() {
        return this.annotationList;
    }

    class PlotMouseListener
    extends MouseMotionListener.Stub
    implements MouseListener {
        private final List<Range> xAxisStartRangeList = new ArrayList<Range>();
        private final List<Range> yAxisStartRangeList = new ArrayList<Range>();
        private SaveStateCommand command;

        PlotMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.button != 1 || PlotArea.this.zoomType == ZoomType.NONE) {
                return;
            }
            PlotArea.this.armed = true;
            switch (PlotArea.this.zoomType) {
                case RUBBERBAND_ZOOM: {
                    PlotArea.this.start = mouseEvent.getLocation();
                    PlotArea.this.end = null;
                    break;
                }
                case HORIZONTAL_ZOOM: {
                    PlotArea.this.start = new Point(mouseEvent.getLocation().x, ((PlotArea)PlotArea.this).bounds.y);
                    PlotArea.this.end = null;
                    break;
                }
                case VERTICAL_ZOOM: {
                    PlotArea.this.start = new Point(((PlotArea)PlotArea.this).bounds.x, mouseEvent.getLocation().y);
                    PlotArea.this.end = null;
                    break;
                }
                case PANNING: {
                    PlotArea.this.setCursor(PlotArea.this.grabbing);
                    PlotArea.this.start = mouseEvent.getLocation();
                    PlotArea.this.end = null;
                    this.xAxisStartRangeList.clear();
                    this.yAxisStartRangeList.clear();
                    for (Axis axis : PlotArea.this.xyGraph.getXAxisList()) {
                        this.xAxisStartRangeList.add(axis.getRange());
                    }
                    for (Axis axis : PlotArea.this.xyGraph.getYAxisList()) {
                        this.yAxisStartRangeList.add(axis.getRange());
                    }
                    break;
                }
                case ZOOM_IN: 
                case ZOOM_OUT: 
                case ZOOM_IN_HORIZONTALLY: 
                case ZOOM_OUT_HORIZONTALLY: 
                case ZOOM_IN_VERTICALLY: 
                case ZOOM_OUT_VERTICALLY: {
                    PlotArea.this.start = mouseEvent.getLocation();
                    PlotArea.this.end = new Point();
                    Display.getCurrent().timerExec(200, new Runnable(){

                        @Override
                        public void run() {
                            if (!PlotArea.this.armed) {
                                return;
                            }
                            PlotMouseListener.this.performInOutZoom();
                            Display.getCurrent().timerExec(200, (Runnable)this);
                        }
                    });
                    break;
                }
            }
            this.command = new ZoomCommand(PlotArea.this.zoomType.getDescription(), PlotArea.this.xyGraph.getXAxisList(), PlotArea.this.xyGraph.getYAxisList());
            mouseEvent.consume();
        }

        public void mouseDoubleClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!PlotArea.this.armed) {
                return;
            }
            switch (PlotArea.this.zoomType) {
                case RUBBERBAND_ZOOM: {
                    PlotArea.this.end = mouseEvent.getLocation();
                    break;
                }
                case HORIZONTAL_ZOOM: {
                    PlotArea.this.end = new Point(mouseEvent.getLocation().x, ((PlotArea)PlotArea.this).bounds.y + ((PlotArea)PlotArea.this).bounds.height);
                    break;
                }
                case VERTICAL_ZOOM: {
                    PlotArea.this.end = new Point(((PlotArea)PlotArea.this).bounds.x + ((PlotArea)PlotArea.this).bounds.width, mouseEvent.getLocation().y);
                    break;
                }
                case PANNING: {
                    PlotArea.this.end = mouseEvent.getLocation();
                    this.pan();
                    break;
                }
            }
            PlotArea.this.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            switch (PlotArea.this.zoomType) {
                case ZOOM_IN: 
                case ZOOM_OUT: 
                case ZOOM_IN_HORIZONTALLY: 
                case ZOOM_OUT_HORIZONTALLY: 
                case ZOOM_IN_VERTICALLY: 
                case ZOOM_OUT_VERTICALLY: {
                    this.mouseReleased(mouseEvent);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!PlotArea.this.armed) {
                return;
            }
            PlotArea.this.armed = false;
            if (PlotArea.this.zoomType == ZoomType.PANNING) {
                PlotArea.this.setCursor(PlotArea.this.zoomType.getCursor());
            }
            if (PlotArea.this.end == null || PlotArea.this.start == null) {
                return;
            }
            switch (PlotArea.this.zoomType) {
                case RUBBERBAND_ZOOM: {
                    double d;
                    double d2;
                    for (Axis axis : PlotArea.this.xyGraph.getXAxisList()) {
                        d2 = axis.getPositionValue(((PlotArea)PlotArea.this).start.x, false);
                        d = axis.getPositionValue(((PlotArea)PlotArea.this).end.x, false);
                        Range range = this.getNewRange(axis, d2, d);
                        axis.setRange(range);
                    }
                    for (Axis axis : PlotArea.this.xyGraph.getYAxisList()) {
                        d2 = axis.getPositionValue(((PlotArea)PlotArea.this).start.y, false);
                        d = axis.getPositionValue(((PlotArea)PlotArea.this).end.y, false);
                        axis.setRange(this.getNewRange(axis, d2, d));
                    }
                    break;
                }
                case HORIZONTAL_ZOOM: {
                    for (Axis axis : PlotArea.this.xyGraph.getXAxisList()) {
                        double d = axis.getPositionValue(((PlotArea)PlotArea.this).start.x, false);
                        double d3 = axis.getPositionValue(((PlotArea)PlotArea.this).end.x, false);
                        axis.setRange(this.getNewRange(axis, d, d3));
                    }
                    break;
                }
                case VERTICAL_ZOOM: {
                    for (Axis axis : PlotArea.this.xyGraph.getYAxisList()) {
                        double d = axis.getPositionValue(((PlotArea)PlotArea.this).start.y, false);
                        double d4 = axis.getPositionValue(((PlotArea)PlotArea.this).end.y, false);
                        axis.setRange(this.getNewRange(axis, d, d4));
                    }
                    break;
                }
                case PANNING: {
                    this.pan();
                    break;
                }
                case ZOOM_IN: 
                case ZOOM_OUT: 
                case ZOOM_IN_HORIZONTALLY: 
                case ZOOM_OUT_HORIZONTALLY: 
                case ZOOM_IN_VERTICALLY: 
                case ZOOM_OUT_VERTICALLY: {
                    this.performInOutZoom();
                    break;
                }
            }
            if (PlotArea.this.zoomType != ZoomType.NONE && this.command != null) {
                this.command.saveState();
                PlotArea.this.xyGraph.getOperationsManager().addCommand(this.command);
                this.command = null;
            }
            PlotArea.this.start = null;
            PlotArea.this.end = null;
            PlotArea.this.repaint();
        }

        private Range getNewRange(Axis axis, double d, double d2) {
            Range range = axis.getRange().isMinBigger() ? new Range(d > d2 ? d : d2, d > d2 ? d2 : d) : new Range(d > d2 ? d2 : d, d > d2 ? d : d2);
            return range;
        }

        private void pan() {
            Axis axis;
            List<Axis> list = PlotArea.this.xyGraph.getXAxisList();
            int n = 0;
            while (n < list.size()) {
                axis = list.get(n);
                axis.pan(this.xAxisStartRangeList.get(n), axis.getPositionValue(((PlotArea)PlotArea.this).start.x, false), axis.getPositionValue(((PlotArea)PlotArea.this).end.x, false));
                ++n;
            }
            list = PlotArea.this.xyGraph.getYAxisList();
            n = 0;
            while (n < list.size()) {
                axis = list.get(n);
                axis.pan(this.yAxisStartRangeList.get(n), axis.getPositionValue(((PlotArea)PlotArea.this).start.y, false), axis.getPositionValue(((PlotArea)PlotArea.this).end.y, false));
                ++n;
            }
        }

        private void performInOutZoom() {
            switch (PlotArea.this.zoomType) {
                case ZOOM_IN: {
                    PlotArea.this.zoomInOut(true, true, 0.1);
                    break;
                }
                case ZOOM_IN_HORIZONTALLY: {
                    PlotArea.this.zoomInOut(true, false, 0.1);
                    break;
                }
                case ZOOM_IN_VERTICALLY: {
                    PlotArea.this.zoomInOut(false, true, 0.1);
                    break;
                }
                case ZOOM_OUT: {
                    PlotArea.this.zoomInOut(true, true, -0.1);
                    break;
                }
                case ZOOM_OUT_HORIZONTALLY: {
                    PlotArea.this.zoomInOut(true, false, -0.1);
                    break;
                }
                case ZOOM_OUT_VERTICALLY: {
                    PlotArea.this.zoomInOut(false, true, -0.1);
                }
            }
        }
    }
}

