/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.figures;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.csstudio.swt.xygraph.Preferences;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.util.XYGraphMediaFactory;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class Legend
extends RectangleFigure {
    private static final int ICON_WIDTH = 25;
    private static final int INNER_GAP = 2;
    private static final int OUT_GAP = 5;
    private final Color BLACK_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_BLACK);
    private final List<Trace> traceList = new ArrayList<Trace>();

    public Legend(XYGraph xYGraph) {
        xYGraph.getPlotArea().addPropertyChangeListener("background_color", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Legend.this.setBackgroundColor((Color)propertyChangeEvent.getNewValue());
            }
        });
        this.setBackgroundColor(xYGraph.getPlotArea().getBackgroundColor());
        this.setForegroundColor(this.BLACK_COLOR);
        this.setOpaque(false);
        this.setOutline(true);
    }

    public void addTrace(Trace trace) {
        this.traceList.add(trace);
    }

    public boolean removeTrace(Trace trace) {
        return this.traceList.remove(trace);
    }

    protected void outlineShape(Graphics graphics) {
        if (!this.traceList.isEmpty()) {
            graphics.setForegroundColor(this.traceList.get(0).getYAxis().getForegroundColor());
        }
        super.outlineShape(graphics);
    }

    protected void fillShape(Graphics graphics) {
        if (!((XYGraph)this.getParent()).isTransparent()) {
            super.fillShape(graphics);
        }
        int n = this.bounds.x + 2;
        int n2 = this.bounds.y + 2;
        int n3 = 0;
        for (Trace trace : this.traceList) {
            int n4 = 32 + FigureUtilities.getTextExtents((String)trace.getName(), (Font)this.getFont()).width;
            int n5 = n + n4;
            if (n5 > this.bounds.x + this.bounds.width && n3 > 0) {
                n = this.bounds.x + 2;
                n2 += 27;
                n5 = n + n4;
            }
            this.drawTraceLagend(trace, graphics, n, n2);
            n = n5;
            ++n3;
        }
    }

    private void drawTraceLagend(Trace trace, Graphics graphics, int n, int n2) {
        graphics.pushState();
        if (Preferences.useAdvancedGraphics()) {
            graphics.setAntialias(1);
        }
        graphics.setForegroundColor(trace.getTraceColor());
        switch (trace.getTraceType()) {
            case BAR: {
                trace.drawLine(graphics, new Point(n + 12, n2 + trace.getPointSize() / 2), new Point(n + 12, n2 + 25));
                trace.drawPoint(graphics, new Point(n + 12, n2 + trace.getPointSize() / 2));
                break;
            }
            case AREA: {
                graphics.setBackgroundColor(trace.getTraceColor());
                if (Preferences.useAdvancedGraphics()) {
                    graphics.setAlpha(trace.getAreaAlpha());
                }
                graphics.fillPolygon(new int[]{n, n2 + 12, n + 12, n2 + trace.getPointSize() / 2, n + 25, n2 + 12, n + 25, n2 + 25, n, n2 + 25});
                if (Preferences.useAdvancedGraphics()) {
                    graphics.setAlpha(255);
                }
                trace.drawPoint(graphics, new Point(n + 12, n2 + trace.getPointSize() / 2));
                break;
            }
            default: {
                trace.drawLine(graphics, new Point(n, n2 + 12), new Point(n + 25, n2 + 12));
                trace.drawPoint(graphics, new Point(n + 12, n2 + 12));
            }
        }
        graphics.drawText(trace.getName(), n + 25 + 2, n2 + 12 - FigureUtilities.getTextExtents((String)trace.getName(), (Font)this.getFont()).height / 2);
        graphics.popState();
    }

    public Dimension getPreferredSize(int n, int n2) {
        int n3 = 0;
        int n4 = 2;
        int n5 = 27;
        for (Trace trace : this.traceList) {
            if ((n4 = n4 + 5 + 25 + 2 + FigureUtilities.getTextExtents((String)trace.getName(), (Font)this.getFont()).width) > n) {
                n4 = 34 + FigureUtilities.getTextExtents((String)trace.getName(), (Font)this.getFont()).width;
                n5 += 27;
            }
            if (n3 >= n4) continue;
            n3 = n4;
        }
        return new Dimension(n3, n5);
    }

    public List<Trace> getTraceList() {
        return this.traceList;
    }
}

