/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.figures;

import org.csstudio.swt.xygraph.figures.Axis;
import org.csstudio.swt.xygraph.figures.IAxisListener;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;

public class Grid
extends Figure
implements IAxisListener {
    private Axis axis;

    public Grid(Axis axis) {
        axis.addListener(this);
        this.axis = axis;
        axis.setGrid(this);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        graphics.pushState();
        if (this.axis.isShowMajorGrid()) {
            graphics.setLineStyle(this.axis.isDashGridLine() ? 2 : 1);
            graphics.setForegroundColor(this.axis.getMajorGridColor());
            graphics.setLineWidth(1);
            for (int n : this.axis.getScaleTickLabels().getTickLabelPositions()) {
                if (this.axis.isHorizontal()) {
                    graphics.drawLine(this.axis.getBounds().x + n, this.bounds.y + this.bounds.height, this.axis.getBounds().x + n, this.bounds.y);
                    continue;
                }
                graphics.drawLine(this.bounds.x, this.axis.getBounds().y + this.axis.getBounds().height - n, this.bounds.x + this.bounds.width, this.axis.getBounds().y + this.axis.getBounds().height - n);
            }
        }
        graphics.popState();
    }

    @Override
    public void axisRevalidated(Axis axis) {
        if (axis.isShowMajorGrid()) {
            this.repaint();
        }
    }

    @Override
    public void axisRangeChanged(Axis axis, Range range, Range range2) {
    }
}

