/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.figures;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.csstudio.swt.xygraph.dataprovider.IDataProvider;
import org.csstudio.swt.xygraph.figures.Grid;
import org.csstudio.swt.xygraph.figures.IAxisListener;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.linearscale.AbstractScale;
import org.csstudio.swt.xygraph.linearscale.LinearScale;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.csstudio.swt.xygraph.undo.AxisPanOrZoomCommand;
import org.csstudio.swt.xygraph.undo.SaveStateCommand;
import org.csstudio.swt.xygraph.undo.ZoomType;
import org.csstudio.swt.xygraph.util.GraphicsUtil;
import org.csstudio.swt.xygraph.util.Log10;
import org.csstudio.swt.xygraph.util.XYGraphMediaFactory;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class Axis
extends LinearScale {
    static final double ZOOM_RATIO = 0.1;
    static final int ZOOM_SPEED = 200;
    private String title;
    private final List<Trace> traceList = new ArrayList<Trace>();
    private XYGraph xyGraph;
    private Grid grid;
    private Font titleFont;
    private boolean autoScale = false;
    private boolean showMajorGrid = false;
    private boolean showMinorGrid = false;
    private Color majorGridColor;
    private Color minorGridColor;
    private boolean dashGridLine = true;
    private double autoScaleThreshold = 0.01;
    private final List<IAxisListener> listeners = new ArrayList<IAxisListener>();
    private ZoomType zoomType = ZoomType.NONE;
    private Point start;
    private Point end;
    private boolean armed;
    private Range startRange;
    private Cursor grabbing;
    private Color revertBackColor;

    public Axis(String string, boolean bl) {
        this.title = string;
        if (bl) {
            this.setOrientation(LinearScale.Orientation.VERTICAL);
        }
        AxisMouseListener axisMouseListener = new AxisMouseListener();
        this.addMouseListener(axisMouseListener);
        this.addMouseMotionListener((MouseMotionListener)axisMouseListener);
        this.grabbing = XYGraphMediaFactory.getCursor(XYGraphMediaFactory.CURSOR_TYPE.GRABBING);
        Font font = Display.getCurrent().getSystemFont();
        this.titleFont = XYGraphMediaFactory.getInstance().getFont(new FontData(font.getFontData()[0].getName(), 12, 1));
        if (this.getBackgroundColor() != null) {
            RGB rGB = this.getBackgroundColor().getRGB();
            this.revertBackColor = XYGraphMediaFactory.getInstance().getColor(255 - rGB.red, 255 - rGB.green, 255 - rGB.blue);
        } else {
            this.revertBackColor = XYGraphMediaFactory.getInstance().getColor(100, 100, 100);
        }
    }

    public void addListener(IAxisListener iAxisListener) {
        if (this.listeners.contains(iAxisListener)) {
            return;
        }
        this.listeners.add(iAxisListener);
    }

    public boolean removeListenr(IAxisListener iAxisListener) {
        return this.listeners.remove(iAxisListener);
    }

    private void fireRevalidated() {
        for (IAxisListener iAxisListener : this.listeners) {
            iAxisListener.axisRevalidated(this);
        }
    }

    private void fireAxisRangeChanged(Range range, Range range2) {
        for (IAxisListener iAxisListener : this.listeners) {
            iAxisListener.axisRangeChanged(this, range, range2);
        }
    }

    @Override
    public void setRange(double d, double d2) {
        Range range = this.getRange();
        super.setRange(d, d2);
        this.fireAxisRangeChanged(range, this.getRange());
    }

    @Override
    protected void layout() {
        super.layout();
        this.fireRevalidated();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.revalidate();
    }

    @Override
    public void setForegroundColor(Color color) {
        super.setForegroundColor(color);
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
    }

    public void setBackgroundColor(Color color) {
        RGB rGB = color.getRGB();
        this.revertBackColor = XYGraphMediaFactory.getInstance().getColor(255 - rGB.red, 255 - rGB.green, 255 - rGB.blue);
        super.setBackgroundColor(color);
    }

    @Override
    public Dimension getPreferredSize(int n, int n2) {
        Dimension dimension = super.getPreferredSize(n, n2);
        if (this.isVisible()) {
            if (this.isHorizontal()) {
                dimension.height += FigureUtilities.getTextExtents((String)this.title, (Font)this.titleFont).height;
            } else {
                dimension.width += FigureUtilities.getTextExtents((String)this.title, (Font)this.titleFont).height;
            }
        } else if (this.isHorizontal()) {
            dimension.height = 0;
        } else {
            dimension.width = 0;
        }
        return dimension;
    }

    protected void paintClientArea(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        super.paintClientArea(graphics);
        graphics.setFont(this.titleFont);
        Dimension dimension = FigureUtilities.getTextExtents((String)this.title, (Font)this.titleFont);
        if (this.isHorizontal()) {
            if (this.getTickLablesSide() == AbstractScale.LabelSide.Primary) {
                graphics.drawText(this.title, this.bounds.x + this.bounds.width / 2 - dimension.width / 2, this.bounds.y + this.bounds.height - dimension.height);
            } else {
                graphics.drawText(this.title, this.bounds.x + this.bounds.width / 2 - dimension.width / 2, this.bounds.y);
            }
        } else {
            int n = dimension.height;
            int n2 = dimension.width + 1;
            if (this.getTickLablesSide() == AbstractScale.LabelSide.Primary) {
                GraphicsUtil.drawVerticalText(graphics, this.title, this.bounds.x, this.bounds.y + this.bounds.height / 2 - n2 / 2, false);
            } else {
                GraphicsUtil.drawVerticalText(graphics, this.title, this.bounds.x + this.bounds.width - n, this.bounds.y + this.bounds.height / 2 - n2 / 2, true);
            }
        }
        if (this.armed && this.end != null && this.start != null) {
            switch (this.zoomType) {
                case RUBBERBAND_ZOOM: 
                case HORIZONTAL_ZOOM: 
                case VERTICAL_ZOOM: {
                    graphics.setLineStyle(3);
                    graphics.setLineWidth(1);
                    graphics.setForegroundColor(this.revertBackColor);
                    graphics.drawRectangle(this.start.x, this.start.y, this.end.x - this.start.x - 1, this.end.y - this.start.y - 1);
                    break;
                }
            }
        }
    }

    public Range getTraceDataRange() {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (Trace trace : this.traceList) {
            Range range;
            if (trace.getDataProvider() == null || (range = this.isHorizontal() ? trace.getDataProvider().getXDataMinMax() : trace.getDataProvider().getYDataMinMax()) == null || Double.isInfinite(range.getLower()) || Double.isInfinite(range.getUpper()) || Double.isNaN(range.getLower()) || Double.isNaN(range.getUpper())) continue;
            if (d > range.getLower()) {
                d = range.getLower();
            }
            if (!(d2 < range.getUpper())) continue;
            d2 = range.getUpper();
        }
        if (Double.isInfinite(d) || Double.isInfinite(d2)) {
            return null;
        }
        return new Range(d, d2);
    }

    public boolean performAutoScale(boolean bl) {
        if (this.traceList.size() <= 0 || !bl && !this.autoScale) {
            return false;
        }
        Range range = this.getTraceDataRange();
        if (range == null) {
            return false;
        }
        double d = range.getLower();
        double d2 = range.getUpper();
        double d3 = this.getRange().getUpper();
        double d4 = this.getRange().getLower();
        if (this.isLogScaleEnabled()) {
            d = Log10.log10(d);
            d2 = Log10.log10(d2);
            d3 = Log10.log10(d3);
            d4 = Log10.log10(d4);
        }
        double d5 = (d3 - d4) * this.autoScaleThreshold;
        if (d - d4 >= 0.0 && d - d4 < d5 && d3 - d2 >= 0.0 && d3 - d2 < d5) {
            return false;
        }
        if (d - d4 < 0.0) {
            d -= d5;
        }
        if (d2 - d3 > 0.0) {
            d2 += d5;
        }
        if (Double.doubleToLongBits(d) == Double.doubleToLongBits(d4) && Double.doubleToLongBits(d2) == Double.doubleToLongBits(d3) || Double.isInfinite(d) || Double.isInfinite(d2) || Double.isNaN(d) || Double.isNaN(d2)) {
            return false;
        }
        if (this.isLogScaleEnabled()) {
            d = Log10.pow10(d);
            d2 = Log10.pow10(d2);
        }
        this.setRange(d, d2);
        this.repaint();
        return true;
    }

    public void addTrace(Trace trace) {
        if (this.traceList.contains(trace)) {
            return;
        }
        this.traceList.add(trace);
        this.performAutoScale(false);
    }

    public boolean removeTrace(Trace trace) {
        boolean bl = this.traceList.remove(trace);
        this.performAutoScale(false);
        return bl;
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean bl) {
        this.autoScale = bl;
        this.performAutoScale(false);
    }

    public boolean isShowMajorGrid() {
        return this.showMajorGrid;
    }

    public void setShowMajorGrid(boolean bl) {
        this.showMajorGrid = bl;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
    }

    public boolean isShowMinorGrid() {
        return this.showMinorGrid;
    }

    public void setShowMinorGrid(boolean bl) {
        this.showMinorGrid = bl;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
    }

    public Color getMajorGridColor() {
        if (this.majorGridColor == null) {
            this.majorGridColor = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_GRAY);
        }
        return this.majorGridColor;
    }

    public void setMajorGridColor(Color color) {
        this.majorGridColor = color;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
    }

    public Color getMinorGridColor() {
        if (this.minorGridColor == null) {
            this.minorGridColor = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_GRAY);
        }
        return this.minorGridColor;
    }

    public void setMinorGridColor(Color color) {
        this.minorGridColor = color;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
        this.repaint();
    }

    public boolean isDashGridLine() {
        return this.dashGridLine;
    }

    public void setDashGridLine(boolean bl) {
        this.dashGridLine = bl;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
    }

    public void setXyGraph(XYGraph xYGraph) {
        this.xyGraph = xYGraph;
    }

    public String toString() {
        return this.title;
    }

    public void dataChanged(IDataProvider iDataProvider) {
        if (this.autoScale) {
            this.performAutoScale(false);
        }
    }

    public void setAutoScaleThreshold(double d) {
        if (d > 1.0 || d < 0.0) {
            throw new RuntimeException("The autoScaleThreshold must be a value in range [0,1]!");
        }
        this.autoScaleThreshold = d;
    }

    private boolean isValidZoomType(ZoomType zoomType) {
        return zoomType == ZoomType.PANNING || zoomType == ZoomType.RUBBERBAND_ZOOM || zoomType == ZoomType.ZOOM_IN || zoomType == ZoomType.ZOOM_OUT || this.isHorizontal() && (zoomType == ZoomType.HORIZONTAL_ZOOM || zoomType == ZoomType.ZOOM_IN_HORIZONTALLY || zoomType == ZoomType.ZOOM_OUT_HORIZONTALLY) || !this.isHorizontal() && (zoomType == ZoomType.VERTICAL_ZOOM || zoomType == ZoomType.ZOOM_OUT_VERTICALLY || zoomType == ZoomType.ZOOM_IN_VERTICALLY);
    }

    public void setZoomType(ZoomType zoomType) {
        this.zoomType = zoomType;
        if (this.isValidZoomType(zoomType)) {
            this.setCursor(zoomType.getCursor());
        } else {
            this.setCursor(ZoomType.NONE.getCursor());
        }
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public double getAutoScaleThreshold() {
        return this.autoScaleThreshold;
    }

    public void setYAxis(boolean bl) {
        if (this.xyGraph != null) {
            this.xyGraph.removeAxis(this);
        }
        this.setOrientation(bl ? LinearScale.Orientation.VERTICAL : LinearScale.Orientation.HORIZONTAL);
        if (this.xyGraph != null) {
            this.xyGraph.addAxis(this);
        }
    }

    public void setPrimarySide(boolean bl) {
        this.setTickLableSide(bl ? AbstractScale.LabelSide.Primary : AbstractScale.LabelSide.Secondary);
    }

    public boolean isYAxis() {
        return !this.isHorizontal();
    }

    public boolean isOnPrimarySide() {
        return this.getTickLablesSide() == AbstractScale.LabelSide.Primary;
    }

    private void pan() {
        if (this.isHorizontal()) {
            this.pan(this.startRange, this.getPositionValue(this.start.x, false), this.getPositionValue(this.end.x, false));
        } else {
            this.pan(this.startRange, this.getPositionValue(this.start.y, false), this.getPositionValue(this.end.y, false));
        }
    }

    void pan(Range range, double d, double d2) {
        if (this.isLogScaleEnabled()) {
            double d3 = Math.log10(d2) - Math.log10(d);
            d = Math.pow(10.0, Math.log10(range.getLower()) - d3);
            d2 = Math.pow(10.0, Math.log10(range.getUpper()) - d3);
        } else {
            double d4 = d2 - d;
            d = range.getLower() - d4;
            d2 = range.getUpper() - d4;
        }
        this.setRange(d, d2);
    }

    void zoomInOut(double d, double d2) {
        double d3;
        double d4;
        if (this.isLogScaleEnabled()) {
            double d5 = Math.log10(this.getRange().getUpper()) - Math.log10(this.getRange().getLower());
            double d6 = (Math.log10(d) - Math.log10(this.getRange().getLower())) / d5;
            double d7 = (Math.log10(this.getRange().getUpper()) - Math.log10(d)) / d5;
            d4 = Math.pow(10.0, Math.log10(this.getRange().getLower()) + d6 * d2 * d5);
            d3 = Math.pow(10.0, Math.log10(this.getRange().getUpper()) - d7 * d2 * d5);
        } else {
            double d8 = this.getRange().getUpper() - this.getRange().getLower();
            double d9 = (d - this.getRange().getLower()) / d8;
            double d10 = (this.getRange().getUpper() - d) / d8;
            d4 = this.getRange().getLower() + d9 * d2 * d8;
            d3 = this.getRange().getUpper() - d10 * d2 * d8;
        }
        this.setRange(d4, d3);
    }

    public void setGrid(Grid grid) {
        this.grid = grid;
    }

    public Grid getGrid() {
        return this.grid;
    }

    public void clear() {
        Iterator<IAxisListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            if (!this.traceList.contains(iterator.next())) continue;
            iterator.remove();
        }
        this.traceList.clear();
    }

    class AxisMouseListener
    extends MouseMotionListener.Stub
    implements MouseListener {
        private SaveStateCommand command;

        AxisMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.button != 1 || !Axis.this.isValidZoomType(Axis.this.zoomType)) {
                return;
            }
            Axis.this.armed = true;
            switch (Axis.this.zoomType) {
                case RUBBERBAND_ZOOM: {
                    if (Axis.this.isHorizontal()) {
                        Axis.this.start = new Point(mouseEvent.getLocation().x, ((Axis)Axis.this).bounds.y);
                    } else {
                        Axis.this.start = new Point(((Axis)Axis.this).bounds.x, mouseEvent.getLocation().y);
                    }
                    Axis.this.end = null;
                    break;
                }
                case HORIZONTAL_ZOOM: {
                    Axis.this.start = new Point(mouseEvent.getLocation().x, ((Axis)Axis.this).bounds.y);
                    Axis.this.end = null;
                    break;
                }
                case VERTICAL_ZOOM: {
                    Axis.this.start = new Point(((Axis)Axis.this).bounds.x, mouseEvent.getLocation().y);
                    Axis.this.end = null;
                    break;
                }
                case PANNING: {
                    Axis.this.setCursor(Axis.this.grabbing);
                    Axis.this.start = mouseEvent.getLocation();
                    Axis.this.end = null;
                    Axis.this.startRange = Axis.this.getRange();
                    break;
                }
                case ZOOM_IN: 
                case ZOOM_OUT: 
                case ZOOM_IN_HORIZONTALLY: 
                case ZOOM_OUT_HORIZONTALLY: 
                case ZOOM_IN_VERTICALLY: 
                case ZOOM_OUT_VERTICALLY: {
                    Axis.this.start = mouseEvent.getLocation();
                    Axis.this.end = new Point();
                    Display.getCurrent().timerExec(200, new Runnable(){

                        @Override
                        public void run() {
                            if (!Axis.this.armed) {
                                return;
                            }
                            AxisMouseListener.this.performInOutZoom();
                            Display.getCurrent().timerExec(200, (Runnable)this);
                        }
                    });
                    break;
                }
            }
            this.command = new AxisPanOrZoomCommand(Axis.this.zoomType.getDescription(), Axis.this);
            mouseEvent.consume();
        }

        public void mouseDoubleClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!Axis.this.armed) {
                return;
            }
            switch (Axis.this.zoomType) {
                case RUBBERBAND_ZOOM: {
                    if (Axis.this.isHorizontal()) {
                        Axis.this.end = new Point(mouseEvent.getLocation().x, ((Axis)Axis.this).bounds.y + ((Axis)Axis.this).bounds.height);
                        break;
                    }
                    Axis.this.end = new Point(((Axis)Axis.this).bounds.x + ((Axis)Axis.this).bounds.width, mouseEvent.getLocation().y);
                    break;
                }
                case HORIZONTAL_ZOOM: {
                    Axis.this.end = new Point(mouseEvent.getLocation().x, ((Axis)Axis.this).bounds.y + ((Axis)Axis.this).bounds.height);
                    break;
                }
                case VERTICAL_ZOOM: {
                    Axis.this.end = new Point(((Axis)Axis.this).bounds.x + ((Axis)Axis.this).bounds.width, mouseEvent.getLocation().y);
                    break;
                }
                case PANNING: {
                    Axis.this.end = mouseEvent.getLocation();
                    Axis.this.pan();
                    break;
                }
            }
            Axis.this.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            switch (Axis.this.zoomType) {
                case ZOOM_IN: 
                case ZOOM_OUT: 
                case ZOOM_IN_HORIZONTALLY: 
                case ZOOM_OUT_HORIZONTALLY: 
                case ZOOM_IN_VERTICALLY: 
                case ZOOM_OUT_VERTICALLY: {
                    this.mouseReleased(mouseEvent);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!Axis.this.armed) {
                return;
            }
            Axis.this.armed = false;
            if (Axis.this.zoomType == ZoomType.PANNING) {
                Axis.this.setCursor(Axis.this.zoomType.getCursor());
            }
            if (Axis.this.end == null || Axis.this.start == null || this.command == null) {
                return;
            }
            switch (Axis.this.zoomType) {
                case RUBBERBAND_ZOOM: 
                case HORIZONTAL_ZOOM: 
                case VERTICAL_ZOOM: {
                    this.performStartEndZoom();
                    break;
                }
                case PANNING: {
                    Axis.this.pan();
                    break;
                }
                case ZOOM_IN: 
                case ZOOM_OUT: 
                case ZOOM_IN_HORIZONTALLY: 
                case ZOOM_OUT_HORIZONTALLY: 
                case ZOOM_IN_VERTICALLY: 
                case ZOOM_OUT_VERTICALLY: {
                    this.performInOutZoom();
                    break;
                }
            }
            this.command.saveState();
            Axis.this.xyGraph.getOperationsManager().addCommand(this.command);
            this.command = null;
            Axis.this.start = null;
            Axis.this.end = null;
        }

        private void performStartEndZoom() {
            double d = Axis.this.getPositionValue(Axis.this.isHorizontal() ? ((Axis)Axis.this).start.x : ((Axis)Axis.this).start.y, false);
            double d2 = Axis.this.getPositionValue(Axis.this.isHorizontal() ? ((Axis)Axis.this).end.x : ((Axis)Axis.this).end.y, false);
            if (Axis.this.getRange().isMinBigger()) {
                Axis.this.setRange(d > d2 ? d : d2, d > d2 ? d2 : d);
            } else {
                Axis.this.setRange(d > d2 ? d2 : d, d > d2 ? d : d2);
            }
        }

        private void performInOutZoom() {
            int n = Axis.this.isHorizontal() ? ((Axis)Axis.this).start.x : ((Axis)Axis.this).start.y;
            double d = Axis.this.getPositionValue(n, false);
            switch (Axis.this.zoomType) {
                case ZOOM_IN: {
                    Axis.this.zoomInOut(d, 0.1);
                    break;
                }
                case ZOOM_IN_HORIZONTALLY: {
                    Axis.this.zoomInOut(d, 0.1);
                    break;
                }
                case ZOOM_IN_VERTICALLY: {
                    Axis.this.zoomInOut(d, 0.1);
                    break;
                }
                case ZOOM_OUT: {
                    Axis.this.zoomInOut(d, -0.1);
                    break;
                }
                case ZOOM_OUT_HORIZONTALLY: {
                    Axis.this.zoomInOut(d, -0.1);
                    break;
                }
                case ZOOM_OUT_VERTICALLY: {
                    Axis.this.zoomInOut(d, -0.1);
                }
            }
        }
    }
}

