/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.figures;

import org.csstudio.swt.xygraph.Preferences;
import org.csstudio.swt.xygraph.dataprovider.IDataProvider;
import org.csstudio.swt.xygraph.dataprovider.IDataProviderListener;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.figures.Axis;
import org.csstudio.swt.xygraph.figures.IAxisListener;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.csstudio.swt.xygraph.undo.MovingAnnotationCommand;
import org.csstudio.swt.xygraph.undo.MovingAnnotationLabelCommand;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class Annotation
extends Figure
implements IAxisListener,
IDataProviderListener {
    private Axis xAxis;
    private Axis yAxis;
    private String name;
    private CursorLineStyle cursorLineStyle = CursorLineStyle.NONE;
    private Point currentPosition;
    private double xValue;
    private double yValue;
    private Trace trace;
    private ISample currentSnappedSample;
    private boolean showName = true;
    private boolean showSampleInfo = true;
    private boolean showPosition = true;
    private Color annotationColor = null;
    private Label infoLabel;
    private double dx = 40.0;
    private double dy = -40.0;
    private double x0;
    private double y0;
    private boolean knowX0Y0 = false;
    private boolean infoLabelArmed = false;
    private Pointer pointer;
    private XYGraph xyGraph;
    private static final int POINT_SIZE = 6;
    private static final int CURSOR_LINE_LENGTH = 3;
    private static final int ARROW_LINE_LENGTH = 12;
    private boolean pointerDragged;

    public Annotation(String string, Trace trace) {
        this(string, trace.getXAxis(), trace.getYAxis());
        this.trace = trace;
        trace.getDataProvider().addDataProviderListener(this);
    }

    public Annotation(String string, Axis axis, Axis axis2) {
        this.xAxis = axis;
        this.yAxis = axis2;
        this.name = string;
        this.trace = null;
        this.infoLabel = new Label();
        this.infoLabel.setOpaque(false);
        this.infoLabel.setCursor(Cursors.SIZEALL);
        this.add((IFigure)this.infoLabel);
        InfoLabelDragger infoLabelDragger = new InfoLabelDragger();
        this.infoLabel.addMouseMotionListener((MouseMotionListener)infoLabelDragger);
        this.infoLabel.addMouseListener((MouseListener)infoLabelDragger);
        this.pointer = new Pointer();
        this.add((IFigure)this.pointer);
        this.updateToDefaultPosition();
        axis.addListener(this);
        axis2.addListener(this);
    }

    public boolean containsPoint(int n, int n2) {
        return this.infoLabel.containsPoint(n, n2) || this.pointer.containsPoint(n, n2);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.trace != null && this.currentSnappedSample == null && !this.pointerDragged) {
            this.updateToDefaultPosition();
        }
        if (Preferences.useAdvancedGraphics()) {
            graphics.setAntialias(1);
        }
        Color color = this.annotationColor == null ? this.yAxis.getForegroundColor() : this.annotationColor;
        this.infoLabel.setForegroundColor(color);
        this.pointer.setForegroundColor(color);
        graphics.setForegroundColor(color);
        Dimension dimension = this.infoLabel.getPreferredSize();
        this.updateX0Y0Fromdxdy(dimension);
        Rectangle rectangle = new Rectangle((int)((double)this.currentPosition.x + this.x0 - (double)dimension.width / 2.0), (int)((double)this.currentPosition.y + this.y0 - (double)dimension.height / 2.0), dimension.width, dimension.height);
        this.infoLabel.setBounds(rectangle);
        this.pointer.setBounds(new Rectangle(this.currentPosition.x - 6, this.currentPosition.y - 6, 12, 12));
        if (this.infoLabelArmed) {
            graphics.drawRectangle(rectangle);
        }
        graphics.drawLine(this.currentPosition.x + (int)this.dx, this.currentPosition.y + (int)this.dy, this.currentPosition.x, this.currentPosition.y);
        int n = (int)(12.0 * Math.cos(Math.atan(-this.dy / this.dx) - 0.3490658503988659));
        int n2 = (int)(12.0 * Math.sin(Math.atan(-this.dy / this.dx) - 0.3490658503988659));
        if (this.dx < 0.0) {
            n = -n;
            n2 = -n2;
        }
        graphics.drawLine(this.currentPosition.x + n, this.currentPosition.y - n2, this.currentPosition.x, this.currentPosition.y);
        n = (int)(12.0 * Math.cos(Math.atan(-this.dy / this.dx) + 0.3490658503988659));
        n2 = (int)(12.0 * Math.sin(Math.atan(-this.dy / this.dx) + 0.3490658503988659));
        if (this.dx < 0.0) {
            n = -n;
            n2 = -n2;
        }
        graphics.drawLine(this.currentPosition.x + n, this.currentPosition.y - n2, this.currentPosition.x, this.currentPosition.y);
        switch (this.cursorLineStyle) {
            case NONE: {
                graphics.drawLine(this.currentPosition.x - 3, this.currentPosition.y, this.currentPosition.x - 3 - 3, this.currentPosition.y);
                graphics.drawLine(this.currentPosition.x + 3, this.currentPosition.y, this.currentPosition.x + 3 + 3, this.currentPosition.y);
                graphics.drawLine(this.currentPosition.x, this.currentPosition.y - 3, this.currentPosition.x, this.currentPosition.y - 3 - 3);
                graphics.drawLine(this.currentPosition.x, this.currentPosition.y + 3, this.currentPosition.x, this.currentPosition.y + 3 + 3);
                break;
            }
            case LEFT_RIGHT: 
            case FOUR_DIRECTIONS: {
                graphics.drawLine(this.currentPosition.x - 3, this.currentPosition.y, this.xAxis.getValuePosition(this.xAxis.getRange().getLower(), false), this.currentPosition.y);
                graphics.drawLine(this.currentPosition.x + 3, this.currentPosition.y, this.xAxis.getValuePosition(this.xAxis.getRange().getUpper(), false), this.currentPosition.y);
                if (this.cursorLineStyle != CursorLineStyle.FOUR_DIRECTIONS) break;
            }
            case UP_DOWN: {
                graphics.drawLine(this.currentPosition.x, this.currentPosition.y - 3, this.currentPosition.x, this.yAxis.getValuePosition(this.yAxis.getRange().getUpper(), false));
                graphics.drawLine(this.currentPosition.x, this.currentPosition.y + 3, this.currentPosition.x, this.yAxis.getValuePosition(this.yAxis.getRange().getLower(), false));
                break;
            }
        }
    }

    public void updateX0Y0Fromdxdy(Dimension dimension) {
        if (!this.knowX0Y0) {
            this.knowX0Y0 = true;
            int n = dimension.height;
            int n2 = dimension.width;
            if (this.dy != 0.0) {
                this.y0 = this.dy - (double)n / 2.0;
                this.x0 = this.dx / this.dy * this.y0;
                if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.x0 - (double)n2 / 2.0, this.x0 + (double)n2 / 2.0).inRange(this.dx)) {
                    return;
                }
                this.y0 = this.dy + (double)n / 2.0;
                this.x0 = this.dx / this.dy * this.y0;
                if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.x0 - (double)n2 / 2.0, this.x0 + (double)n2 / 2.0).inRange(this.dx)) {
                    return;
                }
            }
            if (this.dx != 0.0) {
                this.x0 = this.dx + (double)n2 / 2.0;
                this.y0 = this.dy / this.dx * this.x0;
                if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.y0 - (double)n / 2.0, this.y0 + (double)n / 2.0).inRange(this.dy)) {
                    return;
                }
                this.x0 = this.dx - (double)n2 / 2.0;
                this.y0 = this.dy / this.dx * this.x0;
                if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.y0 - (double)n / 2.0, this.y0 + (double)n / 2.0).inRange(this.dy)) {
                    return;
                }
            }
        } else {
            return;
        }
    }

    private void updatedxdyFromX0Y0() {
        Dimension dimension = this.infoLabel.getPreferredSize();
        int n = dimension.height;
        int n2 = dimension.width;
        if (this.y0 != 0.0) {
            this.dy = this.y0 + (double)n / 2.0;
            this.dx = this.x0 * this.dy / this.y0;
            if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.x0 - (double)n2 / 2.0, this.x0 + (double)n2 / 2.0).inRange(this.dx)) {
                return;
            }
            this.dy = this.y0 - (double)n / 2.0;
            this.dx = this.x0 * this.dy / this.y0;
            if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.x0 - (double)n2 / 2.0, this.x0 + (double)n2 / 2.0).inRange(this.dx)) {
                return;
            }
        } else {
            this.dy = 0.0;
        }
        if (this.x0 != 0.0) {
            this.dx = this.x0 - (double)dimension.width / 2.0;
            this.dy = this.y0 * this.dx / this.x0;
            if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.y0 - (double)n / 2.0, this.y0 + (double)n / 2.0).inRange(this.dy)) {
                return;
            }
            this.dx = this.x0 + (double)dimension.width / 2.0;
            this.dy = this.y0 * this.dx / this.x0;
            if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.y0 - (double)n / 2.0, this.y0 + (double)n / 2.0).inRange(this.dy)) {
                return;
            }
        } else {
            this.dx = 0.0;
        }
    }

    private void updateToDefaultPosition() {
        if (this.trace != null && this.trace.getHotSampleList().size() > 0) {
            this.currentSnappedSample = this.trace.getHotSampleList().get(this.trace.getHotSampleList().size() / 2);
            this.currentPosition = new Point(this.xAxis.getValuePosition(this.currentSnappedSample.getXValue(), false), this.yAxis.getValuePosition(this.currentSnappedSample.getXValue(), false));
            this.xValue = this.currentSnappedSample.getXValue();
            this.yValue = this.currentSnappedSample.getYValue();
        } else {
            this.currentSnappedSample = null;
            this.xValue = this.xAxis.isLogScaleEnabled() ? Math.pow(10.0, (Math.log10(this.xAxis.getRange().getLower()) + Math.log10(this.xAxis.getRange().getUpper())) / 2.0) : (this.xAxis.getRange().getLower() + this.xAxis.getRange().getUpper()) / 2.0;
            this.yValue = this.yAxis.isLogScaleEnabled() ? Math.pow(10.0, (Math.log10(this.yAxis.getRange().getLower()) + Math.log10(this.yAxis.getRange().getUpper())) / 2.0) : (this.yAxis.getRange().getLower() + this.yAxis.getRange().getUpper()) / 2.0;
            this.currentPosition = new Point(this.xAxis.getValuePosition(this.xValue, false), this.yAxis.getValuePosition(this.yValue, false));
        }
        this.updateInfoLableText(true);
    }

    public void setValues(double d, double d2) {
        this.xValue = d;
        this.yValue = d2;
        this.currentPosition = new Point(this.xAxis.getValuePosition(this.xValue, false), this.yAxis.getValuePosition(this.yValue, false));
        this.updateInfoLableText(true);
    }

    private void updateInfoLableText(boolean bl) {
        String string = "";
        if (this.showName) {
            string = this.name;
        }
        if (this.showSampleInfo && this.currentSnappedSample != null && !this.currentSnappedSample.getInfo().equals("")) {
            string = String.valueOf(string) + "\n" + this.currentSnappedSample.getInfo();
        }
        if (this.showPosition) {
            string = String.valueOf(string) + "\n(" + this.xAxis.format(this.xValue) + ", " + (Double.isNaN(this.yValue) ? "NaN" : this.yAxis.format(this.yValue)) + ")";
        }
        this.infoLabel.setText(string);
        this.knowX0Y0 = !bl;
    }

    private void updateInfoLableText() {
        this.updateInfoLableText(true);
    }

    public void setXAxis(Axis axis) {
        if (this.xAxis == axis) {
            return;
        }
        this.xAxis = axis;
        this.updateToDefaultPosition();
        this.repaint();
    }

    public void setYAxis(Axis axis) {
        if (this.yAxis == axis) {
            return;
        }
        this.yAxis = axis;
        this.updateToDefaultPosition();
        this.repaint();
    }

    public void setName(String string) {
        this.name = string;
        this.updateInfoLableText();
    }

    public void setTrace(Trace trace) {
        if (this.trace == trace) {
            return;
        }
        this.xAxis = trace.getXAxis();
        this.yAxis = trace.getYAxis();
        if (!this.isFree() && this.trace != trace) {
            this.trace.getDataProvider().removeDataProviderListener(this);
        }
        if (this.isFree() || this.trace != trace) {
            this.trace = trace;
            this.updateToDefaultPosition();
        }
        this.trace = trace;
        trace.getDataProvider().addDataProviderListener(this);
        this.repaint();
    }

    public void setFree(Axis axis, Axis axis2) {
        if (this.trace != null) {
            this.trace.getDataProvider().removeDataProviderListener(this);
            this.trace = null;
            this.updateToDefaultPosition();
        }
        this.setXAxis(axis);
        this.setYAxis(axis2);
        this.repaint();
    }

    public boolean isFree() {
        return this.trace == null;
    }

    public void setShowName(boolean bl) {
        this.showName = bl;
        this.updateInfoLableText();
    }

    public void setShowSampleInfo(boolean bl) {
        this.showSampleInfo = bl;
        this.updateInfoLableText();
    }

    public void setShowPosition(boolean bl) {
        this.showPosition = bl;
        this.updateInfoLableText();
    }

    public void setAnnotationColor(Color color) {
        this.annotationColor = color;
        this.infoLabel.setForegroundColor(color);
        this.pointer.setForegroundColor(color);
    }

    public void setAnnotationFont(Font font) {
        this.infoLabel.setFont(font);
    }

    public Font getAnnotationFont() {
        return this.infoLabel.getFont();
    }

    public void setCursorLineStyle(CursorLineStyle cursorLineStyle) {
        this.cursorLineStyle = cursorLineStyle;
    }

    public void setCurrentPosition(Point point, boolean bl) {
        if (bl) {
            int n = this.currentPosition.x - point.x;
            int n2 = this.currentPosition.y - point.y;
            this.x0 += (double)n;
            this.y0 += (double)n2;
            this.knowX0Y0 = true;
            this.updatedxdyFromX0Y0();
        }
        this.currentPosition = point;
        this.xValue = this.xAxis.getPositionValue(point.x, false);
        this.yValue = this.yAxis.getPositionValue(point.y, false);
        this.updateInfoLableText(bl);
        this.repaint();
    }

    public void setCurrentSnappedSample(ISample iSample, boolean bl) {
        if (!this.trace.getHotSampleList().contains(iSample)) {
            this.updateToDefaultPosition();
        } else {
            this.currentSnappedSample = iSample;
            Point point = new Point(this.xAxis.getValuePosition(iSample.getXValue(), false), this.yAxis.getValuePosition(iSample.getYValue(), false));
            this.xValue = iSample.getXValue();
            this.yValue = iSample.getYValue();
            if (Double.isNaN(iSample.getXPlusError())) {
                this.yValue = Double.NaN;
            }
            this.setCurrentPosition(point, bl);
        }
        this.repaint();
    }

    @Override
    public void axisRevalidated(Axis axis) {
        this.currentPosition = new Point(this.xAxis.getValuePosition(this.xValue, false), this.yAxis.getValuePosition(this.yValue, false));
        this.updateInfoLableText();
    }

    @Override
    public void axisRangeChanged(Axis axis, Range range, Range range2) {
    }

    @Override
    public void dataChanged(IDataProvider iDataProvider) {
        if (this.trace == null) {
            return;
        }
        if (this.trace.getHotSampleList().contains(this.currentSnappedSample)) {
            this.currentPosition = new Point(this.xAxis.getValuePosition(this.xValue, false), this.yAxis.getValuePosition(this.yValue, false));
        } else if (this.trace.getHotSampleList().size() > 0) {
            this.updateToDefaultPosition();
            this.pointerDragged = false;
        }
    }

    public void setxyGraph(XYGraph xYGraph) {
        this.xyGraph = xYGraph;
    }

    public void setdxdy(double d, double d2) {
        this.dx = d;
        this.dy = d2;
        this.knowX0Y0 = false;
        this.repaint();
    }

    public void setLocation(double d, double d2) {
        this.xValue = d;
        this.yValue = d2;
        this.repaint();
    }

    public Axis getXAxis() {
        return this.xAxis;
    }

    public Axis getYAxis() {
        return this.yAxis;
    }

    public String getName() {
        return this.name;
    }

    public double getXValue() {
        return this.xValue;
    }

    public double getYValue() {
        return this.yValue;
    }

    public CursorLineStyle getCursorLineStyle() {
        return this.cursorLineStyle;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public boolean isShowName() {
        return this.showName;
    }

    public boolean isShowSampleInfo() {
        return this.showSampleInfo;
    }

    public boolean isShowPosition() {
        return this.showPosition;
    }

    public Color getAnnotationColor() {
        return this.annotationColor;
    }

    public static enum CursorLineStyle {
        NONE(0, "None"),
        UP_DOWN(1, "Up&Down"),
        LEFT_RIGHT(2, "Left&Right"),
        FOUR_DIRECTIONS(3, "Four Directions");

        private int index;
        private String description;

        private CursorLineStyle(int n2, String string2) {
            this.index = n2;
            this.description = string2;
        }

        public String toString() {
            return this.description;
        }

        public static String[] stringValues() {
            String[] stringArray = new String[CursorLineStyle.values().length];
            int n = 0;
            CursorLineStyle[] cursorLineStyleArray = CursorLineStyle.values();
            int n2 = cursorLineStyleArray.length;
            int n3 = 0;
            while (n3 < n2) {
                CursorLineStyle cursorLineStyle = cursorLineStyleArray[n3];
                stringArray[n++] = cursorLineStyle.toString();
                ++n3;
            }
            return stringArray;
        }

        public int getIndex() {
            return this.index;
        }
    }

    class InfoLabelDragger
    extends MouseMotionListener.Stub
    implements MouseListener {
        private MovingAnnotationLabelCommand command;

        InfoLabelDragger() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Annotation.this.x0 = mouseEvent.getLocation().x - ((Annotation)Annotation.this).currentPosition.x;
            Annotation.this.y0 = mouseEvent.getLocation().y - ((Annotation)Annotation.this).currentPosition.y;
            Annotation.this.knowX0Y0 = true;
            Annotation.this.updatedxdyFromX0Y0();
            Annotation.this.repaint();
            mouseEvent.consume();
        }

        public void mouseDoubleClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.command = new MovingAnnotationLabelCommand(Annotation.this);
            this.command.setBeforeMovingDxDy(Annotation.this.dx, Annotation.this.dy);
            Annotation.this.infoLabelArmed = true;
            Annotation.this.repaint();
            mouseEvent.consume();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.command.setAfterMovingDxDy(Annotation.this.dx, Annotation.this.dy);
            Annotation.this.xyGraph.getOperationsManager().addCommand(this.command);
            Annotation.this.infoLabelArmed = false;
            Annotation.this.repaint();
            mouseEvent.consume();
        }
    }

    class Pointer
    extends Figure {
        public Pointer() {
            this.setCursor(Cursors.CROSS);
            PointerDragger pointerDragger = new PointerDragger();
            this.addMouseMotionListener((MouseMotionListener)pointerDragger);
            this.addMouseListener(pointerDragger);
        }

        protected void paintClientArea(Graphics graphics) {
            super.paintClientArea(graphics);
            if (Preferences.useAdvancedGraphics()) {
                graphics.setAntialias(1);
            }
            Rectangle rectangle = this.getClientArea().getCopy().shrink(3, 3);
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
        }

        class PointerDragger
        extends MouseMotionListener.Stub
        implements MouseListener {
            private MovingAnnotationCommand command;

            PointerDragger() {
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (Annotation.this.trace == null) {
                    Annotation.this.setCurrentPosition(mouseEvent.getLocation(), mouseEvent.getState() == 786432);
                } else {
                    ISample iSample = null;
                    double d = Double.POSITIVE_INFINITY;
                    for (ISample iSample2 : Annotation.this.trace.getHotSampleList()) {
                        double d2 = Math.sqrt(Math.pow(Annotation.this.xAxis.getValuePosition(iSample2.getXValue(), false) - mouseEvent.getLocation().x, 2.0) + Math.pow(Annotation.this.yAxis.getValuePosition(iSample2.getYValue(), false) - mouseEvent.getLocation().y, 2.0));
                        if (!(d > d2)) continue;
                        d = d2;
                        iSample = iSample2;
                    }
                    if (iSample != null && Annotation.this.currentSnappedSample != iSample) {
                        Annotation.this.setCurrentSnappedSample(iSample, mouseEvent.getState() == 786432);
                    } else if (iSample == null) {
                        Annotation.this.setCurrentPosition(mouseEvent.getLocation(), mouseEvent.getState() == 786432);
                        Annotation.this.pointerDragged = true;
                    }
                }
                mouseEvent.consume();
            }

            public void mouseDoubleClicked(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.command = new MovingAnnotationCommand(Annotation.this);
                if (Annotation.this.isFree()) {
                    this.command.setBeforeMovePosition(Annotation.this.currentPosition);
                } else {
                    this.command.setBeforeMoveSnappedSample(Annotation.this.currentSnappedSample);
                }
                this.command.setBeforeDxDy(Annotation.this.dx, Annotation.this.dy);
                mouseEvent.consume();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (this.command != null) {
                    if (Annotation.this.isFree()) {
                        this.command.setAfterMovePosition(Annotation.this.currentPosition);
                    } else {
                        this.command.setAfterMoveSnappedSample(Annotation.this.currentSnappedSample);
                    }
                    this.command.setAfterDxDy(Annotation.this.dx, Annotation.this.dy);
                    Annotation.this.xyGraph.getOperationsManager().addCommand(this.command);
                }
            }
        }
    }
}

