/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.dataprovider;

import org.csstudio.swt.xygraph.dataprovider.ISample;

public class Sample
implements ISample {
    private final double xValue;
    private final double yValue;
    private final double xPlusError;
    private final double yPlusError;
    private final double xMinusError;
    private final double yMinusError;
    private final String info;

    public Sample(double d, double d2) {
        this(d, d2, 0.0, 0.0, 0.0, 0.0, "");
    }

    public Sample(double d, double d2, double d3, double d4, double d5, double d6) {
        this(d, d2, d3, d4, d5, d6, "");
    }

    public Sample(double d, double d2, double d3, double d4, double d5, double d6, String string) {
        this.xValue = d;
        this.yValue = d2;
        this.xPlusError = d5;
        this.yPlusError = d3;
        this.xMinusError = d6;
        this.yMinusError = d4;
        this.info = string;
    }

    @Override
    public double getXValue() {
        return this.xValue;
    }

    @Override
    public double getYValue() {
        return this.yValue;
    }

    @Override
    public double getXMinusError() {
        return this.xMinusError;
    }

    @Override
    public double getXPlusError() {
        return this.xPlusError;
    }

    @Override
    public double getYMinusError() {
        return this.yMinusError;
    }

    @Override
    public double getYPlusError() {
        return this.yPlusError;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.info == null ? 0 : this.info.hashCode());
        long l = Double.doubleToLongBits(this.xMinusError);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.xPlusError);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.xValue);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.yMinusError);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.yPlusError);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.yValue);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Sample sample = (Sample)object;
        if (this.info == null ? sample.info != null : !this.info.equals(sample.info)) {
            return false;
        }
        if (Double.doubleToLongBits(this.xMinusError) != Double.doubleToLongBits(sample.xMinusError)) {
            return false;
        }
        if (Double.doubleToLongBits(this.xPlusError) != Double.doubleToLongBits(sample.xPlusError)) {
            return false;
        }
        if (Double.doubleToLongBits(this.xValue) != Double.doubleToLongBits(sample.xValue)) {
            return false;
        }
        if (Double.doubleToLongBits(this.yMinusError) != Double.doubleToLongBits(sample.yMinusError)) {
            return false;
        }
        if (Double.doubleToLongBits(this.yPlusError) != Double.doubleToLongBits(sample.yPlusError)) {
            return false;
        }
        return Double.doubleToLongBits(this.yValue) == Double.doubleToLongBits(sample.yValue);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(this.xValue);
        if (this.xMinusError != 0.0 || this.xPlusError != 0.0) {
            stringBuilder.append(" [-" + this.xMinusError + " ... +" + this.xPlusError + "]");
        }
        stringBuilder.append(", ");
        stringBuilder.append(this.yValue);
        if (this.yMinusError != 0.0 || this.yPlusError != 0.0) {
            stringBuilder.append(" [-" + this.yMinusError + " ... +" + this.yPlusError + "]");
        }
        if (this.info != null && this.info.length() > 0) {
            stringBuilder.append(", '" + this.info + "'");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

