/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.dataprovider;

import java.util.Calendar;
import java.util.Iterator;
import org.csstudio.swt.xygraph.dataprovider.AbstractDataProvider;
import org.csstudio.swt.xygraph.dataprovider.CircularBuffer;
import org.csstudio.swt.xygraph.dataprovider.IDataProviderListener;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.eclipse.swt.widgets.Display;

public class CircularBufferDataProvider
extends AbstractDataProvider {
    private CircularBuffer<ISample> traceData;
    private double currentXData;
    private double currentYData;
    private long currentYDataTimestamp;
    private boolean currentXDataChanged = false;
    private boolean currentYDataChanged = false;
    private boolean currentYDataTimestampChanged = false;
    private double[] currentXDataArray = new double[0];
    private double[] currentYDataArray = new double[0];
    private boolean currentXDataArrayChanged = false;
    private boolean currentYDataArrayChanged = false;
    private boolean xAxisDateEnabled = false;
    private int updateDelay = 0;
    private boolean duringDelay = false;
    private boolean concatenate_data = true;
    private boolean dataRangedirty = false;
    private UpdateMode updateMode = UpdateMode.X_AND_Y;
    private PlotMode plotMode = PlotMode.LAST_N;
    private Runnable fireUpdate;

    public CircularBufferDataProvider(boolean bl) {
        super(bl);
        this.traceData = new CircularBuffer(100);
        this.fireUpdate = new Runnable(){

            @Override
            public void run() {
                for (IDataProviderListener iDataProviderListener : CircularBufferDataProvider.this.listeners) {
                    iDataProviderListener.dataChanged(CircularBufferDataProvider.this);
                }
                CircularBufferDataProvider.this.duringDelay = false;
            }
        };
    }

    public synchronized void setCurrentXData(double d) {
        this.currentXData = d;
        this.currentXDataChanged = true;
        this.tryToAddDataPoint();
    }

    public synchronized void setCurrentYData(double d) {
        this.currentYData = d;
        this.currentYDataChanged = true;
        if (!this.xAxisDateEnabled || this.xAxisDateEnabled && this.currentYDataTimestampChanged) {
            this.tryToAddDataPoint();
        }
    }

    public synchronized void addSample(ISample iSample) {
        if (this.traceData.size() == this.traceData.getBufferSize() && this.plotMode == PlotMode.N_STOP) {
            return;
        }
        this.traceData.add(iSample);
        this.fireDataChange();
    }

    public synchronized void setCurrentYDataTimestamp(long l) {
        if (!this.xAxisDateEnabled) {
            this.clearTrace();
            this.xAxisDateEnabled = true;
        }
        this.currentYDataTimestamp = l;
        this.currentYDataTimestampChanged = true;
        if (this.currentYDataChanged) {
            this.tryToAddDataPoint();
        }
    }

    public synchronized void setCurrentYData(double d, long l) {
        this.xAxisDateEnabled = true;
        this.currentYData = d;
        this.currentYDataChanged = true;
        this.currentYDataTimestamp = l;
        this.currentYDataTimestampChanged = true;
        this.tryToAddDataPoint();
    }

    private void tryToAddDataPoint() {
        if (this.traceData.size() == this.traceData.getBufferSize() && this.plotMode == PlotMode.N_STOP) {
            return;
        }
        switch (this.updateMode) {
            case X_OR_Y: {
                if ((!this.chronological || !this.currentYDataChanged) && (this.chronological || !this.currentXDataChanged && !this.currentYDataChanged)) break;
                this.addDataPoint();
                break;
            }
            case X_AND_Y: {
                if ((!this.chronological || !this.currentYDataChanged) && (this.chronological || !this.currentXDataChanged || !this.currentYDataChanged)) break;
                this.addDataPoint();
                break;
            }
            case X: {
                if ((!this.chronological || !this.currentYDataChanged) && (this.chronological || !this.currentXDataChanged)) break;
                this.addDataPoint();
                break;
            }
            case Y: {
                if (!this.currentYDataChanged) break;
                this.addDataPoint();
                break;
            }
        }
    }

    private void addDataPoint() {
        if (!this.concatenate_data) {
            this.traceData.clear();
        }
        double d = this.chronological ? (this.xAxisDateEnabled ? (this.updateMode != UpdateMode.TRIGGER ? (double)this.currentYDataTimestamp : (double)Calendar.getInstance().getTimeInMillis()) : (this.traceData.size() == 0 ? 0.0 : this.traceData.getTail().getXValue() + 1.0)) : this.currentXData;
        this.traceData.add(new Sample(d, this.currentYData));
        this.currentXDataChanged = false;
        this.currentYDataChanged = false;
        this.currentYDataTimestampChanged = false;
        this.fireDataChange();
    }

    public synchronized void setCurrentXDataArray(double[] dArray) {
        this.currentXDataArray = dArray;
        this.currentXDataArrayChanged = true;
        this.tryToAddDataArray();
    }

    public synchronized void setCurrentYDataArray(double[] dArray) {
        this.currentYDataArray = dArray;
        this.currentYDataArrayChanged = true;
        this.tryToAddDataArray();
    }

    private void tryToAddDataArray() {
        if (this.traceData.size() == this.traceData.getBufferSize() && this.plotMode == PlotMode.N_STOP) {
            return;
        }
        switch (this.updateMode) {
            case X_OR_Y: {
                if ((!this.chronological || !this.currentYDataArrayChanged) && (this.chronological || !this.currentXDataArrayChanged && !this.currentYDataArrayChanged)) break;
                this.addDataArray();
                break;
            }
            case X_AND_Y: {
                if ((!this.chronological || !this.currentYDataArrayChanged) && (this.chronological || !this.currentXDataArrayChanged || !this.currentYDataArrayChanged)) break;
                this.addDataArray();
                break;
            }
            case X: {
                if ((!this.chronological || !this.currentYDataArrayChanged) && (this.chronological || !this.currentXDataArrayChanged)) break;
                this.addDataArray();
                break;
            }
            case Y: {
                if (!this.currentYDataArrayChanged) break;
                this.addDataArray();
                break;
            }
        }
    }

    private void addDataArray() {
        if (!this.concatenate_data) {
            this.traceData.clear();
        }
        if (this.chronological) {
            int n;
            double[] dArray = new double[this.currentYDataArray.length];
            if (this.traceData.size() == 0) {
                n = 0;
                while (n < this.currentYDataArray.length) {
                    dArray[n] = n;
                    ++n;
                }
            } else {
                n = 1;
                while (n < this.currentYDataArray.length + 1) {
                    dArray[n - 1] = this.traceData.getTail().getXValue() + (double)n;
                    ++n;
                }
            }
            n = 0;
            while (n < Math.min(dArray.length, this.currentYDataArray.length)) {
                this.traceData.add(new Sample(dArray[n], this.currentYDataArray[n]));
                ++n;
            }
        } else {
            int n = 0;
            while (n < Math.min(this.traceData.getBufferSize(), Math.min(this.currentXDataArray.length, this.currentYDataArray.length))) {
                this.traceData.add(new Sample(this.currentXDataArray[n], this.currentYDataArray[n]));
                ++n;
            }
        }
        this.currentXDataChanged = false;
        this.currentYDataChanged = false;
        this.currentYDataTimestampChanged = false;
        this.fireDataChange();
    }

    public synchronized void clearTrace() {
        this.traceData.clear();
        this.fireDataChange();
    }

    public Iterator<ISample> iterator() {
        return this.traceData.iterator();
    }

    public synchronized void setBufferSize(int n) {
        this.traceData.setBufferSize(n, false);
    }

    public void setUpdateMode(UpdateMode updateMode) {
        this.updateMode = updateMode;
    }

    public UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public void triggerUpdate() {
        if (this.traceData.size() == 0 && !this.currentYDataChanged && !this.currentYDataArrayChanged) {
            return;
        }
        if (this.currentYDataArray.length > 0) {
            this.addDataArray();
        } else {
            this.addDataPoint();
        }
    }

    @Override
    protected void innerUpdate() {
        this.dataRangedirty = true;
    }

    @Override
    protected void updateDataRange() {
        if (!this.dataRangedirty) {
            return;
        }
        this.dataRangedirty = false;
        if (this.getSize() > 0) {
            double d;
            double d2;
            double d3 = d2 = this.traceData.getHead().getXValue();
            double d4 = d = this.traceData.getHead().getYValue();
            for (ISample iSample : this.traceData) {
                if (d2 > iSample.getXValue() - iSample.getXMinusError()) {
                    d2 = iSample.getXValue() - iSample.getXMinusError();
                }
                if (d3 < iSample.getXValue() + iSample.getXPlusError()) {
                    d3 = iSample.getXValue() + iSample.getXPlusError();
                }
                if (d > iSample.getYValue() - iSample.getYMinusError()) {
                    d = iSample.getYValue() - iSample.getYMinusError();
                }
                if (!(d4 < iSample.getYValue() + iSample.getYPlusError())) continue;
                d4 = iSample.getYValue() + iSample.getYPlusError();
            }
            this.xDataMinMax = new Range(d2, d3);
            this.yDataMinMax = new Range(d, d4);
        } else {
            this.xDataMinMax = null;
            this.yDataMinMax = null;
        }
    }

    public void setPlotMode(PlotMode plotMode) {
        this.plotMode = plotMode;
    }

    @Override
    public ISample getSample(int n) {
        return this.traceData.getElement(n);
    }

    @Override
    public int getSize() {
        return this.traceData.size();
    }

    public void setXAxisDateEnabled(boolean bl) {
        this.xAxisDateEnabled = bl;
    }

    public synchronized void setUpdateDelay(int n) {
        this.updateDelay = n;
    }

    @Override
    protected synchronized void fireDataChange() {
        if (this.updateDelay > 0) {
            this.innerUpdate();
            if (!this.duringDelay) {
                Display.getCurrent().timerExec(this.updateDelay, this.fireUpdate);
                this.duringDelay = true;
            }
        } else {
            super.fireDataChange();
        }
    }

    public void setConcatenate_data(boolean bl) {
        this.concatenate_data = bl;
    }

    public boolean isConcatenate_data() {
        return this.concatenate_data;
    }

    public static enum PlotMode {
        LAST_N("Plot last n pts."),
        N_STOP("Plot n pts & stop.");

        private String description;

        private PlotMode(String string2) {
            this.description = string2;
        }

        public String toString() {
            return this.description;
        }

        public static String[] stringValues() {
            String[] stringArray = new String[PlotMode.values().length];
            int n = 0;
            PlotMode[] plotModeArray = PlotMode.values();
            int n2 = plotModeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                PlotMode plotMode = plotModeArray[n3];
                stringArray[n++] = plotMode.toString();
                ++n3;
            }
            return stringArray;
        }
    }

    public static enum UpdateMode {
        X_OR_Y("X or Y"),
        X_AND_Y("X AND Y"),
        X("X"),
        Y("Y"),
        TRIGGER("Trigger");

        private String description;

        private UpdateMode(String string2) {
            this.description = string2;
        }

        public String toString() {
            return this.description;
        }

        public static String[] stringValues() {
            String[] stringArray = new String[UpdateMode.values().length];
            int n = 0;
            UpdateMode[] updateModeArray = UpdateMode.values();
            int n2 = updateModeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                UpdateMode updateMode = updateModeArray[n3];
                stringArray[n++] = updateMode.toString();
                ++n3;
            }
            return stringArray;
        }
    }
}

