/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.dataprovider;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.Assert;

public class CircularBuffer<T>
extends AbstractCollection<T> {
    private int bufferSize = 0;
    private T[] buffer;
    private int head;
    private int tail;
    private int count;

    public CircularBuffer(int n) {
        Assert.isTrue((n > 0 ? 1 : 0) != 0, (String)"Buffer size must be greater than zero.");
        this.setBufferSize(n, true);
    }

    @Override
    public synchronized boolean add(T t) {
        if (this.tail == this.head && this.count == this.bufferSize) {
            this.buffer[this.tail] = t;
            this.head = (this.head + 1) % this.bufferSize;
            this.tail = (this.tail + 1) % this.bufferSize;
            return true;
        }
        this.buffer[this.tail] = t;
        this.tail = (this.tail + 1) % this.bufferSize;
        ++this.count;
        return true;
    }

    public synchronized T getElement(int n) {
        if (n < this.count) {
            return this.buffer[(this.head + n) % this.bufferSize];
        }
        return null;
    }

    public synchronized T getHead() {
        if (this.count > 0) {
            return this.buffer[this.head];
        }
        return null;
    }

    public synchronized T getTail() {
        if (this.count > 0) {
            return this.buffer[(this.head + this.count - 1) % this.bufferSize];
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        this.head = 0;
        this.tail = 0;
        this.count = 0;
    }

    public synchronized void setBufferSize(int n, boolean bl) {
        assert (n > 0);
        if (this.bufferSize != n) {
            this.bufferSize = n;
            if (bl) {
                this.buffer = new Object[n];
                this.clear();
            } else {
                Object[] objectArray = this.toArray();
                this.buffer = new Object[n];
                int n2 = 0;
                while (n2 < Math.min(n, this.count)) {
                    this.buffer[n2] = objectArray[n2];
                    ++n2;
                }
                this.count = Math.min(n, this.count);
                this.head = 0;
                this.tail = this.count % n;
            }
        }
    }

    public synchronized int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < CircularBuffer.this.count;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return CircularBuffer.this.buffer[(CircularBuffer.this.head + this.index++) % CircularBuffer.this.bufferSize];
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public int size() {
        return this.count;
    }
}

