/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.dataprovider;

import java.util.ArrayList;
import java.util.List;
import org.csstudio.swt.xygraph.dataprovider.IDataProvider;
import org.csstudio.swt.xygraph.dataprovider.IDataProviderListener;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.linearscale.Range;

public abstract class AbstractDataProvider
implements IDataProvider {
    protected boolean chronological = false;
    protected List<IDataProviderListener> listeners;
    protected Range xDataMinMax = null;
    protected Range yDataMinMax = null;

    public AbstractDataProvider(boolean bl) {
        this.chronological = bl;
        this.listeners = new ArrayList<IDataProviderListener>();
    }

    @Override
    public abstract int getSize();

    @Override
    public abstract ISample getSample(int var1);

    protected abstract void innerUpdate();

    protected abstract void updateDataRange();

    @Override
    public synchronized Range getXDataMinMax() {
        if (this.getSize() <= 0) {
            return null;
        }
        this.updateDataRange();
        return this.xDataMinMax;
    }

    @Override
    public synchronized Range getYDataMinMax() {
        if (this.getSize() <= 0) {
            return null;
        }
        this.updateDataRange();
        return this.yDataMinMax;
    }

    public void setChronological(boolean bl) {
        this.chronological = bl;
    }

    @Override
    public boolean isChronological() {
        return this.chronological;
    }

    @Override
    public void addDataProviderListener(IDataProviderListener iDataProviderListener) {
        if (this.listeners.contains(iDataProviderListener)) {
            return;
        }
        this.listeners.add(iDataProviderListener);
    }

    @Override
    public boolean removeDataProviderListener(IDataProviderListener iDataProviderListener) {
        return this.listeners.remove(iDataProviderListener);
    }

    protected void fireDataChange() {
        this.innerUpdate();
        for (IDataProviderListener iDataProviderListener : this.listeners) {
            iDataProviderListener.dataChanged(this);
        }
    }
}

