/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.ui.utils;

import com.isencia.passerelle.workbench.model.ui.activator.Activator;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.runtime.Log;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;

public class EclipseUtils {
    private static final Pattern UNIQUE_PATTERN = Pattern.compile("(.+)(\\d+)", 2);

    public static void logError(Exception exception, String string, int n) {
        Status status = null;
        status = exception != null ? new Status(n, "com.isencia.passerelle.workbench.model.ui", string, (Throwable)exception) : new Status(n, "com.isencia.passerelle.workbench.model.ui", string);
        Log log = (Log)Activator.getDefault().getLog();
        log.log((IStatus)status);
    }

    public static URI getFileURI(IEditorInput iEditorInput) {
        if (iEditorInput instanceof IURIEditorInput) {
            URI uRI = ((IURIEditorInput)iEditorInput).getURI();
            return uRI;
        }
        return null;
    }

    public static File getFile(IEditorInput iEditorInput) {
        return new File(EclipseUtils.getFileURI(iEditorInput));
    }

    public static String getFilePath(IEditorInput iEditorInput) {
        return EclipseUtils.getFile(iEditorInput).getAbsolutePath();
    }

    private static boolean isWindowsOS() {
        return System.getProperty("os.name").indexOf("Windows") == 0;
    }

    public static IFile getIFile(IEditorInput iEditorInput) {
        if (iEditorInput instanceof FileEditorInput) {
            return ((FileEditorInput)iEditorInput).getFile();
        }
        return (IFile)iEditorInput.getAdapter(IFile.class);
    }

    public static String getFileName(IEditorInput iEditorInput) {
        return EclipseUtils.getFile(iEditorInput).getName();
    }

    public static URL getAbsoluteUrl(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if (uRL.toString().startsWith("bundle")) {
            try {
                return FileLocator.resolve((URL)uRL);
            }
            catch (IOException iOException) {
                return uRL;
            }
        }
        return uRL;
    }

    public static IWorkbenchPage getPage() {
        IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
        if (iWorkbenchPage != null) {
            return iWorkbenchPage;
        }
        return EclipseUtils.getDefaultPage();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench == null) {
            return null;
        }
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        return iWorkbenchWindow.getActivePage();
    }

    public static IWorkbenchPage getDefaultPage() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench == null) {
            return null;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        if (iWorkbenchWindowArray == null) {
            return null;
        }
        return iWorkbenchWindowArray[0].getActivePage();
    }

    public static void addBuilderToProject(IProject iProject, String string) throws CoreException {
        if (!iProject.isOpen()) {
            return;
        }
        IProjectDescription iProjectDescription = iProject.getDescription();
        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
        int n = 0;
        while (n < iCommandArray.length) {
            if (iCommandArray[n].getBuilderName().equals(string)) {
                return;
            }
            ++n;
        }
        ICommand iCommand = iProjectDescription.newCommand();
        iCommand.setBuilderName(string);
        ArrayList<ICommand> arrayList = new ArrayList<ICommand>(iCommandArray.length + 1);
        arrayList.addAll(Arrays.asList(iCommandArray));
        arrayList.add(iCommand);
        iProjectDescription.setBuildSpec(arrayList.toArray(new ICommand[arrayList.size()]));
        iProject.setDescription(iProjectDescription, null);
    }

    public static boolean isActivePerspective(String string) {
        IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
        if (iWorkbenchPage == null) {
            return false;
        }
        try {
            return string.equals(iWorkbenchPage.getPerspective().getId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void delay(long l) {
        Display display = Display.getCurrent();
        if (display != null) {
            long l2 = System.currentTimeMillis() + l;
            while (System.currentTimeMillis() < l2) {
                try {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                catch (Exception exception) {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {}
                    break;
                }
            }
            display.update();
        } else {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static IFile getUniqueFile(IFile iFile, String string) {
        String string2 = iFile.getName();
        Matcher matcher = Pattern.compile("(.+)(\\d+)\\." + string, 2).matcher(string2);
        int n = 0;
        String string3 = string2.substring(0, string2.lastIndexOf("."));
        if (matcher.matches()) {
            string3 = matcher.group(1);
            n = Integer.parseInt(matcher.group(2));
        }
        return EclipseUtils.getUniqueFile(iFile.getParent(), string3, ++n, string);
    }

    private static IFile getUniqueFile(IContainer iContainer, String string, int n, String string2) {
        IFile iFile;
        if (iContainer instanceof IFolder) {
            iFile = ((IFolder)iContainer).getFile(String.valueOf(string) + n + "." + string2);
        } else if (iContainer instanceof IProject) {
            iFile = ((IProject)iContainer).getFile(String.valueOf(string) + n + "." + string2);
        } else {
            throw new RuntimeException("The parent is neither a project nor a folder.");
        }
        if (!iFile.exists()) {
            return iFile;
        }
        return EclipseUtils.getUniqueFile(iContainer, string, ++n, string2);
    }

    public static String getUnique(IResource iResource) {
        String string;
        String string2 = iResource.getName();
        Matcher matcher = UNIQUE_PATTERN.matcher(string2);
        int n = 0;
        String string3 = string = string2.indexOf(".") > -1 ? string2.substring(0, string2.lastIndexOf(".")) : string2;
        if (matcher.matches()) {
            string = matcher.group(1);
            n = Integer.parseInt(matcher.group(2));
        }
        return EclipseUtils.getUnique(iResource.getParent(), string, ++n);
    }

    private static String getUnique(IContainer iContainer, String string, int n) {
        IFolder iFolder;
        IFile iFile;
        if (iContainer instanceof IFolder) {
            iFile = ((IFolder)iContainer).getFile(String.valueOf(string) + n);
            iFolder = ((IFolder)iContainer).getFolder(String.valueOf(string) + n);
        } else if (iContainer instanceof IProject) {
            iFile = ((IProject)iContainer).getFile(String.valueOf(string) + n);
            iFolder = ((IProject)iContainer).getFolder(String.valueOf(string) + n);
        } else {
            throw new RuntimeException("The parent is niether a project nor a folder.");
        }
        if (!iFile.exists() && !iFolder.exists()) {
            return iFile.getName();
        }
        return EclipseUtils.getUnique(iContainer, string, ++n);
    }

    public static Object getAdapter(Object object, Class<?> clazz) {
        Assert.isNotNull(clazz);
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return object;
        }
        return ResourceUtil.getAdapter((Object)object, clazz, (boolean)true);
    }

    public static IEditorPart openExternalEditor(String string) throws PartInitException {
        return EclipseUtils.openExternalEditor(new File(string));
    }

    public static IEditorPart openExternalEditor(File file) throws PartInitException {
        IEditorDescriptor iEditorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getAbsolutePath());
        return EclipseUtils.openExternalEditor(file, iEditorDescriptor.getId());
    }

    public static IEditorPart openExternalEditor(File file, String string) throws PartInitException {
        IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
        IFileStore iFileStore = EFS.getLocalFileSystem().fromLocalFile(file);
        return iWorkbenchPage.openEditor((IEditorInput)new FileStoreEditorInput(iFileStore), string);
    }

    public static IEditorPart openEditor(IFile iFile) throws PartInitException {
        IEditorDescriptor iEditorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(iFile.getName());
        if (iEditorDescriptor == null) {
            iEditorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(String.valueOf(iFile.getName()) + ".txt");
        }
        return EclipseUtils.openEditor(iFile, iEditorDescriptor.getId());
    }

    public static IEditorPart openEditor(IFile iFile, String string) throws PartInitException {
        IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
        return iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), string);
    }
}

