/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.ui.command;

import com.isencia.passerelle.workbench.model.utils.ModelChangeRequest;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import org.eclipse.gef.commands.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.NamedObj;

public class SetConstraintCommand
extends Command {
    private static final String Command_Label_Location = "change location command";
    private static final Logger logger = LoggerFactory.getLogger(SetConstraintCommand.class);
    private double[] newPos;
    private double[] oldPos;
    private NamedObj model;

    public Logger getLogger() {
        return logger;
    }

    public void execute() {
        this.doExecute();
    }

    public boolean canExecute() {
        this.oldPos = ModelUtils.getLocation((NamedObj)this.model);
        return this.newPos != null && !this.newPos.equals(this.oldPos);
    }

    public void doExecute() {
        if (this.model == null) {
            return;
        }
        this.model.requestChange((ChangeRequest)new ModelChangeRequest(((Object)((Object)this)).getClass(), this.model, "setLocation"){

            protected void _execute() throws Exception {
                SetConstraintCommand.this.oldPos = (double[])ModelUtils.getLocation((NamedObj)SetConstraintCommand.this.model).clone();
                ModelUtils.setLocation((NamedObj)SetConstraintCommand.this.model, (double[])SetConstraintCommand.this.newPos);
            }
        });
    }

    public String getLabel() {
        return Command_Label_Location;
    }

    public void redo() {
        if (this.canExecute()) {
            this.doExecute();
        }
    }

    public void undo() {
        this.model.requestChange((ChangeRequest)new ModelChangeRequest(((Object)((Object)this)).getClass(), this.model, "refresh"){

            protected void _execute() throws Exception {
                ModelUtils.setLocation((NamedObj)SetConstraintCommand.this.model, (double[])SetConstraintCommand.this.oldPos);
            }
        });
    }

    public boolean canUndo() {
        return this.oldPos != null;
    }

    public void setLocation(double[] dArray) {
        this.newPos = dArray;
    }

    public void setModel(NamedObj namedObj) {
        this.model = namedObj;
    }
}

