/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.ui.command;

import com.isencia.passerelle.workbench.model.ui.IPasserelleMultiPageEditor;
import com.isencia.passerelle.workbench.model.ui.VertexLink;
import com.isencia.passerelle.workbench.model.ui.command.CreateConnectionCommand;
import com.isencia.passerelle.workbench.model.ui.command.DeleteConnectionCommand;
import com.isencia.passerelle.workbench.model.ui.command.DeleteVertexConnectionCommand;
import com.isencia.passerelle.workbench.model.utils.ModelChangeRequest;
import org.eclipse.gef.commands.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.TypedIORelation;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.Vertex;

public class ReConnectCommand
extends Command {
    private static final Logger logger = LoggerFactory.getLogger(ReConnectCommand.class);
    private IPasserelleMultiPageEditor editor;
    private ComponentRelation connection;
    private VertexLink vertexLink;
    protected NamedObj source;
    protected NamedObj newSource;
    protected NamedObj newTarget;
    protected NamedObj target;
    private CompositeEntity parent;
    private Command delCommand;
    private CreateConnectionCommand conCommand;

    public boolean canExecute() {
        return (this.source != null && this.target != null || this.vertexLink != null) && (this.newTarget != null || this.newSource != null);
    }

    public VertexLink getVertexLink() {
        return this.vertexLink;
    }

    public void setVertexLink(VertexLink vertexLink) {
        this.vertexLink = vertexLink;
    }

    public IPasserelleMultiPageEditor getEditor() {
        return this.editor;
    }

    public void setEditor(IPasserelleMultiPageEditor iPasserelleMultiPageEditor) {
        this.editor = iPasserelleMultiPageEditor;
    }

    public NamedObj getSource() {
        return this.source;
    }

    public void setSource(NamedObj namedObj) {
        this.source = namedObj;
    }

    public NamedObj getTarget() {
        return this.target;
    }

    public void setTarget(NamedObj namedObj) {
        this.target = namedObj;
    }

    public NamedObj getNewSource() {
        return this.newSource;
    }

    public void setNewSource(NamedObj namedObj) {
        this.newSource = namedObj;
    }

    public NamedObj getNewTarget() {
        return this.newTarget;
    }

    public void setNewTarget(NamedObj namedObj) {
        this.newTarget = namedObj;
    }

    public ReConnectCommand() {
        super("Reconnect");
    }

    public Logger getLogger() {
        return logger;
    }

    public void execute() {
        this.doExecute();
    }

    protected void doExecute() {
        this.parent.requestChange((ChangeRequest)new ModelChangeRequest(((Object)((Object)this)).getClass(), this.connection, "reconnect"){

            protected void _execute() throws Exception {
                Vertex vertex;
                Command command;
                if (ReConnectCommand.this.vertexLink == null) {
                    ReConnectCommand.this.delCommand = new DeleteConnectionCommand();
                    command = (DeleteConnectionCommand)ReConnectCommand.this.delCommand;
                    command.setParent(ReConnectCommand.this.parent);
                    command.setConnection((TypedIORelation)ReConnectCommand.this.connection);
                } else {
                    Vertex vertex2;
                    ReConnectCommand.this.delCommand = new DeleteVertexConnectionCommand();
                    command = (DeleteVertexConnectionCommand)ReConnectCommand.this.delCommand;
                    command.setParent(ReConnectCommand.this.parent);
                    command.setConnection((TypedIORelation)ReConnectCommand.this.vertexLink.getRelation());
                    vertex = ReConnectCommand.this.vertexLink.getSourceVertex();
                    if (vertex != null) {
                        command.setVertex(vertex);
                    }
                    if ((vertex2 = ReConnectCommand.this.vertexLink.getTargetVertex()) != null) {
                        command.setVertex(vertex2);
                    }
                    command.setPort(ReConnectCommand.this.vertexLink.getPort());
                }
                ReConnectCommand.this.delCommand.execute();
                command = new CreateConnectionCommand(ReConnectCommand.this.editor);
                command.setContainer(ReConnectCommand.this.parent);
                if (ReConnectCommand.this.newTarget != null) {
                    if (ReConnectCommand.this.source != null) {
                        command.setSource(ReConnectCommand.this.source);
                    } else {
                        vertex = ReConnectCommand.this.vertexLink.getSourceVertex();
                        if (vertex != null) {
                            command.setSource((NamedObj)vertex);
                        } else {
                            command.setSource((NamedObj)ReConnectCommand.this.vertexLink.getPort());
                        }
                    }
                    command.setTarget(ReConnectCommand.this.newTarget);
                } else {
                    if (ReConnectCommand.this.target != null) {
                        command.setTarget(ReConnectCommand.this.target);
                    } else {
                        vertex = ReConnectCommand.this.vertexLink.getTargetVertex();
                        if (vertex != null) {
                            command.setTarget((NamedObj)vertex);
                        } else {
                            command.setTarget((NamedObj)ReConnectCommand.this.vertexLink.getPort());
                        }
                    }
                    command.setSource(ReConnectCommand.this.newSource);
                }
                command.execute();
            }
        });
    }

    public void redo() {
        this.doExecute();
    }

    public void setConnection(TypedIORelation typedIORelation) {
        this.connection = typedIORelation;
    }

    public void setParent(CompositeEntity compositeEntity) {
        this.parent = compositeEntity;
    }

    public void undo() {
        this.parent.requestChange((ChangeRequest)new ModelChangeRequest(((Object)((Object)this)).getClass(), this.connection, "undo-reconnect"){

            protected void _execute() throws Exception {
                ReConnectCommand.this.conCommand.undo();
                ReConnectCommand.this.delCommand.undo();
            }
        });
    }
}

