/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.ui.command;

import com.isencia.passerelle.workbench.model.ui.IPasserelleMultiPageEditor;
import com.isencia.passerelle.workbench.model.ui.command.IRefreshConnections;
import com.isencia.passerelle.workbench.model.ui.utils.EclipseUtils;
import com.isencia.passerelle.workbench.model.utils.ModelChangeRequest;
import org.eclipse.gef.commands.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.TypedIORelation;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.Vertex;

public class CreateConnectionCommand
extends Command
implements IRefreshConnections {
    private IPasserelleMultiPageEditor editor;
    private static final Logger logger = LoggerFactory.getLogger(CreateConnectionCommand.class);
    protected NamedObj container;
    protected TypedIORelation connection;
    protected NamedObj source;
    protected NamedObj target;

    public CreateConnectionCommand(NamedObj namedObj, NamedObj namedObj2, IPasserelleMultiPageEditor iPasserelleMultiPageEditor) {
        this.source = namedObj;
        this.target = namedObj2;
        this.editor = iPasserelleMultiPageEditor;
    }

    public CreateConnectionCommand(IPasserelleMultiPageEditor iPasserelleMultiPageEditor) {
        this.editor = iPasserelleMultiPageEditor;
    }

    public Logger getLogger() {
        return logger;
    }

    public void setContainer(CompositeEntity compositeEntity) {
        this.container = compositeEntity;
    }

    public boolean canExecute() {
        return this.source != null && this.target != null;
    }

    public void execute() {
        this.doExecute();
    }

    public void doExecute() {
        if (this.source != null && this.target != null) {
            NamedObj namedObj = this.getContainer(this.source, this.target);
            if (namedObj != null) {
                this.container = namedObj;
            }
            if (this.container == null) {
                return;
            }
            this.container.requestChange((ChangeRequest)new ModelChangeRequest(this.getClass(), this.container, "connection"){

                protected void _execute() throws Exception {
                    try {
                        if (CreateConnectionCommand.this.source instanceof ComponentPort && CreateConnectionCommand.this.target instanceof ComponentPort) {
                            CreateConnectionCommand.this.connection = (TypedIORelation)((CompositeEntity)CreateConnectionCommand.this.container).connect((ComponentPort)CreateConnectionCommand.this.source, (ComponentPort)CreateConnectionCommand.this.target);
                        }
                        if (CreateConnectionCommand.this.source instanceof Vertex && CreateConnectionCommand.this.target instanceof ComponentPort) {
                            ((ComponentPort)CreateConnectionCommand.this.target).link((Relation)((Vertex)CreateConnectionCommand.this.source).getContainer());
                        }
                        if (CreateConnectionCommand.this.target instanceof Vertex && CreateConnectionCommand.this.source instanceof ComponentPort) {
                            ((ComponentPort)CreateConnectionCommand.this.source).link((Relation)((Vertex)CreateConnectionCommand.this.target).getContainer());
                        }
                        if (CreateConnectionCommand.this.target instanceof Vertex && CreateConnectionCommand.this.source instanceof Vertex) {
                            ((TypedIORelation)((Vertex)CreateConnectionCommand.this.source).getContainer()).link((Relation)((TypedIORelation)((Vertex)CreateConnectionCommand.this.target).getContainer()));
                        }
                    }
                    catch (Exception exception) {
                        logger.error("Unable to create connection", (Throwable)exception);
                        EclipseUtils.logError(exception, "Unable to create connection", 4);
                    }
                }
            });
        }
    }

    private NamedObj getContainer(NamedObj namedObj, NamedObj namedObj2) {
        if (this.editor != null && (namedObj instanceof TypedIOPort || namedObj2 instanceof TypedIOPort)) {
            return this.editor.getSelectedPage().getContainer();
        }
        return namedObj.getContainer();
    }

    public String getLabel() {
        return "";
    }

    public NamedObj getSource() {
        return this.source;
    }

    public NamedObj getTarget() {
        return this.target;
    }

    public void redo() {
        this.doExecute();
    }

    public void setSource(NamedObj namedObj) {
        this.source = namedObj;
    }

    public void setTarget(NamedObj namedObj) {
        this.target = namedObj;
    }

    public void undo() {
        if (this.connection != null) {
            this.container.requestChange((ChangeRequest)new ModelChangeRequest(this.getClass(), this.container, "connection"){

                protected void _execute() throws Exception {
                    CreateConnectionCommand.this.connection.setContainer(null);
                }
            });
        }
    }
}

