/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.ui.command;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.model.Flow;
import com.isencia.passerelle.workbench.model.ui.ComponentUtility;
import com.isencia.passerelle.workbench.model.ui.IPasserelleMultiPageEditor;
import com.isencia.passerelle.workbench.model.ui.utils.EclipseUtils;
import com.isencia.passerelle.workbench.model.utils.ModelChangeRequest;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.TypedIORelation;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.Vertex;
import ptolemy.vergil.kernel.attributes.TextAttribute;

public class CreateComponentCommand
extends Command {
    private static final String DEFAULT_OUTPUT_PORT = "OutputPort";
    private static final String DEFAULT_INPUT_PORT = "InputPort";
    private static Logger logger = LoggerFactory.getLogger(CreateComponentCommand.class);
    private Class<? extends NamedObj> clazz;
    private String name;
    private Flow flow;
    private NamedObj model;
    private NamedObj parent;
    private NamedObj child;
    private IPasserelleMultiPageEditor editor;
    private double[] location;
    private Map<Object, Object> defaultValueMap;

    public Flow getFlow() {
        return this.flow;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public NamedObj getChild() {
        return this.child;
    }

    public CreateComponentCommand(IPasserelleMultiPageEditor iPasserelleMultiPageEditor) {
        super("CreateComponent");
        this.editor = iPasserelleMultiPageEditor;
    }

    public void setModel(NamedObj namedObj) {
        this.model = namedObj;
    }

    public Logger getLogger() {
        return logger;
    }

    public boolean canExecute() {
        if (("com.isencia.passerelle.actor.general.InputIOPort".equals(this.clazz) || "com.isencia.passerelle.actor.general.OutputIOPort".equals(this.clazz)) && this.parent != null && this.parent.getContainer() == null) {
            return false;
        }
        return this.clazz != null && this.parent != null;
    }

    public void execute() {
        this.doExecute();
    }

    public void doExecute() {
        this.parent.requestChange((ChangeRequest)new ModelChangeRequest(((Object)((Object)this)).getClass(), this.parent, "create"){

            protected void _execute() throws Exception {
                try {
                    CompositeEntity compositeEntity = (CompositeEntity)CreateComponentCommand.this.parent;
                    String string = null;
                    if (CreateComponentCommand.this.model == null) {
                        string = ModelUtils.findUniqueName((CompositeEntity)compositeEntity, (Class)CreateComponentCommand.this.clazz, (String)CreateComponentCommand.this.name, (String)CreateComponentCommand.this.name);
                        string = ModelUtils.getLegalName((String)string);
                        if (Vertex.class.isAssignableFrom(CreateComponentCommand.this.clazz)) {
                            TypedIORelation typedIORelation = new TypedIORelation(compositeEntity, string);
                            CreateComponentCommand.this.child = (NamedObj)new Vertex((Relation)typedIORelation, "Vertex");
                        } else if (Flow.class.isAssignableFrom(CreateComponentCommand.this.clazz)) {
                            if (CreateComponentCommand.this.flow != null) {
                                CreateComponentCommand.this.child = (NamedObj)CreateComponentCommand.this.flow.instantiate((NamedObj)compositeEntity, string);
                                ((CompositeActor)CreateComponentCommand.this.child).setClassName(CreateComponentCommand.this.flow.getName());
                            }
                        } else {
                            Class<CompositeEntity> clazz = CompositeEntity.class;
                            if (TypedIOPort.class.isAssignableFrom(CreateComponentCommand.this.clazz)) {
                                clazz = ComponentEntity.class;
                            } else if (TextAttribute.class.isAssignableFrom(CreateComponentCommand.this.clazz)) {
                                clazz = NamedObj.class;
                            }
                            Constructor constructor = CreateComponentCommand.this.clazz.getConstructor(clazz, String.class);
                            CreateComponentCommand.this.child = (NamedObj)constructor.newInstance(compositeEntity, string);
                            if (CreateComponentCommand.this.child instanceof TypedIOPort) {
                                boolean bl = CreateComponentCommand.this.name.equalsIgnoreCase("INPUT") || CreateComponentCommand.this.clazz.getName().toLowerCase().endsWith(".input");
                                ((TypedIOPort)CreateComponentCommand.this.child).setInput(bl);
                                ((TypedIOPort)CreateComponentCommand.this.child).setOutput(!bl);
                            }
                        }
                    } else {
                        string = ModelUtils.findUniqueName((CompositeEntity)compositeEntity, CreateComponentCommand.this.model.getClass(), (String)CreateComponentCommand.this.name, (String)CreateComponentCommand.this.name);
                        string = ModelUtils.getLegalName((String)string);
                        if (Vertex.class.isAssignableFrom(CreateComponentCommand.this.model.getClass())) {
                            TypedIORelation typedIORelation = new TypedIORelation(compositeEntity, string);
                            CreateComponentCommand.this.child = (NamedObj)new Vertex((Relation)typedIORelation, "Vertex");
                        } else {
                            CreateComponentCommand.this.child = (NamedObj)CreateComponentCommand.this.model.clone(compositeEntity.workspace());
                            CreateComponentCommand.this.child.setName(string);
                        }
                        ComponentUtility.setContainer(CreateComponentCommand.this.child, (NamedObj)compositeEntity);
                    }
                    CreateComponentCommand.this.createDefaultValues(CreateComponentCommand.this.child);
                    if (CreateComponentCommand.this.location != null) {
                        ModelUtils.setLocation((NamedObj)CreateComponentCommand.this.child, (double[])CreateComponentCommand.this.location);
                    }
                    this.setChild(CreateComponentCommand.this.child);
                }
                catch (Exception exception) {
                    logger.error("Unable to create component", (Throwable)exception);
                    EclipseUtils.logError(exception, "Unable to create component", 4);
                }
            }
        });
    }

    public void redo() {
        this.parent.requestChange((ChangeRequest)new ModelChangeRequest(((Object)((Object)this)).getClass(), this.parent, "create"){

            protected void _execute() throws Exception {
                CreateComponentCommand.this.editor.selectPage((CompositeActor)CreateComponentCommand.this.parent);
                if (CreateComponentCommand.this.child instanceof NamedObj) {
                    ComponentUtility.setContainer(CreateComponentCommand.this.child, CreateComponentCommand.this.parent);
                }
            }
        });
    }

    public void setClazz(Class<? extends NamedObj> clazz) {
        this.clazz = clazz;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setParent(NamedObj namedObj) {
        this.parent = namedObj;
    }

    public void undo() {
        this.parent.requestChange((ChangeRequest)new ModelChangeRequest(((Object)((Object)this)).getClass(), this.parent, "create"){

            protected void _execute() throws Exception {
                CreateComponentCommand.this.editor.selectPage((CompositeActor)CreateComponentCommand.this.parent);
                if (CreateComponentCommand.this.child instanceof NamedObj) {
                    ComponentUtility.setContainer(CreateComponentCommand.this.child, null);
                }
            }
        });
    }

    public double[] getLocation() {
        return this.location;
    }

    public void setLocation(double[] dArray) {
        this.location = dArray;
    }

    public void addConfigurableParameterValue(Object object, Object object2) {
        if (this.defaultValueMap == null) {
            this.defaultValueMap = new LinkedHashMap<Object, Object>(3);
        }
        this.defaultValueMap.put(object, object2);
    }

    private void createDefaultValues(NamedObj namedObj) throws Exception {
        if (this.defaultValueMap == null) {
            return;
        }
        if (namedObj instanceof Actor) {
            Actor actor = (Actor)namedObj;
            for (Object object : this.defaultValueMap.keySet()) {
                Object object2;
                Parameter parameter = null;
                if (object instanceof Class) {
                    object2 = actor.getConfigurableParameter((Class)object);
                    parameter = object2 != null && !object2.isEmpty() && object2.size() == 1 ? (Parameter)object2.iterator().next() : null;
                } else if (object instanceof String) {
                    parameter = actor.getConfigurableParameter((String)object);
                }
                if (parameter == null) continue;
                object2 = this.defaultValueMap.get(object);
                if (object2 instanceof Boolean) {
                    parameter.setToken((Token)new BooleanToken(((Boolean)object2).booleanValue()));
                    continue;
                }
                if (!(object2 instanceof String)) continue;
                parameter.setExpression((String)object2);
            }
        }
    }
}

