/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.ui;

import com.isencia.passerelle.workbench.model.ui.command.DeleteConnectionCommand;
import com.isencia.passerelle.workbench.model.ui.command.DeleteVertexConnectionCommand;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.commands.Command;
import ptolemy.actor.Actor;
import ptolemy.actor.IOPort;
import ptolemy.actor.IORelation;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.TypedIORelation;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.vergil.kernel.attributes.TextAttribute;

public abstract class ComponentUtility {
    public static void setContainer(NamedObj namedObj, NamedObj namedObj2) {
        try {
            if (namedObj instanceof ComponentEntity) {
                ((ComponentEntity)namedObj).setContainer((CompositeEntity)namedObj2);
            } else if (namedObj instanceof TextAttribute) {
                ((TextAttribute)namedObj).setContainer((NamedObj)((CompositeEntity)namedObj2));
            } else if (namedObj instanceof TypedIOPort) {
                ((TypedIOPort)namedObj).setContainer((Entity)((CompositeEntity)namedObj2));
            }
        }
        catch (IllegalActionException illegalActionException) {
            illegalActionException.printStackTrace();
        }
        catch (NameDuplicationException nameDuplicationException) {
            nameDuplicationException.printStackTrace();
        }
    }

    public static List<Command> deleteConnections(NamedObj namedObj) {
        Command command;
        Object object;
        ArrayList<Command> arrayList = new ArrayList<Command>();
        if (!(namedObj instanceof Actor) && !(namedObj instanceof Port)) {
            return arrayList;
        }
        Iterator iterator = ModelUtils.getConnectedRelations((Nameable)namedObj, (ModelUtils.ConnectionType)ModelUtils.ConnectionType.SOURCE, (boolean)true).iterator();
        while (iterator.hasNext()) {
            object = ComponentUtility.generateDeleteCommand(namedObj, (IORelation)iterator.next());
            Command command2 = object.iterator();
            while (command2.hasNext()) {
                command = (Command)command2.next();
                command.execute();
                arrayList.add(command);
            }
        }
        object = ModelUtils.getConnectedRelations((Nameable)namedObj, (ModelUtils.ConnectionType)ModelUtils.ConnectionType.TARGET, (boolean)true).iterator();
        while (object.hasNext()) {
            command = ComponentUtility.generateDeleteCommand(namedObj, (IORelation)object.next());
            for (Command command2 : command) {
                command2.execute();
                arrayList.add(command2);
            }
        }
        return arrayList;
    }

    private static List<Command> generateDeleteCommand(NamedObj namedObj, IORelation iORelation) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        if (!ModelUtils.containsVertex((Relation)iORelation)) {
            arrayList.add(ComponentUtility.generateDeleteConnectionCommand((Nameable)namedObj, iORelation));
        } else {
            for (IOPort iOPort : ModelUtils.getPorts((Relation)iORelation, (NamedObj)namedObj)) {
                arrayList.add(ComponentUtility.generateDeleteVertexConnectionCommand((Nameable)namedObj, iORelation, (Port)iOPort));
            }
        }
        return arrayList;
    }

    private static DeleteConnectionCommand generateDeleteConnectionCommand(Nameable nameable, IORelation iORelation) {
        DeleteConnectionCommand deleteConnectionCommand = new DeleteConnectionCommand();
        deleteConnectionCommand.setParent((CompositeEntity)nameable.getContainer());
        deleteConnectionCommand.setConnection((TypedIORelation)iORelation);
        deleteConnectionCommand.setLinkedPorts(((TypedIORelation)iORelation).linkedPortList());
        return deleteConnectionCommand;
    }

    private static DeleteVertexConnectionCommand generateDeleteVertexConnectionCommand(Nameable nameable, IORelation iORelation, Port port) {
        DeleteVertexConnectionCommand deleteVertexConnectionCommand = new DeleteVertexConnectionCommand();
        deleteVertexConnectionCommand.setParent((CompositeEntity)nameable.getContainer());
        deleteVertexConnectionCommand.setConnection((TypedIORelation)iORelation);
        deleteVertexConnectionCommand.setPort((IOPort)port);
        return deleteVertexConnectionCommand;
    }
}

