/*
 * Decompiled with CFR 0.152.
 */
package org.edna.pydev.extensions.utils;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dawb.common.python.PythonUtils;
import org.dawb.common.util.eclipse.BundleUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.edna.pydev.extensions.utils.LibsLocationFinder;
import org.python.copiedfromeclipsesrc.JavaVmLocationFinder;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.REF;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.interpreters.JythonInterpreterManager;
import org.python.pydev.ui.interpreters.PythonInterpreterManager;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreterUtils {
    private static Logger logger = LoggerFactory.getLogger(InterpreterUtils.class);

    public static void createPythonInterpreter(String string, IProgressMonitor iProgressMonitor) throws Exception {
        String string2 = PythonUtils.getProbablePythonPath();
        if (string2 != null) {
            InterpreterUtils.createPythonInterpreter(string, string2, iProgressMonitor);
        }
    }

    public static void createPythonInterpreter(String string, String string2, IProgressMonitor iProgressMonitor) throws Exception {
        if (!InterpreterUtils.isPythonInterpreter(string, iProgressMonitor)) {
            PythonInterpreterManager pythonInterpreterManager = (PythonInterpreterManager)PydevPlugin.getPythonInterpreterManager();
            IInterpreterInfo iInterpreterInfo = pythonInterpreterManager.createInterpreterInfo(string2, iProgressMonitor, false);
            iInterpreterInfo.setName(string);
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add(string);
            pythonInterpreterManager.setInfos(new IInterpreterInfo[]{iInterpreterInfo}, hashSet, iProgressMonitor);
            PydevPlugin.getWorkspace().save(true, iProgressMonitor);
            logger.info("Workspace saved with interpreter: " + string);
        }
    }

    private static boolean isPythonInterpreter(String string, IProgressMonitor iProgressMonitor) {
        try {
            return PydevPlugin.getPythonInterpreterManager().getInterpreterInfo(string, iProgressMonitor) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isJythonInterpreter(String string, IProgressMonitor iProgressMonitor) {
        try {
            return PydevPlugin.getJythonInterpreterManager().getInterpreterInfo(string, iProgressMonitor) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void createJythonInterpreter(String string, IProgressMonitor iProgressMonitor) throws Exception {
        if (!InterpreterUtils.isJythonInterpreter(string, iProgressMonitor)) {
            Object object2;
            File file = BundleUtils.getBundleLocation((String)"uk.ac.gda.libs");
            File file2 = new File(file, "jython2.5.1");
            File file3 = new File(file2, "jython.jar");
            File file4 = PydevPlugin.getScriptWithinPySrc((String)"interpreterInfo.py");
            if (!file4.exists()) {
                throw new Exception("The file specified does not exist: " + file4);
            }
            JythonInterpreterManager jythonInterpreterManager = (JythonInterpreterManager)PydevPlugin.getJythonInterpreterManager();
            InterpreterInfo interpreterInfo = (InterpreterInfo)jythonInterpreterManager.createInterpreterInfo(file3.getAbsolutePath(), iProgressMonitor, false);
            if (interpreterInfo == null) {
                return;
            }
            List list = JavaVmLocationFinder.findDefaultJavaJars();
            for (Object object2 : list) {
                interpreterInfo.libs.add(REF.getFileAbsolutePath((File)object2));
            }
            object2 = LibsLocationFinder.findWorkspaceLibs();
            interpreterInfo.libs.addAll(object2);
            interpreterInfo.restoreCompiledLibs(iProgressMonitor);
            interpreterInfo.setName(string);
            HashSet hashSet = new HashSet(1);
            hashSet.add(string);
            jythonInterpreterManager.setInfos(new IInterpreterInfo[]{interpreterInfo}, (Set)hashSet, iProgressMonitor);
            logger.info("Jython interpreter registered: " + string);
            PydevPlugin.getWorkspace().save(true, iProgressMonitor);
            logger.info("Workspace saved with interpreter: " + string);
        }
    }
}

