/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.ui.console.IHyperlink;
import org.python.pydev.core.tooltips.presenter.AbstractTooltipInformationPresenter;
import org.python.pydev.core.tooltips.presenter.StyleRangeWithCustomData;
import org.python.pydev.debug.pyunit.PyUnitTestResult;
import org.python.pydev.debug.ui.ILinkContainer;
import org.python.pydev.debug.ui.PythonConsoleLineTracker;

public class InformationPresenterWithLineTracker
extends AbstractTooltipInformationPresenter {
    protected void onUpdatePresentation(final String hoverInfo, final TextPresentation presentation) {
        if (hoverInfo == null || hoverInfo.length() == 0) {
            return;
        }
        int firstSpace = hoverInfo.indexOf(32);
        if (firstSpace > 0) {
            StyleRangeWithCustomData range = new StyleRangeWithCustomData();
            range.fontStyle = 1;
            range.underline = true;
            try {
                range.underlineStyle = 4;
            }
            catch (Throwable throwable) {}
            range.start = 0;
            range.length = firstSpace;
            if (this.data instanceof PyUnitTestResult) {
                final PyUnitTestResult pyUnitTestResult = (PyUnitTestResult)this.data;
                range.customData = new IHyperlink(){

                    public void linkExited() {
                    }

                    public void linkEntered() {
                    }

                    public void linkActivated() {
                        pyUnitTestResult.open();
                    }
                };
            }
            presentation.addStyleRange((StyleRange)range);
        }
        PythonConsoleLineTracker lineTracker = new PythonConsoleLineTracker();
        lineTracker.init(new ILinkContainer(){

            public void addLink(IHyperlink link, int offset, int length) {
                StyleRangeWithCustomData range = new StyleRangeWithCustomData();
                range.underline = true;
                try {
                    range.underlineStyle = 4;
                }
                catch (Throwable throwable) {}
                range.start = offset;
                range.length = length + 1;
                range.customData = link;
                presentation.addStyleRange((StyleRange)range);
            }

            public String getContents(int lineOffset, int lineLength) throws BadLocationException {
                if (lineLength <= 0) {
                    return "";
                }
                return hoverInfo.substring(lineOffset, lineOffset + lineLength + 1);
            }
        });
        lineTracker.splitInLinesAndAppendToLineTracker(hoverInfo);
    }

    protected void onHandleClick(Object data) {
        if (data instanceof IHyperlink) {
            this.hideInformationControl(false, false);
            ((IHyperlink)data).linkActivated();
        }
    }
}

