/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcNoSuchHandlerException;
import org.apache.xmlrpc.server.XmlRpcStreamServer;
import org.apache.xmlrpc.webserver.WebServer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.newconsole.IPydevXmlRpcClient;
import org.python.pydev.debug.newconsole.PydevXmlRpcClient;
import org.python.pydev.debug.newconsole.prefs.InteractiveConsolePrefs;
import org.python.pydev.dltk.console.IScriptConsoleCommunication;
import org.python.pydev.dltk.console.InterpreterResponse;
import org.python.pydev.editor.codecompletion.AbstractPyCodeCompletion;
import org.python.pydev.editor.codecompletion.PyCalltipsContextInformation;
import org.python.pydev.editor.codecompletion.PyCodeCompletionImages;
import org.python.pydev.editor.codecompletion.PyLinkedModeCompletionProposal;
import org.python.pydev.runners.ThreadStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PydevConsoleCommunication
implements IScriptConsoleCommunication,
XmlRpcHandler {
    private IPydevXmlRpcClient client;
    private final ThreadStreamReader stdOutReader;
    private final ThreadStreamReader stdErrReader;
    private WebServer webServer;
    private volatile boolean waitingForInput;
    private volatile String inputReceived;
    private volatile InterpreterResponse nextResponse;
    private volatile Object lock = new Object();
    private volatile Object lock2 = new Object();
    private volatile boolean firstCommWorked = false;

    public PydevConsoleCommunication(int port, Process process, int clientPort) throws Exception {
        this.stdOutReader = new ThreadStreamReader(process.getInputStream());
        this.stdErrReader = new ThreadStreamReader(process.getErrorStream());
        this.stdOutReader.start();
        this.stdErrReader.start();
        this.webServer = new WebServer(clientPort);
        XmlRpcStreamServer serverToHandleRawInput = this.webServer.getXmlRpcServer();
        serverToHandleRawInput.setHandlerMapping(new XmlRpcHandlerMapping(){

            public XmlRpcHandler getHandler(String handlerName) throws XmlRpcNoSuchHandlerException, XmlRpcException {
                return PydevConsoleCommunication.this;
            }
        });
        this.webServer.start();
        PydevXmlRpcClient client = new PydevXmlRpcClient(process, this.stdErrReader, this.stdOutReader);
        client.setPort(port);
        this.client = client;
    }

    public void close() throws Exception {
        if (this.client != null) {
            Job job = new Job("Close console communication"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        PydevConsoleCommunication.this.client.execute("close", new Object[0]);
                    }
                    catch (Exception exception) {}
                    PydevConsoleCommunication.this.client = null;
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        if (this.webServer != null) {
            this.webServer.shutdown();
            this.webServer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(XmlRpcRequest request) throws XmlRpcException {
        this.waitingForInput = true;
        this.inputReceived = null;
        boolean needInput = true;
        String stdOutContents = this.stdOutReader.getAndClearContents();
        String stderrContents = this.stdErrReader.getAndClearContents();
        this.nextResponse = new InterpreterResponse(stdOutContents, stderrContents, false, needInput);
        while (this.inputReceived == null) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(10L);
                }
                catch (InterruptedException e) {
                    Log.log((Throwable)e);
                }
            }
        }
        return this.inputReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execInterpreter(final String command, ICallback<Object, InterpreterResponse> onResponseReceived, ICallback<Object, Tuple<String, String>> onContentsReceived) {
        this.nextResponse = null;
        if (this.waitingForInput) {
            this.inputReceived = command;
            this.waitingForInput = false;
        } else {
            Job job = new Job("PyDev Console Communication"){

                private Tuple<String, Boolean> exec() throws XmlRpcException {
                    boolean more;
                    Object[] execute = (Object[])PydevConsoleCommunication.this.client.execute("addExec", new Object[]{command});
                    Object object = execute[0];
                    String errorContents = null;
                    if (object instanceof Boolean) {
                        more = (Boolean)object;
                    } else {
                        String str = object.toString();
                        String lower = str.toLowerCase();
                        if (lower.equals("true") || lower.equals("1")) {
                            more = true;
                        } else if (lower.equals("false") || lower.equals("0")) {
                            more = false;
                        } else {
                            more = false;
                            errorContents = str;
                        }
                    }
                    return new Tuple(errorContents, (Object)more);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    boolean needInput = false;
                    try {
                        Tuple<String, Boolean> executed = null;
                        int commAttempts = 0;
                        int maximumAttempts = InteractiveConsolePrefs.getMaximumAttempts();
                        while (true) {
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            executed = this.exec();
                            String refusedConnPattern = "Failed to read servers response";
                            if (executed.o1 == null || ((String)executed.o1).indexOf(refusedConnPattern) == -1 || PydevConsoleCommunication.this.firstCommWorked || commAttempts >= maximumAttempts) break;
                            ++commAttempts;
                            Thread.sleep(250L);
                            executed.o1 = PydevConsoleCommunication.this.stdErrReader.getAndClearContents();
                        }
                        PydevConsoleCommunication.this.firstCommWorked = true;
                        String errorContents = (String)executed.o1;
                        boolean more = (Boolean)executed.o2;
                        errorContents = errorContents == null ? PydevConsoleCommunication.this.stdErrReader.getAndClearContents() : String.valueOf(errorContents) + "\n" + PydevConsoleCommunication.this.stdErrReader.getAndClearContents();
                        String stdOutContents = PydevConsoleCommunication.this.stdOutReader.getAndClearContents();
                        PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(stdOutContents, errorContents, more, needInput);
                    }
                    catch (Exception e) {
                        PydevConsoleCommunication.this.nextResponse = new InterpreterResponse("", "Exception while pushing line to console:" + e.getMessage(), false, needInput);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        int i = 500;
        while (this.nextResponse == null) {
            Object object = this.lock2;
            synchronized (object) {
                try {
                    this.lock2.wait(20L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if ((i -= 20) > 0 || this.nextResponse != null) continue;
            i = 250;
            String stderrContents = this.stdErrReader.getAndClearContents();
            String stdOutContents = this.stdOutReader.getAndClearContents();
            if (stdOutContents.length() <= 0 && stderrContents.length() <= 0) continue;
            onContentsReceived.call((Object)new Tuple((Object)stdOutContents, (Object)stderrContents));
        }
        onResponseReceived.call((Object)this.nextResponse);
    }

    public ICompletionProposal[] getCompletions(String text, String actTok, int offset) throws Exception {
        if (this.waitingForInput) {
            return new ICompletionProposal[0];
        }
        Object fromServer = this.client.execute("getCompletions", new Object[]{text, actTok});
        ArrayList<ICompletionProposal> ret = new ArrayList<ICompletionProposal>();
        PydevConsoleCommunication.convertToICompletions(text, actTok, offset, fromServer, ret);
        ICompletionProposal[] proposals = ret.toArray(new ICompletionProposal[ret.size()]);
        return proposals;
    }

    public static void convertToICompletions(String text, String actTok, int offset, Object fromServer, List<ICompletionProposal> ret) {
        if (fromServer instanceof Object[]) {
            Object[] objects = (Object[])fromServer;
            fromServer = Arrays.asList(objects);
        }
        if (fromServer instanceof List) {
            int length = actTok.lastIndexOf(46);
            length = length == -1 ? actTok.length() : actTok.length() - length - 1;
            List<Object> comps = fromServer;
            for (Object o : comps) {
                if (!(o instanceof Object[])) continue;
                Object[] comp = (Object[])o;
                String name = (String)comp[0];
                String docStr = (String)comp[1];
                int type = PydevConsoleCommunication.extractInt(comp[3]);
                String args = AbstractPyCodeCompletion.getArgs((String)((String)comp[2]), (int)type, (int)1);
                String nameAndArgs = String.valueOf(name) + args;
                int priority = 10;
                if (type == 9) {
                    priority = -1;
                } else if (type == 5) {
                    priority = 0;
                }
                int cursorPos = name.length();
                if (args.length() > 1) {
                    ++cursorPos;
                }
                int replacementOffset = offset - length;
                PyCalltipsContextInformation pyContextInformation = null;
                if (args.length() > 2) {
                    pyContextInformation = new PyCalltipsContextInformation(args, replacementOffset + name.length() + 1);
                } else if (name.length() > 0) {
                    if (name.charAt(0) == '%') {
                        --replacementOffset;
                    } else if (name.charAt(0) == '/') {
                        char[] chars = text.toCharArray();
                        int i = 0;
                        while (i < chars.length) {
                            String sub;
                            char c = chars[i];
                            if (c == name.charAt(0) && name.startsWith(sub = text.substring(i, text.length()))) {
                                replacementOffset -= sub.length() - FullRepIterable.getLastPart((String)actTok).length();
                                break;
                            }
                            ++i;
                        }
                    }
                }
                ret.add((ICompletionProposal)new PyLinkedModeCompletionProposal(nameAndArgs, replacementOffset, length, cursorPos, PyCodeCompletionImages.getImageForType((int)type), nameAndArgs, (IContextInformation)pyContextInformation, docStr, priority, 1, args, false));
            }
        }
    }

    private static int extractInt(Object objToGetInt) {
        if (objToGetInt instanceof Integer) {
            return (Integer)objToGetInt;
        }
        return Integer.parseInt(objToGetInt.toString());
    }

    public String getDescription(String text) throws Exception {
        if (this.waitingForInput) {
            return "Unable to get description: waiting for input.";
        }
        return this.client.execute("getDescription", new Object[]{text}).toString();
    }
}

