/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.PyThread;
import org.python.pydev.debug.ui.actions.ISetNextTarget;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.plugin.PydevPlugin;

public class PySetNextTarget
implements ISetNextTarget {
    public boolean canSetNextToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        return true;
    }

    public boolean setNextToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        PyStackFrame stack = null;
        if (target instanceof PyStackFrame) {
            stack = (PyStackFrame)target;
            target = stack.getThread();
        }
        if (!(part instanceof PyEdit)) {
            return false;
        }
        PyEdit pyEdit = (PyEdit)part;
        SimpleNode ast = pyEdit.getAST();
        if (ast == null) {
            SourceModule sourceModule;
            IDocument doc = pyEdit.getDocument();
            IPythonNature nature = null;
            try {
                nature = pyEdit.getPythonNature();
            }
            catch (MisconfigurationException e) {
                File editorFile = pyEdit.getEditorFile();
                if (editorFile == null || !editorFile.exists()) {
                    Log.log((Throwable)e);
                    return false;
                }
                nature = (IPythonNature)PydevPlugin.getInfoForFile((File)editorFile).o1;
            }
            if (nature == null) {
                Log.log((String)"Unable to determine nature!");
                return false;
            }
            try {
                sourceModule = AbstractModule.createModuleFromDoc((String)"", null, (IDocument)doc, (IGrammarVersionProvider)nature, (boolean)true);
            }
            catch (MisconfigurationException e) {
                Log.log((Throwable)e);
                return false;
            }
            ast = sourceModule.getAst();
        }
        if (ast == null) {
            Log.log((String)"Cannot determine context to run to.");
            return false;
        }
        if (target instanceof PyThread && selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            PyThread pyThread = (PyThread)target;
            if (!pyThread.isPydevThread()) {
                int targetLine;
                int sourceLine = stack.getLineNumber();
                if (!NodeUtils.isValidContextForSetNext((SimpleNode)ast, (int)sourceLine, (int)(targetLine = textSelection.getStartLine()))) {
                    return false;
                }
                String functionName = NodeUtils.getContextName((int)targetLine, (SimpleNode)ast);
                functionName = functionName == null ? "" : FullRepIterable.getLastPart((String)functionName).trim();
                pyThread.setNextStatement(targetLine + 1, functionName);
                return true;
            }
        }
        return true;
    }
}

