/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.codecoverage;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.debug.codecoverage.ICoverageLeafNode;
import org.python.pydev.debug.codecoverage.PyCoveragePreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileNode
implements ICoverageLeafNode {
    public File node;
    public int stmts;
    public int miss;
    public String notExecuted;

    public boolean equals(Object obj) {
        if (!(obj instanceof FileNode)) {
            return false;
        }
        FileNode f = (FileNode)obj;
        return f.node.equals(this.node) && f.miss == this.miss && f.notExecuted.equals(this.notExecuted) && f.stmts == this.stmts;
    }

    public int hashCode() {
        return this.node.hashCode() * 3 + (this.miss + 1) * 7 + (this.stmts + 1) * 5;
    }

    public String toString() {
        FastStringBuffer buf = new FastStringBuffer();
        FileNode.appendToBuffer(buf, this.node.toString(), this.stmts, this.miss, this.notExecuted, PyCoveragePreferences.getNameNumberOfColumns());
        return buf.toString();
    }

    public FastStringBuffer appendToBuffer(FastStringBuffer buffer, String baseLocation, int nameNumberOfColumns) {
        String name = this.node.toString();
        if (name.toLowerCase().startsWith(baseLocation.toLowerCase())) {
            name = name.substring(baseLocation.length());
        }
        if (name.startsWith("/") || name.startsWith("\\")) {
            name = name.substring(1);
        }
        if (name.length() == 0) {
            name = this.node.getName();
        }
        return FileNode.appendToBuffer(buffer, name, this.stmts, this.miss, this.notExecuted, nameNumberOfColumns);
    }

    public static FastStringBuffer appendToBuffer(FastStringBuffer buffer, String str, int stmts, int miss, String notExecuted, int nameNumberOfColumns) {
        buffer.append(FileNode.getName(str, nameNumberOfColumns)).append("   ").append(FileNode.getStmts(stmts)).append("     ").append(FileNode.getStmts(miss)).append("      ").append(FileNode.calcCover(stmts, miss)).append("  ").append(notExecuted);
        return buffer;
    }

    public static String getName(String str, int nameNumberOfColumns) {
        FastStringBuffer buffer = new FastStringBuffer(str, str.length() > nameNumberOfColumns ? 0 : nameNumberOfColumns - str.length());
        if (buffer.length() > nameNumberOfColumns) {
            buffer = buffer.delete(0, Math.abs(nameNumberOfColumns - 2 - str.length()));
            buffer.insert(0, "..");
        }
        if (buffer.length() < nameNumberOfColumns) {
            buffer.appendN(' ', nameNumberOfColumns - str.length());
        }
        return buffer.toString();
    }

    private static String getStmts(int stmts) {
        FastStringBuffer str = new FastStringBuffer();
        if (stmts == 0) {
            str.append('-');
        } else {
            str.append(stmts);
        }
        while (str.length() < 4) {
            str.insert(0, ' ');
        }
        return str.toString();
    }

    public static String calcCover(int stmts, int miss) {
        double v = 0.0;
        if (stmts <= 0) {
            return "   - ";
        }
        v = ((double)stmts - (double)miss) / (double)stmts * 100.0;
        DecimalFormat format = new DecimalFormat("###.#");
        String str = format.format(v);
        str = String.valueOf(str) + "%";
        while (str.length() < 5) {
            str = " " + str;
        }
        return str;
    }

    public Iterator<Tuple<Integer, Integer>> notExecutedIterator() {
        ArrayList<Tuple> l = new ArrayList<Tuple>();
        String[] toks = this.notExecuted.replaceAll(" ", "").split(",");
        int i = 0;
        while (i < toks.length) {
            String tok = toks[i].trim();
            if (tok.length() != 0) {
                if (tok.indexOf("-") == -1) {
                    Integer startEnd = new Integer(tok);
                    l.add(new Tuple((Object)startEnd, (Object)startEnd));
                } else {
                    String[] begEnd = tok.split("-");
                    l.add(new Tuple((Object)Integer.parseInt(begEnd[0]), (Object)Integer.parseInt(begEnd[1])));
                }
            }
            ++i;
        }
        return l.iterator();
    }
}

