/*
 * Decompiled with CFR 0.152.
 */
package com.swtdesigner;

import com.swtdesigner.SWTResourceManager;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.osgi.framework.Bundle;

public class ResourceManager
extends SWTResourceManager {
    private static Map<ImageDescriptor, Image> m_descriptorImageMap = new HashMap<ImageDescriptor, Image>();
    private static Map<Image, Map<Image, Image>>[] m_decoratedImageMap = new Map[5];
    private static Map<String, Image> m_URLImageMap = new HashMap<String, Image>();
    private static PluginResourceProvider m_designTimePluginResourceProvider = null;

    public static ImageDescriptor getImageDescriptor(Class<?> clazz, String string) {
        return ImageDescriptor.createFromFile(clazz, (String)string);
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        try {
            return ImageDescriptor.createFromURL((URL)new File(string).toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        Image image = m_descriptorImageMap.get(imageDescriptor);
        if (image == null) {
            image = imageDescriptor.createImage();
            m_descriptorImageMap.put(imageDescriptor, image);
        }
        return image;
    }

    public static Image decorateImage(Image image, Image image2) {
        return ResourceManager.decorateImage(image, image2, 4);
    }

    public static Image decorateImage(final Image image, final Image image2, final int n) {
        Image image3;
        Map<Image, Image> map;
        if (n <= 0 || n >= 5) {
            throw new IllegalArgumentException("Wrong decorate corner");
        }
        Map<Image, Map<Image, Image>> map2 = m_decoratedImageMap[n];
        if (map2 == null) {
            ResourceManager.m_decoratedImageMap[n] = map2 = new HashMap<Image, Map<Image, Image>>();
        }
        if ((map = map2.get(image)) == null) {
            map = new HashMap<Image, Image>();
            map2.put(image, map);
        }
        if ((image3 = map.get(image2)) == null) {
            final Rectangle rectangle = image.getBounds();
            final Rectangle rectangle2 = image2.getBounds();
            final Point point = new Point(rectangle.width, rectangle.height);
            CompositeImageDescriptor compositeImageDescriptor = new CompositeImageDescriptor(){

                protected void drawCompositeImage(int n3, int n2) {
                    this.drawImage(image.getImageData(), 0, 0);
                    if (n == 1) {
                        this.drawImage(image2.getImageData(), 0, 0);
                    } else if (n == 2) {
                        this.drawImage(image2.getImageData(), rectangle.width - rectangle2.width, 0);
                    } else if (n == 3) {
                        this.drawImage(image2.getImageData(), 0, rectangle.height - rectangle2.height);
                    } else if (n == 4) {
                        this.drawImage(image2.getImageData(), rectangle.width - rectangle2.width, rectangle.height - rectangle2.height);
                    }
                }

                protected Point getSize() {
                    return point;
                }
            };
            image3 = compositeImageDescriptor.createImage();
            map.put(image2, image3);
        }
        return image3;
    }

    public static void disposeImages() {
        SWTResourceManager.disposeImages();
        Iterator<Image> iterator = m_descriptorImageMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        m_descriptorImageMap.clear();
        int n = 0;
        while (n < m_decoratedImageMap.length) {
            Map<Image, Map<Image, Image>> map = m_decoratedImageMap[n];
            if (map != null) {
                for (Map<Image, Image> map2 : map.values()) {
                    for (Image image : map2.values()) {
                        image.dispose();
                    }
                    map2.clear();
                }
                map.clear();
            }
            ++n;
        }
        Iterator<Image> iterator2 = m_URLImageMap.values().iterator();
        while (iterator2.hasNext()) {
            iterator2.next().dispose();
        }
        m_URLImageMap.clear();
    }

    @Deprecated
    public static Image getPluginImage(Object object, String string) {
        try {
            URL uRL = ResourceManager.getPluginImageURL(object, string);
            if (uRL != null) {
                return ResourceManager.getPluginImageFromUrl(uRL);
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    public static Image getPluginImage(String string, String string2) {
        try {
            URL uRL = ResourceManager.getPluginImageURL(string, string2);
            if (uRL != null) {
                return ResourceManager.getPluginImageFromUrl(uRL);
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    private static Image getPluginImageFromUrl(URL uRL) {
        try {
            String string = uRL.toExternalForm();
            Image image = m_URLImageMap.get(string);
            if (image == null) {
                InputStream inputStream = uRL.openStream();
                try {
                    image = ResourceManager.getImage(inputStream);
                    m_URLImageMap.put(string, image);
                }
                finally {
                    inputStream.close();
                }
            }
            return image;
        }
        catch (Throwable throwable) {
            try {
            }
            catch (Throwable throwable2) {}
            return null;
        }
    }

    @Deprecated
    public static ImageDescriptor getPluginImageDescriptor(Object object, String string) {
        try {
            URL uRL = ResourceManager.getPluginImageURL(object, string);
            return ImageDescriptor.createFromURL((URL)uRL);
        }
        catch (Throwable throwable) {
            try {
            }
            catch (Throwable throwable2) {}
            return null;
        }
    }

    public static ImageDescriptor getPluginImageDescriptor(String string, String string2) {
        try {
            URL uRL = ResourceManager.getPluginImageURL(string, string2);
            if (uRL != null) {
                return ImageDescriptor.createFromURL((URL)uRL);
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    private static URL getPluginImageURL(String string, String string2) {
        Bundle bundle = Platform.getBundle((String)string);
        if (bundle != null) {
            return bundle.getEntry(string2);
        }
        if (m_designTimePluginResourceProvider != null) {
            return m_designTimePluginResourceProvider.getEntry(string, string2);
        }
        return null;
    }

    private static URL getPluginImageURL(Object object, String string) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        try {
            clazz2 = Class.forName("org.osgi.framework.Bundle");
            clazz = Class.forName("org.osgi.framework.BundleContext");
            if (clazz.isAssignableFrom(object.getClass())) {
                Method method = clazz.getMethod("getBundle", new Class[0]);
                Object object2 = method.invoke(object, new Object[0]);
                Class<?> clazz3 = Class.forName("org.eclipse.core.runtime.Path");
                Constructor<?> constructor = clazz3.getConstructor(String.class);
                Object obj = constructor.newInstance(string);
                Class<?> clazz4 = Class.forName("org.eclipse.core.runtime.IPath");
                Class<?> clazz5 = Class.forName("org.eclipse.core.runtime.Platform");
                Method method2 = clazz5.getMethod("find", clazz2, clazz4);
                return (URL)method2.invoke(null, object2, obj);
            }
        }
        catch (Throwable throwable) {}
        clazz2 = Class.forName("org.eclipse.core.runtime.Plugin");
        if (clazz2.isAssignableFrom(object.getClass())) {
            clazz = Class.forName("org.eclipse.core.runtime.Path");
            Constructor<?> constructor = clazz.getConstructor(String.class);
            Object obj = constructor.newInstance(string);
            Class<?> clazz6 = Class.forName("org.eclipse.core.runtime.IPath");
            Method method = clazz2.getMethod("find", clazz6);
            return (URL)method.invoke(object, obj);
        }
        return null;
    }

    public static void dispose() {
        ResourceManager.disposeColors();
        ResourceManager.disposeFonts();
        ResourceManager.disposeImages();
    }

    public static interface PluginResourceProvider {
        public URL getEntry(String var1, String var2);
    }
}

