/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.views;

import com.isencia.passerelle.util.ptolemy.FileParameter;
import com.isencia.passerelle.util.ptolemy.IAvailableChoices;
import com.isencia.passerelle.util.ptolemy.ResourceParameter;
import com.isencia.passerelle.util.ptolemy.StringChoiceParameter;
import com.isencia.passerelle.workbench.model.editor.ui.Activator;
import com.isencia.passerelle.workbench.model.editor.ui.properties.CellEditorAttribute;
import com.isencia.passerelle.workbench.model.editor.ui.views.ActorAttributesView;
import com.isencia.passerelle.workbench.model.ui.GeneralAttribute;
import com.isencia.passerelle.workbench.util.ListUtils;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import ptolemy.data.BooleanToken;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.StringAttribute;

public class VariableLabelProvider
extends ColumnLabelProvider {
    private final ActorAttributesView actorAttributesView;
    private final Font italicFont;
    private final Font boldFont;
    private final Image folderImage;
    private Image ticked;
    private Image unticked;

    public VariableLabelProvider(ActorAttributesView actorAttributesView) {
        this.actorAttributesView = actorAttributesView;
        FontData fontData = actorAttributesView.getViewSite().getShell().getFont().getFontData()[0];
        FontData fontData2 = new FontData(fontData.getName(), fontData.getHeight(), 2);
        this.italicFont = new Font(null, fontData2);
        fontData2 = new FontData(fontData.getName(), fontData.getHeight(), 1);
        this.boldFont = new Font(null, fontData2);
        this.folderImage = Activator.getImageDescriptor("icons/folder.png").createImage();
    }

    public String getText(Object object) {
        Object object2;
        if (object instanceof GeneralAttribute) {
            return ((GeneralAttribute)object).getValue();
        }
        if (object instanceof CellEditorAttribute && (object2 = ((CellEditorAttribute)object).getRendererText()) != null) {
            return object2;
        }
        object2 = (Attribute)object;
        if (object2 instanceof Variable) {
            IAvailableChoices iAvailableChoices;
            Map map;
            String string;
            Variable variable = (Variable)object2;
            try {
                if (variable.getToken() != null && variable.getToken() instanceof BooleanToken) {
                    return "";
                }
            }
            catch (Exception exception) {}
            String string2 = string = object == null ? "" : variable.getExpression();
            if (variable instanceof StringChoiceParameter && (map = (iAvailableChoices = ((StringChoiceParameter)variable).getAvailableChoices()).getVisibleChoices()) != null) {
                StringBuilder stringBuilder = new StringBuilder();
                List list = ListUtils.getList((String)string);
                if (list != null) {
                    int n = 0;
                    while (n < list.size()) {
                        stringBuilder.append((String)map.get(list.get(n)));
                        if (n < list.size() - 1) {
                            stringBuilder.append(", ");
                        }
                        ++n;
                    }
                }
                string = stringBuilder.toString();
            }
            return string;
        }
        if (object2 instanceof StringAttribute) {
            return ((StringAttribute)object2).getExpression();
        }
        return "";
    }

    public Image getImage(Object object) {
        if (object instanceof String) {
            return null;
        }
        if (object instanceof Variable) {
            Variable variable = (Variable)object;
            try {
                if (variable.getToken() != null && variable.getToken() instanceof BooleanToken) {
                    if (((BooleanToken)variable.getToken()).booleanValue()) {
                        if (this.ticked == null) {
                            this.ticked = Activator.getImageDescriptor("icons/ticked.png").createImage();
                        }
                        return this.ticked;
                    }
                    if (this.unticked == null) {
                        this.unticked = Activator.getImageDescriptor("icons/unticked.gif").createImage();
                    }
                    return this.unticked;
                }
            }
            catch (Exception exception) {}
        }
        if (object instanceof ResourceParameter) {
            return this.folderImage;
        }
        if (object instanceof FileParameter) {
            return this.folderImage;
        }
        return null;
    }

    public void update(ViewerCell viewerCell) {
        super.update(viewerCell);
    }

    public Font getFont(Object object) {
        boolean bl = this.actorAttributesView.canEditAttribute(object);
        if (bl) {
            if (object instanceof GeneralAttribute) {
                return this.boldFont;
            }
            return null;
        }
        return this.italicFont;
    }

    public Color getForeground(Object object) {
        boolean bl = this.actorAttributesView.canEditAttribute(object);
        if (bl) {
            return null;
        }
        return Display.getCurrent().getSystemColor(16);
    }

    public void dispose() {
        super.dispose();
        this.italicFont.dispose();
        this.folderImage.dispose();
        this.boldFont.dispose();
        if (this.ticked != null) {
            this.ticked.dispose();
        }
        if (this.unticked != null) {
            this.unticked.dispose();
        }
    }
}

