/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.views;

import com.isencia.passerelle.workbench.model.editor.ui.properties.CellEditorAttribute;
import com.isencia.passerelle.workbench.model.editor.ui.properties.EntityPropertySource;
import com.isencia.passerelle.workbench.model.editor.ui.views.ActorAttributesView;
import com.isencia.passerelle.workbench.model.ui.GeneralAttribute;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.BooleanToken;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.StringAttribute;

public class VariableEditingSupport
extends EditingSupport {
    private static Logger logger = LoggerFactory.getLogger(VariableEditingSupport.class);
    private ActorAttributesView actorAttributesView;

    public VariableEditingSupport(ActorAttributesView actorAttributesView, ColumnViewer columnViewer) {
        super(columnViewer);
        this.actorAttributesView = actorAttributesView;
    }

    protected CellEditor getCellEditor(Object object) {
        PropertyDescriptor propertyDescriptor = null;
        if (object instanceof CellEditorAttribute) {
            return ((CellEditorAttribute)object).createCellEditor(this.getViewer().getControl());
        }
        if (object instanceof GeneralAttribute) {
            if (((GeneralAttribute)object).getType().equals((Object)GeneralAttribute.ATTRIBUTE_TYPE.NAME)) {
                propertyDescriptor = new TextPropertyDescriptor((Object)(String.valueOf(VariableEditingSupport.class.getName()) + ".nameText"), "Name");
            }
        } else if (object instanceof Variable) {
            propertyDescriptor = EntityPropertySource.getPropertyDescriptor((Variable)object);
        } else if (object instanceof StringAttribute) {
            propertyDescriptor = EntityPropertySource.getPropertyDescriptor((Attribute)((StringAttribute)object), (Type)BaseType.STRING);
        }
        if (propertyDescriptor != null) {
            CellEditor cellEditor = propertyDescriptor.createPropertyEditor((Composite)this.getViewer().getControl());
            return cellEditor;
        }
        return null;
    }

    protected boolean canEdit(Object object) {
        if (object instanceof GeneralAttribute) {
            return ((GeneralAttribute)object).getType().equals((Object)GeneralAttribute.ATTRIBUTE_TYPE.NAME);
        }
        return true;
    }

    protected Object getValue(Object object) {
        if (object instanceof GeneralAttribute) {
            return ((GeneralAttribute)object).getValue();
        }
        if (object instanceof StringAttribute) {
            return ((StringAttribute)object).getExpression();
        }
        Variable variable = (Variable)object;
        try {
            if (!variable.isStringMode() && variable.getToken() != null && variable.getToken() instanceof BooleanToken) {
                return ((BooleanToken)variable.getToken()).booleanValue();
            }
        }
        catch (Exception exception) {
            logger.error("Cannot set read token from " + variable.getName(), (Throwable)exception);
        }
        return variable.getExpression();
    }

    public String showHelpSelectedParameter(Variable variable) {
        Variable variable2 = variable;
        if (variable.getContainer() != null) {
            String string = "com.isencia.passerelle.actor.conf";
            String string2 = variable.getContainer().getClass().getName().replace(".", "_");
            return String.valueOf(string) + "." + string2 + "_" + variable2.getName();
        }
        return "";
    }

    protected void setValue(Object object, Object object2) {
        try {
            if (object instanceof GeneralAttribute) {
                this.actorAttributesView.setActorName((GeneralAttribute)object, (String)object2);
            } else {
                this.actorAttributesView.setAttributeValue(object, object2);
            }
        }
        catch (Exception exception) {
            logger.error("Cannot set variable value " + object2, (Throwable)exception);
        }
    }
}

