/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.views;

import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteGroup;
import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteItemDefinition;
import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteItemFactory;
import com.isencia.passerelle.workbench.model.editor.ui.views.ActorPalettePage;
import com.isencia.passerelle.workbench.model.editor.ui.views.ActorTreeMenuProvider;
import com.isencia.passerelle.workbench.model.editor.ui.views.ActorTreeProvider;
import com.isencia.passerelle.workbench.model.editor.ui.views.DragTargetListener;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.GridData;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class ActorTreeViewerPage
extends ActorPalettePage
implements IAdaptable {
    private ActionRegistry actionRegistry;
    private FilteredTree tree;

    public ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public ActorTreeViewerPage(ActionRegistry actionRegistry) {
        this.actionRegistry = actionRegistry;
    }

    @Override
    protected TreeViewer createTreeViewer(Composite composite) {
        PatternFilter patternFilter = new PatternFilter();
        this.tree = new FilteredTree(composite, 770, patternFilter, true);
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeViewer treeViewer = this.tree.getViewer();
        return treeViewer;
    }

    @Override
    public Control getControl() {
        return this.tree;
    }

    @Override
    protected void initPage() {
        this.createContextMenus();
        this.getTreeViewer().getTree().addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent treeEvent) {
            }

            public void treeCollapsed(TreeEvent treeEvent) {
            }
        });
        this.getTreeViewer().getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent mouseEvent) {
                Widget widget = mouseEvent.widget;
                if (widget == ActorTreeViewerPage.this.getTreeViewer().getTree()) {
                    Point point = new Point(mouseEvent.x, mouseEvent.y);
                    TreeItem treeItem = ActorTreeViewerPage.this.getTreeViewer().getTree().getItem(point);
                    ActorTreeViewerPage.this.getTreeViewer().getTree().setToolTipText(ActorTreeViewerPage.this.getTooltip(treeItem));
                }
            }
        });
        List<PaletteGroup> list = PaletteItemFactory.getInstance().getPaletteGroups();
        for (PaletteGroup paletteGroup : list) {
            if (!paletteGroup.isExpanded()) continue;
            this.getTreeViewer().expandToLevel((Object)paletteGroup, 1);
        }
    }

    private void createContextMenus() {
        ActorTreeMenuProvider actorTreeMenuProvider = new ActorTreeMenuProvider((ISelectionProvider)this.getTreeViewer());
        Menu menu = actorTreeMenuProvider.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu("#Pop up", (MenuManager)actorTreeMenuProvider, this.getSite().getSelectionProvider());
    }

    private String getTooltip(TreeItem treeItem) {
        if (treeItem != null) {
            Object object = treeItem.getData();
            new StringBuffer();
            if (object instanceof PaletteItemDefinition) {
                return ((PaletteItemDefinition)object).getName();
            }
            if (object instanceof PaletteGroup) {
                return ((PaletteGroup)object).getName();
            }
            return "";
        }
        return "";
    }

    @Override
    protected void configTreeViewer() {
        ActorTreeProvider actorTreeProvider = new ActorTreeProvider();
        this.getTreeViewer().setContentProvider((IContentProvider)actorTreeProvider);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)actorTreeProvider);
        this.initRoot();
        int n = 3;
        Transfer[] transferArray = new Transfer[]{TemplateTransfer.getInstance()};
        transferArray = new Transfer[]{TemplateTransfer.getInstance()};
        DragTargetListener dragTargetListener = new DragTargetListener(this.getTreeViewer());
        this.getTreeViewer().addDragSupport(n, transferArray, (DragSourceListener)dragTargetListener);
    }

    private void initRoot() {
        PaletteItemFactory paletteItemFactory = PaletteItemFactory.getInstance();
        this.getTreeViewer().setInput((Object)paletteItemFactory.getPaletteGroups().toArray());
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void refresh() {
        this.getTreeViewer().refresh();
    }

    public Object getAdapter(Class clazz) {
        if (clazz == String.class) {
            return "Pallette";
        }
        return null;
    }
}

